/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.notes.NotesProtocol;
import com.elluminate.groupware.notes.module.CompoundNotesDocument;
import com.elluminate.groupware.notes.module.NotesBean;
import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.NotesIndex;
import com.elluminate.groupware.notes.module.StringsProperties;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.client.PlaybackClient;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NotesModule
extends AbstractClientModule
implements PropertyChangeListener {
    static final String NOTES_FILE_EXT = ".eln";
    static final String TEXT_FILE_EXT = ".txt";
    private static final String NOTES_DIR_NAME = "Notes";
    public static final String PREF_DIR_NAME = "Collaborate";
    private static final String INDEX_FILE_NAME = "Notes.ndx";
    private static final String LAST_AUTHOR_PREF = ".lastAuthor";
    private I18n i18n = I18n.create((Object)this);
    private NotesBean notesBean = null;
    final KeyStroke toolbarAccelerator = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Client client;
    private ClientList clientList;
    private ClientListener connectionListener;
    private PropertyChangeListener sessionIDDateListener;
    private File notesDirectory;
    private NotesIndex notesIndex;
    private PropertyChangeListener indexListener;
    private NotesDocument[] currentNotes;
    private String author;
    ConferencingEngine confEngine = null;
    private static final String MODULE_NAME = null;
    private ClientProvider clientProvider;
    private boolean moduleVisible = false;
    private Imps imps;
    private final String prefix = this.getClass().getName();
    private Preferences preferences;
    private Provider<NotesBean> beanProvider;
    private BooleanFeature showMenuFeature;
    private ComponentFeature notesPanelFeature;
    private FeatureBroker broker;
    private LoadFeature loadNotes;
    private ChairProtocol chairProtocol;

    @Inject
    public NotesModule(ComponentRegistrar registrar, ConferencingEngine ce) {
        registrar.registerComponent((Object)this);
        this.confEngine = ce;
    }

    @Inject
    public void initNotesBeanProvider(Provider<NotesBean> beanProvider) {
        this.beanProvider = beanProvider;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    protected NotesBean getNotesBean() {
        return this.notesBean;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("NotesModule.moduleIcon");
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    public void setModuleVisible(boolean visible) {
        this.moduleVisible = visible;
    }

    public boolean isModuleVisible() {
        return this.moduleVisible;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private File getPreferencesDir() {
        File dir = new File(Platform.getPreferencesDir(), Platform.cleanFilename((String)PREF_DIR_NAME, (boolean)false));
        return dir;
    }

    private void setupNotesIndex() {
        File prefsDir = this.getPreferencesDir();
        this.notesDirectory = new File(prefsDir, Platform.cleanFilename((String)NOTES_DIR_NAME, (boolean)true));
        File f = new File(prefsDir, Platform.cleanFilename((String)INDEX_FILE_NAME, (boolean)true));
        this.notesIndex = new NotesIndex(f, this.notesDirectory, NOTES_FILE_EXT);
    }

    protected void uninstallHook() {
        if (this.notesIndex != null) {
            if (this.notesIndex.isModified()) {
                try {
                    this.notesIndex.save();
                }
                catch (IOException ex) {
                    LogSupport.error((Object)this, (String)"uninstallHook", (String)ex.toString());
                }
            }
            this.notesIndex.removePropertyChangeListener(this.indexListener);
        }
        this.indexListener = null;
        this.notesIndex = null;
        this.notesDirectory = null;
    }

    public boolean requestClose() {
        this.setVisible(false);
        return true;
    }

    public boolean setVisible(boolean visible) {
        if (visible && ((Boolean)this.showMenuFeature.getValue()).booleanValue()) {
            this.broker.addFeature((Feature)this.notesPanelFeature);
        } else {
            visible = false;
            this.broker.removeFeature((Feature)this.notesPanelFeature);
        }
        try {
            if (visible && !this.notesIndex.isLoaded()) {
                this.notesIndex.load();
            }
        }
        catch (IOException ex) {
            LogSupport.error((Object)this, (String)"setVisible", (String)ex.toString());
        }
        this.setModuleVisible(visible);
        try {
            if (visible) {
                this.openOrCloseCurrentNotes();
            } else if (this.notesIndex != null && this.notesIndex.isModified()) {
                this.notesIndex.save();
            }
        }
        catch (IOException ex) {
            LogSupport.error((Object)this, (String)"setVisible", (String)ex.toString());
        }
        return visible;
    }

    private synchronized void openOrCloseCurrentNotes() {
        String id = this.clientList.getProperty("notesSessionID", null);
        Date date = NotesProtocol.parseSessionDateProperty((String)this.clientList.getProperty("notesSessionDate", ""));
        if (id != null && date != null && this.author != null) {
            NotesDocument ndoc;
            List list = this.notesIndex.getDocuments(id);
            NotesDocument[] ndocs = list != null ? list.toArray(new NotesDocument[0]) : null;
            NotesDocument[] oldDocs = this.currentNotes;
            if (ndocs != null && oldDocs != null && ndocs.length == oldDocs.length) {
                boolean changed = false;
                for (int i = 0; i < ndocs.length; ++i) {
                    ndoc = ndocs[i];
                    boolean found = false;
                    for (int j = 0; j < oldDocs.length; ++j) {
                        NotesDocument oldDoc = oldDocs[j];
                        if (ndoc != oldDoc) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    changed = true;
                    break;
                }
                if (!changed) {
                    return;
                }
            }
            if (oldDocs != null) {
                this.closeNotesDocument(oldDocs, this.notesIndex);
            }
            if (ndocs != null && ndocs.length != 0) {
                this.setCurrentNotes(ndocs);
            } else {
                File f = NotesModule.makeNotesFile(this.notesDirectory, id + NOTES_FILE_EXT);
                String sessName = this.client.getConferenceName().getDisplayName();
                ndoc = new NotesDocument(f, new Date(), id, date, sessName, this.author);
                this.notesIndex.addDocument(ndoc);
            }
        } else {
            NotesDocument[] ndocs = this.currentNotes;
            if (ndocs != null && ndocs.length != 0) {
                this.closeNotesDocument(ndocs, this.notesIndex);
            }
            this.setCurrentNotes(null);
        }
    }

    protected String getSessionName() {
        return this.client.getConferenceName() == null ? null : this.client.getConferenceName().getDisplayName();
    }

    private void closeNotesDocument(NotesDocument[] documents, NotesIndex notesIndex) {
        for (int i = 0; i < documents.length; ++i) {
            NotesDocument ndoc = documents[i];
            if (!(!ndoc.isModified() || ndoc.isNew() && ndoc.isEmpty())) {
                try {
                    ndoc.save();
                    if (this.notesBean.areSelectedNotes(ndoc)) continue;
                    ndoc.unloadNotes();
                }
                catch (IOException ex) {
                    LogSupport.error(NotesModule.class, (String)"closeNotesDocument", (String)ex.toString());
                }
                continue;
            }
            if (!ndoc.isNew()) continue;
            notesIndex.removeDocument(ndoc);
        }
    }

    NotesIndex getNotesIndex() {
        return this.notesIndex;
    }

    File getNotesDirectory() {
        return this.notesDirectory;
    }

    private void setCurrentNotes(NotesDocument[] currentNotes) {
        if (this.currentNotes != currentNotes) {
            this.currentNotes = currentNotes;
            this.notesBean.currentNotesChanged();
        }
    }

    NotesDocument[] getCurrentNotes() {
        return this.currentNotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentNotes(NotesDocument document) {
        if (this.currentNotes == null) {
            return false;
        }
        NotesDocument[] notesDocumentArray = this.currentNotes;
        synchronized (this.currentNotes) {
            ArrayList<NotesDocument> documents = new ArrayList<NotesDocument>();
            if (document instanceof CompoundNotesDocument) {
                NotesDocument[] ndocs = ((CompoundNotesDocument)document).getDocuments();
                for (int i = 0; i < ndocs.length; ++i) {
                    documents.add(ndocs[i]);
                }
            } else {
                documents.add(document);
            }
            for (NotesDocument ndoc : documents) {
                boolean found = false;
                for (int i = 0; this.currentNotes != null && i < this.currentNotes.length; ++i) {
                    if (ndoc != this.currentNotes[i]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    boolean isPlayingRecording() {
        return this.client instanceof PlaybackClient;
    }

    static File makeNotesFile(File directory, String filename) {
        String name;
        int pos = filename.lastIndexOf(46);
        String string = name = pos != -1 ? filename.substring(0, pos) : filename;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        int index = 1;
        File f = new File(directory, name + NOTES_FILE_EXT);
        while (f.exists()) {
            f = new File(directory, name + "-" + ++index + NOTES_FILE_EXT);
        }
        return f;
    }

    long getSessionTime() {
        SessionTimeAPI api = (SessionTimeAPI)this.imps.findBest(SessionTimeAPI.class);
        if (api != null) {
            return api.getSessionTime();
        }
        return Long.MIN_VALUE;
    }

    String getPreferredAuthor() {
        String prefix = this.getPrefix();
        Preferences prefs = this.getPreferences();
        return prefs.getSetting(prefix + LAST_AUTHOR_PREF, System.getProperty("user.name"));
    }

    void setPreferredAuthor(String author) {
        String prefix = this.getPrefix();
        Preferences prefs = this.getPreferences();
        prefs.setSetting(prefix + LAST_AUTHOR_PREF, author);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    private void addClient(ClientEvent e) {
        if (e.isMe()) {
            if (this.client.isPlayback()) {
                this.author = this.getPreferredAuthor();
            } else {
                this.author = this.clientList.get(e.getName()).getDisplayName();
                this.setPreferredAuthor(this.author);
            }
            if (this.isModuleVisible()) {
                this.openOrCloseCurrentNotes();
            }
        }
    }

    private void removeClient(ClientEvent e) {
        if (e.isMe()) {
            this.author = null;
            this.openOrCloseCurrentNotes();
        }
    }

    private void createFeatures() {
        this.showMenuFeature = this.broker.createBooleanFeature((Object)this, "/notes/showMenu", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_SHOWMENU), null);
        this.showMenuFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_SHOWMENU));
        this.showMenuFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_SHOWMENU));
        this.showMenuFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                NotesModule.this.setVisible((Boolean)NotesModule.this.showMenuFeature.getValue());
            }
        });
        this.broker.addFeature((Feature)this.showMenuFeature);
        this.notesPanelFeature = this.broker.createComponentFeature((Object)this, "/notes/notesPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return NotesModule.this.notesBean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_PANELTITLE), this.i18n.getString((PropertiesEnum)StringsProperties.NOTESMODULE_PANELTITLE));
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("eln");
        this.loadNotes = this.broker.createLoadFeature((Object)this, "/notes/loadNotes", NOTES_DIR_NAME, null);
        this.loadNotes.setFileTypes(fileTypes);
        this.loadNotes.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.NOTESMODULE_LOADFEATUREICON));
        this.loadNotes.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files != null) {
                    NotesModule.this.showMenuFeature.setValue((Object)true);
                    ((NotesBean)NotesModule.this.beanProvider.get()).importFiles(files.toArray(new File[files.size()]));
                }
            }
        });
    }

    public void cleanupUI() {
        if (this.notesIndex != null) {
            if (this.notesIndex.isModified()) {
                try {
                    this.notesIndex.save();
                }
                catch (IOException ex) {
                    LogSupport.error((Object)this, (String)"cleanupUI", (String)ex.toString());
                }
            }
            this.notesIndex.removePropertyChangeListener(this.indexListener);
        }
        this.indexListener = null;
        this.notesIndex = null;
        this.notesDirectory = null;
    }

    public void setupUI() {
        this.notesBean.start();
        this.createFeatures();
        this.setupNotesIndex();
        this.indexListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("entry")) {
                    NotesModule.this.openOrCloseCurrentNotes();
                }
            }
        };
        this.notesIndex.addPropertyChangeListener(this.indexListener);
    }

    public void attach() {
        this.notesBean = (NotesBean)this.beanProvider.get();
        this.notesBean.loadPreferences(this.getPrefix(), this.getPreferences());
        this.client = this.clientProvider.get();
        this.clientList = this.client.getClientList();
        this.connectionListener = new ClientListener(){

            public void onAddClient(ClientEvent e) {
                NotesModule.this.addClient(e);
            }

            public void onRemoveClient(ClientEvent e) {
                NotesModule.this.removeClient(e);
            }
        };
        this.clientList.addClientListener(this.connectionListener);
        this.clientList.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.sessionIDDateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NotesModule.this.openOrCloseCurrentNotes();
            }
        };
        this.clientList.addPropertyChangeListener("notesSessionID", this.sessionIDDateListener);
        this.clientList.addPropertyChangeListener("notesSessionDate", this.sessionIDDateListener);
    }

    public void detach() {
        this.notesBean.savePreferences(this.getPrefix(), this.getPreferences());
        this.clientList.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clientList.removePropertyChangeListener("notesSessionID", this.sessionIDDateListener);
        this.clientList.removePropertyChangeListener("notesSessionDate", this.sessionIDDateListener);
        this.sessionIDDateListener = null;
        this.clientList.removeClientListener(this.connectionListener);
        this.connectionListener = null;
        this.clientList = null;
        this.client = null;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String nm = propertyChangeEvent.getPropertyName();
        if (nm.equals("chair")) {
            Chair now = new Chair((Connection)this.client, propertyChangeEvent.getNewValue());
            this.broker.setFeaturePublished((Feature)this.loadNotes, now.isMe());
        }
    }
}

