/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.NotesBean;
import com.elluminate.groupware.notes.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;

public class NotesFontResize {
    protected static final String[] FONT_SIZE_STRINGS;
    protected static final int[] FONT_SIZE_VALUES;
    private static final I18n i18n;

    protected static int lookupFontSize(String s) {
        for (int ix = 0; ix < FONT_SIZE_STRINGS.length; ++ix) {
            if (!FONT_SIZE_STRINGS[ix].equals(s)) continue;
            return FONT_SIZE_VALUES[ix];
        }
        return -1;
    }

    protected static int lookupFontIndex(String size) {
        for (int ix = 0; ix < FONT_SIZE_STRINGS.length; ++ix) {
            if (!FONT_SIZE_STRINGS[ix].equals(size)) continue;
            return ix;
        }
        return NotesFontResize.getClosestFontSize(size);
    }

    private static int getClosestFontSize(String sizeStr) {
        int size = 12;
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException ex) {
            size = 12;
        }
        for (int ix = 0; ix < FONT_SIZE_VALUES.length; ++ix) {
            if (FONT_SIZE_VALUES[ix] != size && FONT_SIZE_VALUES[ix] <= size) continue;
            return ix;
        }
        return 0;
    }

    protected static int lookupNearestFontIndex(int reqValue) {
        int curDelta = Integer.MAX_VALUE;
        int curIdx = -1;
        for (int ix = 0; ix < FONT_SIZE_STRINGS.length; ++ix) {
            int delta = Math.abs(FONT_SIZE_VALUES[ix] - reqValue);
            if (delta == 0) {
                return ix;
            }
            if (delta >= curDelta) continue;
            curDelta = delta;
            curIdx = ix;
        }
        return curIdx;
    }

    static {
        i18n = I18n.create(NotesBean.class);
        int count = 0;
        String[] strings = null;
        int[] values = null;
        try {
            count = Integer.parseInt(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_FONTSIZEMENU_COUNT));
        }
        catch (Throwable t) {
            count = 0;
        }
        if (count > 0) {
            try {
                strings = new String[count];
                values = new int[count];
                for (int ix = 0; ix < count; ++ix) {
                    strings[ix] = i18n.getStringLegacy("NotesBean.fontSizeMenu" + (ix + 1));
                    values[ix] = Integer.parseInt(i18n.getStringLegacy("NotesBean.fontSizeValue" + (ix + 1)));
                }
            }
            catch (Throwable t) {
                strings = null;
                values = null;
            }
        }
        if (strings == null || values == null) {
            strings = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "28", "32", "36"};
            values = new int[strings.length];
            for (int ix = 0; ix < strings.length; ++ix) {
                values[ix] = Integer.parseInt(strings[ix]);
            }
        }
        try {
            int nominalDefault = Integer.parseInt(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DEFAULTSIZE));
        }
        catch (Throwable t) {
            int nominalDefault = 12;
        }
        try {
            int editorDefault = Integer.parseInt(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DEFAULTEDITSIZE));
        }
        catch (Throwable t) {
            int editorDefault = 12;
        }
        FONT_SIZE_STRINGS = strings;
        FONT_SIZE_VALUES = values;
    }
}

