/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.NoteComponent;
import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.NotesEditorChangeListener;
import com.elluminate.groupware.notes.module.NotesFontResizePopup;
import com.elluminate.groupware.notes.module.TextNote;
import com.elluminate.groupware.notes.module.event.FontSizeChangeEvent;
import com.elluminate.groupware.notes.module.event.FontSizeChangeListener;
import com.elluminate.groupware.notes.module.text.NotesResizableText;
import com.elluminate.groupware.notes.module.text.ResizeableText;
import com.elluminate.gui.event.PopupGestureHandler;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

class NotesEditor
extends JComponent
implements Scrollable,
Accessible {
    private AccessibleContext accessibleContext = null;
    private static final String FONT_SIZE_ACTION = "font-size-action";
    private TimeProvider timeProvider;
    private Cursor handCursor;
    private Cursor grabCursor;
    private NotesDocument document;
    private int leftMargin = 23;
    private String author;
    private NoteComponent selectedNoteComponent;
    private NoteComponent editedNoteComponent;
    private NoteComponent playedNoteComponent;
    private Note noteToSelect = null;
    private long lastPlayTime;
    private boolean draggingNoteComponent = false;
    private ResizeableText textResizer;
    private MouseListener textResizePopupListener;
    private MouseMotionListener componentDragListener;
    private PropertyChangeListener documentListener;
    private Object playbackLock = new Object();
    private LightweightTimer timeMonitor = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            NotesEditor.this.syncView();
        }
    });
    private Dimension preferredViewportSize;

    public NotesEditor(TimeProvider timeProvider, Cursor handCursor, Cursor grabCursor) {
        this.timeProvider = timeProvider;
        this.handCursor = handCursor;
        this.grabCursor = grabCursor;
        this.documentListener = new NotesEditorChangeListener(this);
        this.setLayout(new NotesLayout(new Insets(4, 4, 200, 4), 6));
        this.enableEvents(16L);
        this.initTextResizer();
        this.textResizePopupListener = new PopupGestureHandler((JPopupMenu)((Object)new NotesFontResizePopup(this.textResizer)));
        this.componentDragListener = new ComponentDragMouseListener();
        this.addMouseListener(this.textResizePopupListener);
    }

    protected ResizeableText getTextResizer() {
        return this.textResizer;
    }

    protected void addNewNoteComponent(Note note, boolean displayAuthorInNote) {
        NoteComponent ncomp = new NoteComponent(note, this.handCursor, this.grabCursor, this.textResizer.getTextSize(), displayAuthorInNote);
        this.add(ncomp);
        ncomp.addMouseListener(this.textResizePopupListener);
        ncomp.addMouseMotionListener(this.componentDragListener);
        ncomp.addKeyListener(new NotesKeyListener());
        ncomp.addFocusListener(new NotesFocusListener());
        if (note == this.noteToSelect) {
            this.noteToSelect = null;
            ncomp.requestFocus();
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.revalidate();
        this.repaint();
        this.checkMinimumDocumentCount(false);
    }

    private boolean checkMinimumDocumentCount(boolean forceNewNote) {
        if (this.document.getNoteCount() == 0 || forceNewNote) {
            TextNote textNote = new TextNote();
            textNote.setAuthor(this.author);
            try {
                textNote.getDocument().insertString(0, "", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            long sessionTime = this.timeProvider.getTime();
            if (sessionTime != Long.MIN_VALUE) {
                textNote.setTime(sessionTime);
            }
            this.noteToSelect = textNote;
            this.document.addNote(textNote);
            return true;
        }
        return false;
    }

    protected TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    private void initTextResizer() {
        this.textResizer = new NotesResizableText();
        this.textResizer.addFontSizeListener(new FontSizeChangeListener(){

            @Override
            public void fontSizeChanged(FontSizeChangeEvent e) {
                ArrayList<Component> compList = new ArrayList<Component>();
                for (int i = 0; i < NotesEditor.this.getComponentCount(); ++i) {
                    compList.add(NotesEditor.this.getComponent(i));
                    if (compList.size() != 10) continue;
                    this.processBatch(compList, e.getFontSize());
                    compList = new ArrayList();
                }
                if (!compList.isEmpty()) {
                    this.processBatch(compList, e.getFontSize());
                    compList = new ArrayList();
                }
            }

            private void processBatch(final List componentBatch, final int fontSize) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (NoteComponent comp : componentBatch) {
                            FontSizeAction a = new FontSizeAction(NotesEditor.FONT_SIZE_ACTION);
                            a.actionPerformed(new ActionEvent(comp, 0, Integer.toString(fontSize)));
                            comp.revalidate();
                            comp.repaint();
                        }
                    }
                });
            }
        });
    }

    public void addFontSizeChangeListener(FontSizeChangeListener l) {
        if (this.textResizer != null) {
            this.textResizer.addFontSizeListener(l);
        }
    }

    public void requestFocusInDocument() {
        if (this.editedNoteComponent != null) {
            this.editedNoteComponent.requestFocusInEditor();
        } else if (this.selectedNoteComponent != null) {
            this.selectedNoteComponent.requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocus();
        } else {
            this.requestFocus();
        }
    }

    private NotesLayout getNotesLayout() {
        return (NotesLayout)this.getLayout();
    }

    public NotesDocument getDocument() {
        return this.document;
    }

    public boolean isMoreThanOneAuthorInDocument(NotesDocument document) {
        Note[] notes = document.getNotes();
        if (notes == null) {
            return false;
        }
        boolean moreThanOneAuthorInDocument = false;
        String lastNoteAuthor = null;
        for (Note note : notes) {
            if (lastNoteAuthor != null && !note.getAuthor().equals(lastNoteAuthor)) {
                moreThanOneAuthorInDocument = true;
                break;
            }
            lastNoteAuthor = note.getAuthor();
        }
        return moreThanOneAuthorInDocument;
    }

    protected boolean shouldDisplayAuthorInNote(Note note, boolean moreThanOneAuthorInDocument) {
        String noteAuthor;
        if (note == null) {
            return false;
        }
        boolean displayAuthor = true;
        if (this.document.getAuthor().equals(this.author) && ((noteAuthor = note.getAuthor()) == null || noteAuthor.equals(this.author) && !moreThanOneAuthorInDocument)) {
            displayAuthor = false;
        }
        return displayAuthor;
    }

    protected void setAuthorDisplayInDocument(NotesDocument document) {
        if (document == null) {
            return;
        }
        Note[] notes = document.getNotes();
        if (notes == null) {
            return;
        }
        final boolean moreThanOneAuthorInDocument = this.isMoreThanOneAuthorInDocument(document);
        for (int i = 0; i < notes.length; ++i) {
            final Note note = notes[i];
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean displayAuthorInNote = NotesEditor.this.shouldDisplayAuthorInNote(note, moreThanOneAuthorInDocument);
                    NoteComponent noteComp = NotesEditor.this.getNoteComponent(note);
                    if (noteComp != null) {
                        noteComp.setIsUniqueAuthor(displayAuthorInNote);
                    }
                }
            });
        }
    }

    public void setDocument(NotesDocument document) {
        NotesDocument oldDoc = this.document;
        if (document == oldDoc) {
            return;
        }
        if (oldDoc != null) {
            this.cleanupOldDocument(oldDoc);
        }
        this.document = document;
        if (document != null) {
            document.addPropertyChangeListener(this.documentListener);
            boolean addedNote = this.checkMinimumDocumentCount(false);
            Note[] notes = document.getNotes();
            if (notes == null) {
                return;
            }
            final boolean moreThanOneAuthorInDocument = this.isMoreThanOneAuthorInDocument(document);
            if (!addedNote) {
                int i = 0;
                while (i < notes.length) {
                    final Note note = notes[i];
                    int theI = i++;
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean displayAuthorInNote = NotesEditor.this.shouldDisplayAuthorInNote(note, moreThanOneAuthorInDocument);
                            NotesEditor.this.addNewNoteComponent(note, displayAuthorInNote);
                        }
                    });
                }
                final Note fontSizeNote = notes[0];
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NotesEditor.this.setDocumentFontSize(fontSizeNote);
                    }
                });
                this.checkMinimumDocumentCount(true);
            }
        }
    }

    private void cleanupOldDocument(NotesDocument oldDoc) {
        oldDoc.removePropertyChangeListener(this.documentListener);
        this.removeAll();
        this.selectedNoteComponent = null;
        this.editedNoteComponent = null;
        this.playedNoteComponent = null;
    }

    private boolean setDocumentFontSize(Note note) {
        NoteComponent noteComp = this.getNoteComponent(note);
        JEditorPane editorPane = noteComp.getEditorPane();
        if (editorPane != null && editorPane.getEditorKit() instanceof StyledEditorKit) {
            StyledEditorKit styledKit = (StyledEditorKit)editorPane.getEditorKit();
            int compFontSize = StyleConstants.getFontSize(styledKit.getInputAttributes());
            this.textResizer.setTextSize(Integer.toString(compFontSize));
            return true;
        }
        return false;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void startTimeMonitor(int interval) {
        this.lastPlayTime = Long.MIN_VALUE;
        if (this.document != null && interval > 0) {
            this.timeMonitor.invoke();
            this.timeMonitor.scheduleEvery((long)interval);
        }
    }

    public void stopTimeMonitor() {
        this.timeMonitor.cancel();
        this.playNoteComponent(null);
    }

    private void syncView() {
        if (this.document == null) {
            this.stopTimeMonitor();
            return;
        }
        long currentTime = this.timeProvider.getTime();
        if (currentTime == Long.MIN_VALUE) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        if (currentTime != this.lastPlayTime) {
            NoteComponent ncomp = this.getNoteComponentAt(currentTime);
            if (ncomp != null) {
                this.playNoteComponent(ncomp);
            }
            this.lastPlayTime = currentTime;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension s = this.getSize();
        g.setColor(UIManager.getColor("Panel.background"));
        g.fillRect(0, 0, this.leftMargin, s.height);
        g.setColor(UIManager.getColor("EditorPane.background"));
        g.fillRect(this.leftMargin, 0, s.width - this.leftMargin, s.height);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(this.leftMargin, 0, this.leftMargin, s.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NoteComponent getNoteComponent(Note note) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                NoteComponent ncomp = (NoteComponent)this.getComponent(i);
                if (ncomp.getNote() != note) continue;
                return ncomp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NoteComponent getNoteComponentAt(long time) {
        NotesDocument notesDocument = this.document;
        synchronized (notesDocument) {
            NoteComponent ncomp = null;
            Note[] notes = this.document.getNotes();
            for (int i = 0; i < notes.length; ++i) {
                NoteComponent comp = this.getNoteComponent(notes[i]);
                if (comp == null) continue;
                if (comp.getNote().getTime() >= time) break;
                ncomp = comp;
            }
            return ncomp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NoteComponent[] getNoteComponentsAt(int y, Note inquiringNote) {
        NoteComponent prevComp = null;
        NoteComponent nextComp = null;
        NotesDocument notesDocument = this.document;
        synchronized (notesDocument) {
            Note[] notes = this.document.getNotes();
            for (int i = 0; i < notes.length; ++i) {
                boolean isSelectedAndEmpty;
                NoteComponent comp = this.getNoteComponent(notes[i]);
                if (comp == null || comp.getNote() == inquiringNote) continue;
                Rectangle b = comp.getBounds();
                boolean bl = isSelectedAndEmpty = comp.equals(this.selectedNoteComponent) && notes[i].isEmpty();
                if (b.y < y && !isSelectedAndEmpty) {
                    prevComp = comp;
                    continue;
                }
                if (y > b.y || isSelectedAndEmpty) continue;
                nextComp = comp;
                break;
            }
        }
        return new NoteComponent[]{prevComp, nextComp};
    }

    private void doDeleteAction(NoteComponent comp) {
        int index = this.document.getNoteIndex(comp.getNote());
        if (index == -1) {
            return;
        }
        int count = this.document.getNoteCount();
        if (count == 1) {
            comp.clear();
            return;
        }
        Note note = index + 1 < count ? this.document.getNote(index + 1) : this.document.getNote(index - 1);
        NoteComponent nextComponent = this.getNoteComponent(note);
        if (nextComponent == null) {
            return;
        }
        comp.removeOnFocusLoss();
        nextComponent.requestFocus();
    }

    private void doSelectAfterAction(NoteComponent comp) {
        int index = this.document.getNoteIndex(comp.getNote());
        if (index == -1) {
            return;
        }
        boolean empty = comp.getNote().isEmpty();
        if (index == this.document.getNoteCount() - 1 && empty) {
            return;
        }
        if (empty) {
            Note note = this.document.getNote(index + 1);
            NoteComponent nextComp = this.getNoteComponent(note);
            if (nextComp != null) {
                comp.removeOnFocusLoss();
                nextComp.requestFocus();
            }
        } else {
            long sessionTime;
            NoteComponent nextComp = null;
            if (index + 1 < this.document.getNoteCount()) {
                Note note = this.document.getNote(index + 1);
                nextComp = this.getNoteComponent(note);
            }
            if (nextComp != null) {
                long compTime = comp.getNote().getTime();
                long nextCompTime = nextComp.getNote().getTime();
                if (nextCompTime - compTime < 2L) {
                    this.changeTime(nextComp.getNote(), 2L - (nextCompTime - compTime));
                    nextCompTime = nextComp.getNote().getTime();
                }
                if ((sessionTime = compTime + (long)(0.5 * (double)(nextCompTime - compTime))) == compTime) {
                    ++sessionTime;
                } else if (sessionTime == nextCompTime) {
                    --sessionTime;
                }
            } else {
                sessionTime = this.timeProvider.getTime();
                long t1 = comp.getNote().getTime();
                if (sessionTime == Long.MIN_VALUE || sessionTime <= t1) {
                    sessionTime = t1 + 1000L;
                }
            }
            TextNote note = this.generateEmptyTextNote(sessionTime);
            this.noteToSelect = note;
            this.document.addNote(note);
        }
    }

    public TextNote generateEmptyTextNote(long sessionTime) {
        TextNote note = new TextNote();
        note.setAuthor(this.author);
        note.setTime(sessionTime);
        return note;
    }

    private void doSelectBeforeAction(NoteComponent comp) {
        int index = this.document.getNoteIndex(comp.getNote());
        if (index == -1) {
            return;
        }
        boolean empty = comp.getNote().isEmpty();
        if (index == 0 && empty) {
            return;
        }
        if (empty) {
            Note n = this.document.getNote(index - 1);
            NoteComponent prevComp = this.getNoteComponent(n);
            if (prevComp != null) {
                comp.removeOnFocusLoss();
                prevComp.requestFocus();
            }
        } else {
            long t;
            long t1;
            NoteComponent prevComp = null;
            if (index - 1 >= 0) {
                Note n = this.document.getNote(index - 1);
                prevComp = this.getNoteComponent(n);
            }
            if (prevComp != null) {
                t1 = prevComp.getNote().getTime();
                long t2 = comp.getNote().getTime();
                if (t2 - t1 < 2L) {
                    this.changeTime(comp.getNote(), 2L - (t2 - t1));
                    t2 = comp.getNote().getTime();
                }
                if ((t = t1 + (long)(0.5 * (double)(t2 - t1))) == t1) {
                    ++t;
                } else if (t == t2) {
                    --t;
                }
            } else {
                t = this.timeProvider.getTime();
                t1 = comp.getNote().getTime();
                if (t == Long.MIN_VALUE || t >= t1) {
                    t = t1 - 1000L;
                }
            }
            TextNote n = new TextNote();
            n.setAuthor(this.author);
            n.setTime(t);
            this.noteToSelect = n;
            this.document.addNote(n);
        }
    }

    private void doMoveBeforeAction(NoteComponent comp) {
        int index = this.document.getNoteIndex(comp.getNote());
        if (index == -1) {
            return;
        }
        if (index == 0) {
            return;
        }
        Note n = this.document.getNote(index - 1);
        NoteComponent prevComp = this.getNoteComponent(n);
        if (prevComp != null) {
            Point pos = prevComp.getLocation();
            this.calculateTimeAndOffset(comp.getNote(), pos.y - 1);
        }
    }

    private void doMoveAfterAction(NoteComponent comp) {
        int index = this.document.getNoteIndex(comp.getNote());
        if (index == -1) {
            return;
        }
        if (index == this.document.getNoteCount() - 1) {
            return;
        }
        Note n = this.document.getNote(index + 1);
        NoteComponent nextComp = this.getNoteComponent(n);
        if (nextComp != null) {
            Rectangle r = nextComp.getBounds();
            this.calculateTimeAndOffset(comp.getNote(), r.y + r.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playNoteComponent(final NoteComponent comp) {
        Object object = this.playbackLock;
        synchronized (object) {
            final NoteComponent oldComp = this.playedNoteComponent;
            if (oldComp != comp) {
                this.playedNoteComponent = comp;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (oldComp != null) {
                            oldComp.setIsPlayedNoteComponent(false);
                            oldComp.repaint();
                        }
                        if (NotesEditor.this.playedNoteComponent != null) {
                            NotesEditor.this.playedNoteComponent.setIsPlayedNoteComponent(true);
                            NotesEditor.this.scrollRectToVisible(comp.getBounds());
                            NotesEditor.this.playedNoteComponent.repaint();
                        }
                    }
                });
            }
        }
    }

    protected void calculateTimeAndOffset(Note note, int y) {
        Rectangle b2;
        NoteComponent[] comps = this.getNoteComponentsAt(y, note);
        NoteComponent prevComp = comps[0];
        NoteComponent nextComp = comps[1];
        Rectangle b1 = prevComp != null ? prevComp.getBounds() : null;
        Rectangle rectangle = b2 = nextComp != null ? nextComp.getBounds() : null;
        if (prevComp == null && nextComp == null) {
            note.setOffset(y - this.getNotesLayout().getMargin().top);
        } else if (prevComp != null && nextComp != null) {
            float prop;
            long t;
            long t1 = prevComp.getNote().getTime();
            long t2 = nextComp.getNote().getTime();
            if (t2 - t1 < 2L) {
                this.changeTime(nextComp.getNote(), 2L - (t2 - t1));
                t2 = nextComp.getNote().getTime();
            }
            if ((t = t1 + (long)((prop = ((float)y - (float)b1.y) / ((float)b2.y - (float)b1.y)) * (float)(t2 - t1))) == t1) {
                ++t;
            } else if (t == t2) {
                --t;
            }
            note.setTime(t);
            int off = Math.max(y - (b1.y + b1.height + this.getNotesLayout().getVerticalGap()), 0);
            note.setOffset(off);
        } else if (prevComp != null) {
            long t = this.timeProvider.getTime();
            long t1 = prevComp.getNote().getTime();
            if (t == Long.MIN_VALUE || t <= t1) {
                t = t1 + 1000L;
            }
            note.setTime(t);
            int off = Math.max(y - (b1.y + b1.height + this.getNotesLayout().getVerticalGap()), 0);
            note.setOffset(off);
        } else if (nextComp != null) {
            long t = this.timeProvider.getTime();
            long t2 = nextComp.getNote().getTime();
            if (t == Long.MIN_VALUE || t >= t2) {
                t = t2 - 1000L;
            }
            note.setTime(t);
            note.setOffset(y - this.getNotesLayout().getMargin().top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeTime(Note note, long timeChange) {
        NotesDocument notesDocument = this.document;
        synchronized (notesDocument) {
            int count = this.document.getNoteCount();
            int i = this.document.getNoteIndex(note);
            ArrayList<Note> notes = new ArrayList<Note>();
            Note thisNote = note;
            Note nextNote = ++i < count ? this.document.getNote(i) : null;
            while (true) {
                notes.add(0, thisNote);
                if (nextNote == null || thisNote.getTime() + timeChange < nextNote.getTime()) break;
                thisNote = nextNote;
                nextNote = ++i < count ? this.document.getNote(i) : null;
            }
            for (Note n : notes) {
                n.setTime(n.getTime() + timeChange);
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (this.document == null) break;
                if (this.selectedNoteComponent != null && this.selectedNoteComponent.getNote().isEmpty()) {
                    this.selectedNoteComponent.removeOnFocusLoss();
                }
                TextNote n = new TextNote();
                n.setAuthor(this.author);
                this.calculateTimeAndOffset(n, e.getY());
                this.noteToSelect = n;
                this.document.addNote(n);
            }
        }
        super.processMouseEvent(e);
    }

    public void setPreferredScrollableViewportSize(Dimension size) {
        this.preferredViewportSize = size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize != null ? this.preferredViewportSize : this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 16;
        }
        return 100;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int unit = this.getScrollableUnitIncrement(visibleRect, orientation, direction);
            return unit > 0 ? Math.max(unit, visibleRect.height / unit) * unit : visibleRect.height;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void doLayout() {
        if (!this.draggingNoteComponent) {
            super.doLayout();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNotesEditor();
        }
        return this.accessibleContext;
    }

    class AccessibleNotesEditor
    extends JComponent.AccessibleJComponent {
        AccessibleNotesEditor() {
            super(NotesEditor.this);
        }
    }

    private static class ChangeFontSizeAction
    extends StyledEditorKit.StyledTextAction {
        public static final int INCREASE = 1;
        public static final int DECREASE = 2;
        private int change;

        public ChangeFontSizeAction(String name, int change) {
            super(name);
            this.change = change;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                int size = StyleConstants.getFontSize(attr);
                switch (this.change) {
                    case 1: {
                        ++size;
                        break;
                    }
                    case 2: {
                        if (size > 1) {
                            --size;
                            break;
                        }
                    }
                    default: {
                        return;
                    }
                }
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setFontSize(sas, size);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    private class ComponentDragMouseListener
    implements MouseMotionListener {
        private ComponentDragMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            NoteComponent comp = (NoteComponent)e.getSource();
            Point pos = comp.getLocation();
            int y = pos.y + e.getY() - comp.getDragAnchor().y;
            comp.setLocation(pos.x, Math.max(y, ((NotesEditor)NotesEditor.this).getNotesLayout().getMargin().top));
            NotesEditor.this.draggingNoteComponent = true;
            NotesEditor.this.scrollRectToVisible(NotesEditor.this.getBounds());
            NotesEditor.this.draggingNoteComponent = false;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class FontSizeAction
    extends StyledEditorKit.StyledTextAction {
        public FontSizeAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editorPane = this.getEditor(e.getSource());
            if (editorPane != null) {
                int size = 10;
                try {
                    size = Integer.parseInt(e.getActionCommand());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (size != 0) {
                    this.setSelectedAreaToAll(editorPane);
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setFontSize(attr, size);
                    this.setCharacterAttributes(editorPane, attr, false);
                }
            }
        }

        private void setSelectedAreaToAll(JEditorPane editor) {
            editor.setSelectionStart(0);
            editor.setSelectionEnd(editor.getDocument().getLength());
        }

        private JEditorPane getEditor(Object source) {
            if (source != null && source instanceof NoteComponent) {
                return ((NoteComponent)source).getEditorPane();
            }
            return null;
        }
    }

    private class NotesFocusListener
    implements FocusListener {
        private NotesFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JEditorPane) {
                JEditorPane editorPane = (JEditorPane)e.getSource();
                NoteComponent comp = (NoteComponent)editorPane.getParent();
                NotesEditor.this.selectedNoteComponent = comp;
                NotesEditor.this.editedNoteComponent = comp;
                this.setVisibleToFocus(comp);
            }
            if (e.getSource() instanceof NoteComponent) {
                NoteComponent comp = (NoteComponent)e.getSource();
                NotesEditor.this.selectedNoteComponent = comp;
                this.setVisibleToFocus(comp);
            }
            NotesEditor.this.textResizer.getTextSize();
        }

        private void setVisibleToFocus(NoteComponent comp) {
            NotesEditor.this.scrollRectToVisible(comp.getBounds());
            comp.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            NotesDocument doc;
            NoteComponent comp = null;
            if (e.getSource() instanceof NoteComponent) {
                comp = (NoteComponent)e.getSource();
                this.flagComponentForRemoval(comp);
            }
            if (e.getSource() instanceof JEditorPane) {
                JEditorPane editorPane = (JEditorPane)e.getSource();
                comp = (NoteComponent)editorPane.getParent();
                if (comp.isShowing()) {
                    comp.resetAuthorLabel();
                }
                this.cleanupDocument(editorPane.getDocument());
                this.flagComponentForRemoval(comp);
            }
            comp.repaint();
            if (comp.isRemoveOnFocusLoss() && (doc = NotesEditor.this.getDocument()) != null) {
                final NoteComponent eComp = comp;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        doc.removeNote(eComp.getNote());
                    }
                });
            }
        }

        private void cleanupDocument(Document doc) {
            try {
                String text = doc.getText(0, doc.getLength());
                if (text.lastIndexOf(10) == text.length() - 1) {
                    doc.remove(doc.getLength() - 1, 1);
                    this.cleanupDocument(doc);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void flagComponentForRemoval(NoteComponent comp) {
            JEditorPane editorPane = comp.getEditorPane();
            if (editorPane != null && editorPane.getDocument().getLength() <= 0 && NotesEditor.this.getDocument() != null && NotesEditor.this.getDocument().getNoteCount() > 1) {
                comp.removeOnFocusLoss();
            }
        }
    }

    private class NotesKeyListener
    implements KeyListener {
        private NotesKeyListener() {
        }

        private void handleEditorKeyPressedEvent(KeyEvent e) {
            JEditorPane editorPane = (JEditorPane)e.getSource();
            NoteComponent ncomp = (NoteComponent)editorPane.getParent();
            switch (e.getKeyCode()) {
                case 10: {
                    NoteComponent comp = (NoteComponent)editorPane.getParent();
                    if (e.isAltDown() || comp.isEnteringList(e.getID())) break;
                    NotesEditor.this.doSelectAfterAction(comp);
                    break;
                }
                case 27: {
                    if (editorPane.getDocument().getLength() <= 0) {
                        NotesEditor.this.doSelectBeforeAction(ncomp);
                        break;
                    }
                    ncomp.requestFocus();
                }
            }
        }

        private void handleComponentKeyPressedEvent(KeyEvent e) {
            NoteComponent comp = (NoteComponent)e.getSource();
            switch (e.getKeyCode()) {
                case 38: 
                case 224: {
                    if (e.isAltDown()) {
                        NotesEditor.this.doMoveBeforeAction(comp);
                        break;
                    }
                    NotesEditor.this.doSelectBeforeAction(comp);
                    break;
                }
                case 40: 
                case 225: {
                    if (e.isAltDown()) {
                        NotesEditor.this.doMoveAfterAction(comp);
                        break;
                    }
                    NotesEditor.this.doSelectAfterAction(comp);
                    break;
                }
                case 27: {
                    comp.requestFocus();
                    break;
                }
                case 8: 
                case 127: {
                    NotesEditor.this.doDeleteAction(comp);
                    break;
                }
                case 10: {
                    if (e.isAltDown() || comp.isEnteringList(e.getID())) break;
                    NotesEditor.this.doSelectAfterAction(comp);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() instanceof JEditorPane) {
                this.handleEditorKeyPressedEvent(e);
            } else if (e.getSource() instanceof NoteComponent) {
                this.handleComponentKeyPressedEvent(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class NotesLayout
    implements LayoutManager {
        private Insets margin;
        private int verticalGap;

        public NotesLayout(Insets margin, int verticalGap) {
            this.margin = margin;
            this.verticalGap = verticalGap;
        }

        public Insets getMargin() {
            return this.margin;
        }

        public int getVerticalGap() {
            return this.verticalGap;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension s = container.getSize();
            Dimension ps = new Dimension(s.width, this.margin.top);
            if (NotesEditor.this.document != null) {
                NotesDocument notesDocument = NotesEditor.this.document;
                synchronized (notesDocument) {
                    Note[] notes = NotesEditor.this.document.getNotes();
                    for (int i = 0; i < notes.length; ++i) {
                        NoteComponent ncomp = NotesEditor.this.getNoteComponent(notes[i]);
                        if (ncomp == null) continue;
                        ps.height += ncomp.getNote().getOffset();
                        Dimension cps = ncomp.getPreferredSize();
                        ps.height += cps.height;
                        if (i + 1 >= notes.length) continue;
                        ps.height += this.verticalGap;
                    }
                }
                ps.height += this.margin.bottom;
                ps.height += this.margin.top;
            }
            return ps;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            if (NotesEditor.this.document == null) {
                return;
            }
            NotesDocument notesDocument = NotesEditor.this.document;
            synchronized (notesDocument) {
                Dimension s = container.getSize();
                Insets ins = container.getInsets();
                int w = s.width - ins.left - ins.right - this.margin.left - this.margin.right;
                int y = this.margin.top;
                int x = this.margin.left;
                Note[] notes = NotesEditor.this.document.getNotes();
                for (int i = 0; i < notes.length; ++i) {
                    Note n = notes[i];
                    NoteComponent ncomp = NotesEditor.this.getNoteComponent(n);
                    if (ncomp == null) continue;
                    int h = ncomp.getPreferredSize().height;
                    ncomp.setBounds(x, y += ncomp.getNote().getOffset(), w, h);
                    y += h + this.verticalGap;
                }
            }
        }
    }

    public static interface TimeProvider {
        public long getTime();
    }
}

