/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.imps.notes.NotesAPI;
import com.elluminate.groupware.notes.NotesDebug;
import com.elluminate.groupware.notes.module.CompoundNotesDocument;
import com.elluminate.groupware.notes.module.FontSizeModel;
import com.elluminate.groupware.notes.module.Note;
import com.elluminate.groupware.notes.module.NotesDocument;
import com.elluminate.groupware.notes.module.NotesEditor;
import com.elluminate.groupware.notes.module.NotesFontResize;
import com.elluminate.groupware.notes.module.NotesIndex;
import com.elluminate.groupware.notes.module.NotesModule;
import com.elluminate.groupware.notes.module.StringsProperties;
import com.elluminate.groupware.notes.module.data.NoteCache;
import com.elluminate.groupware.notes.module.event.FontSizeChangeEvent;
import com.elluminate.groupware.notes.module.event.FontSizeChangeListener;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.CToolBarToggleButton;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTable;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

@Singleton
public class NotesBean
extends JPanel {
    private static final long serialVersionUID = -1997814035606482532L;
    private static final String DIVIDER_POSITION_PREF = ".dividerPosition";
    private static final int DEFAULT_DIVIDER_POSITION = 150;
    private static final int CLOSED_DIVIDER_POSITION = 1;
    private static final int MINIMUM_DIVIDER_POSITION = 50;
    private static final long SEARCH_FILTER_DELAY = 150L;
    private static final long LIST_SELECTION_DELAY = 400L;
    private static final String hideWindowAction = "hide-notes-window";
    private NotesModule module;
    private I18n i18n;
    private JToggleButton manageButton;
    private JButton exportButton;
    private JButton importButton;
    private JComboBox fontComboBox;
    private JTextField searchField;
    private Color searchFieldForeground;
    private JButton deleteButton;
    private JSplitPane verticalSplit;
    private DocumentListModel documentListModel;
    private CTable documentList;
    private NotesEditor notesEditor;
    private List<NotesDocument> documents;
    private int clicksInProgress = 0;
    private Object clickGuard = new Object();
    private Object populateEditorGuard = new Object();
    private NotesDocument currentlyLoadingNDoc = null;
    private File lastDirectory = null;
    private NotesImpl notesImpl = new NotesImpl();
    private Imps imps = null;
    private boolean usesAquaSearchField = Platform.checkOSVersion((int)202, (String)"10.5+") && Platform.checkJavaVersion((String)"1.5+");
    private boolean userEditingSearch = false;
    private NotesDocumentFilter notesDocumentFilter = new NotesDocumentFilter();
    private TextFileFilter textFileFilter = new TextFileFilter();
    private FileFilter lastFilter = this.notesDocumentFilter;
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            if (NotesBean.this.notesEditor.getDocument() != null) {
                NotesBean.this.notesEditor.requestFocusInDocument();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            NotesDocument ndoc = NotesBean.this.notesEditor.getDocument();
            if (ndoc != null && ndoc.isModified()) {
                if (ndoc.isEmpty() && !ndoc.isNew()) {
                    ndoc.delete();
                } else {
                    try {
                        ndoc.save();
                    }
                    catch (IOException ex) {
                        LogSupport.error((Object)this, (String)"propertyChange", (String)ex.toString());
                    }
                }
            }
        }
    };
    private LightweightTimer searchFilterTimer = new LightweightTimer(2, new Runnable(){

        @Override
        public void run() {
            NotesBean.this.documentListModel.filterDocuments();
            if (!NotesBean.this.manageButton.isSelected()) {
                NotesBean.this.verticalSplit.setDividerLocation(NotesBean.this.verticalSplit.getLastDividerLocation());
            }
        }
    });
    private LightweightTimer listSelectionTimer = new LightweightTimer(1, new Runnable(){

        @Override
        public void run() {
            NotesBean.this.runPopulateEditorClerk();
        }
    });

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public NotesBean(NotesModule module, I18n localization) {
        this.module = module;
        this.i18n = localization;
        this.setLayout(new BorderLayout());
        AccessibleToolBar toolBar = new AccessibleToolBar();
        if (Platform.getPlatform() == 3) {
            toolBar.setLayout(new BoxLayout((Container)toolBar, 0));
        }
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "North");
        this.manageButton = new CToolBarToggleButton((Icon)this.i18n.getIcon("NotesBean.manageIcon24"));
        this.manageButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_MANAGEBUTTONTIP));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesBean.this.doManageButton();
            }
        });
        toolBar.add(this.manageButton);
        this.exportButton = new CToolBarButton((Icon)this.i18n.getIcon("NotesBean.exportIcon24"));
        this.exportButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_EXPORTBUTTONTIP));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesBean.this.doExportButton();
            }
        });
        toolBar.add(this.exportButton);
        this.importButton = new CToolBarButton((Icon)this.i18n.getIcon("NotesBean.importIcon24"));
        this.importButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPORTBUTTONTIP));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesBean.this.doImportButton();
            }
        });
        toolBar.add(this.importButton);
        toolBar.addSeparator();
        JPanel fontSelectPanel = new JPanel(new FlowLayout(0));
        this.fontComboBox = new JComboBox(new FontSizeModel());
        this.fontComboBox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_FONTSIZECOMBO_TOOLTIP));
        this.fontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                NotesBean.this.notesEditor.getTextResizer().setTextSize(box.getSelectedItem().toString());
            }
        });
        JLabel lblSize = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_FONTSIZECOMBO));
        lblSize.setLabelFor(this.fontComboBox);
        fontSelectPanel.add(lblSize);
        fontSelectPanel.add(this.fontComboBox);
        toolBar.add(fontSelectPanel);
        toolBar.add(Box.createHorizontalGlue());
        this.searchField = new JTextField(8);
        this.searchField.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_SEARCHFIELDTIP));
        this.searchFieldForeground = this.searchField.getForeground();
        if (this.usesAquaSearchField) {
            this.searchField.putClientProperty("JTextField.variant", "search");
        }
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NotesBean.this.doSearchFieldFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                NotesBean.this.doSearchFieldFocus(false);
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NotesBean.this.doSearchField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NotesBean.this.doSearchField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NotesBean.this.doSearchField();
            }
        });
        this.searchField.setMaximumSize(this.searchField.getPreferredSize());
        toolBar.add(this.searchField);
        toolBar.add(Box.createHorizontalStrut(4));
        this.deleteButton = new CToolBarButton((Icon)this.i18n.getIcon("NotesBean.deleteIcon24"));
        this.deleteButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DELETEBUTTONTIP));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotesBean.this.doDeleteButton();
            }
        });
        toolBar.add(this.deleteButton);
        this.verticalSplit = new JSplitPane(0, true){
            private static final long serialVersionUID = 9019853872006859248L;

            @Override
            public void setLastDividerLocation(int location) {
                if (location >= 50) {
                    super.setLastDividerLocation(location);
                }
            }
        };
        this.verticalSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.verticalSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NotesBean.this.doVerticalSplit();
            }
        });
        this.add((Component)this.verticalSplit, "Center");
        this.documentListModel = new DocumentListModel();
        this.documentList = new CTable((TableModel)this.documentListModel);
        this.documentList.setDefaultRenderer(NotesDocument.class, (TableCellRenderer)new DocumentRenderer());
        this.documentList.setPreferredScrollableViewportSize(new Dimension(300, 150));
        this.documentList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NotesBean.this.doDocumentList(e);
            }
        });
        JScrollPane documentListScroller = new JScrollPane((Component)this.documentList, 22, 31);
        switch (Platform.getOS()) {
            case 300: {
                break;
            }
            case 202: {
                documentListScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY));
                break;
            }
            default: {
                Border brdr = documentListScroller.getBorder();
                Insets ins = brdr.getBorderInsets(documentListScroller);
                documentListScroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -ins.left, 0, -ins.right), brdr));
            }
        }
        documentListScroller.setMinimumSize(new Dimension(0, 1));
        this.verticalSplit.setTopComponent(documentListScroller);
        NotesEditor.TimeProvider timeProv = new NotesEditor.TimeProvider(){

            @Override
            public long getTime() {
                NotesDocument ndoc = NotesBean.this.notesEditor.getDocument();
                if (ndoc != null && NotesBean.this.module.isCurrentNotes(ndoc)) {
                    return NotesBean.this.module.getSessionTime();
                }
                return Long.MIN_VALUE;
            }
        };
        Cursor handCurs = NotesBean.makeCursor(this.i18n.getIcon("NotesBean.handCursor").getImage(), new Point(8, 8), "handCursor");
        Cursor grabCur = NotesBean.makeCursor(this.i18n.getIcon("NotesBean.grabCursor").getImage(), new Point(8, 8), "grabCursor");
        this.notesEditor = new NotesEditor(timeProv, handCurs, grabCur);
        this.notesEditor.setPreferredScrollableViewportSize(new Dimension(300, 150));
        JScrollPane notesEditorScroller = new JScrollPane(22, 31);
        notesEditorScroller.setViewport(new FullSizeViewport());
        notesEditorScroller.setViewportView(this.notesEditor);
        switch (Platform.getOS()) {
            case 300: {
                break;
            }
            case 202: {
                notesEditorScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY));
                break;
            }
            default: {
                Border brdr = notesEditorScroller.getBorder();
                Insets ins = brdr.getBorderInsets(notesEditorScroller);
                notesEditorScroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -ins.left, 0, -ins.right), brdr));
            }
        }
        notesEditorScroller.setMinimumSize(new Dimension(0, 50));
        this.verticalSplit.setBottomComponent(notesEditorScroller);
        JPanel statusBar = new JPanel();
        statusBar.setPreferredSize(new Dimension(14, 14));
        this.add((Component)statusBar, "South");
        this.enableButtons();
        this.doSearchFieldFocus(false);
        this.verticalSplit.setDividerLocation(1);
        this.searchField.setVisible(false);
        this.registerFontListener();
    }

    void start() {
        this.imps.provideAPI(NotesAPI.class, (ImpsAPI)this.notesImpl);
    }

    private void registerFontListener() {
        this.notesEditor.addFontSizeChangeListener(new FontSizeChangeListener(){

            @Override
            public void fontSizeChanged(FontSizeChangeEvent e) {
                int fontSize = e.getFontSize();
                NotesBean.this.fontComboBox.setSelectedIndex(NotesFontResize.lookupFontIndex(Integer.toString(fontSize)));
                NotesBean.this.fontComboBox.repaint();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.addWindowListener(this.windowListener);
        }
    }

    @Override
    public void removeNotify() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.removeWindowListener(this.windowListener);
        }
        super.removeNotify();
    }

    private static Cursor makeCursor(Image image, Point hotSpot, String name) {
        BufferedImage bim;
        Graphics g;
        Dimension s = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if ((w != s.width || h != s.height) && (g = (bim = new BufferedImage(s.width, s.height, 2)).getGraphics()) != null) {
            g.drawImage(image, 0, 0, null);
            g.dispose();
            image = bim;
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, name);
    }

    private void enableButtons() {
        int[] rows = this.documentList.getSelectedRows();
        this.exportButton.setEnabled(rows.length >= 1);
        this.deleteButton.setEnabled(rows.length >= 1);
    }

    void currentNotesChanged() {
        this.documentList.repaint();
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                NotesDocument[] curDocs = NotesBean.this.module.getCurrentNotes();
                if (curDocs != null) {
                    NotesBean.this.setSelectedDocuments(curDocs);
                    NotesBean.this.notesEditor.requestFocusInDocument();
                }
            }
        });
    }

    boolean areSelectedNotes(NotesDocument document) {
        NotesDocument[] selectedDocs = this.getSelectedDocuments();
        for (int i = 0; i < selectedDocs.length; ++i) {
            if (selectedDocs[i] != document) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPopulateEditorClerk() {
        Object object = this.clickGuard;
        synchronized (object) {
            if (this.clicksInProgress >= 2) {
                if (NotesDebug.ONE_CLICK_DEBUG.show()) {
                    LogSupport.message((Object)this, (String)"runPopulateEditorClerk", (String)"Already a click in the queue, returning.");
                }
                return;
            }
            ++this.clicksInProgress;
            if (this.clicksInProgress == 2 && this.currentlyLoadingNDoc != null) {
                this.currentlyLoadingNDoc.setKillLoad(true);
                if (NotesDebug.ONE_CLICK_DEBUG.show()) {
                    LogSupport.message((Object)this, (String)"runPopulateEditorClerk", (String)"Killing the current load.");
                }
            }
        }
        object = this.populateEditorGuard;
        synchronized (object) {
            this.populateEditor();
        }
        object = this.clickGuard;
        synchronized (object) {
            --this.clicksInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateEditor() {
        Object cdoc;
        this.notesEditor.stopTimeMonitor();
        Object ndoc = this.notesEditor.getDocument();
        if (ndoc != null) {
            if (!(!((NotesDocument)ndoc).isModified() || ((NotesDocument)ndoc).isEmpty() && ((NotesDocument)ndoc).isNew())) {
                try {
                    ((NotesDocument)ndoc).save();
                }
                catch (IOException ex) {
                    LogSupport.error((Object)this, (String)"populateEditor", (String)ex.toString());
                }
            }
            ((NotesDocument)ndoc).unloadNotes();
        }
        String sessID = null;
        Date sessDate = null;
        String sessName = null;
        NotesDocument[] docs = this.getSelectedDocuments();
        for (int i = 0; i < docs.length; ++i) {
            NotesDocument doc = docs[i];
            String sid = doc.getSessionID();
            if (sessID == null || sid.equals(sessID)) {
                if (sessID != null) continue;
                sessID = sid;
                sessDate = doc.getSessionDate();
                sessName = doc.getSessionName();
                continue;
            }
            docs = new NotesDocument[]{};
            break;
        }
        String auth = this.module.getPreferredAuthor();
        this.notesEditor.setAuthor(auth);
        ndoc = null;
        if (docs.length == 1) {
            ndoc = docs[0];
        } else if (docs.length > 1) {
            cdoc = new CompoundNotesDocument(sessID, sessDate, sessName, auth);
            for (int i = 0; i < docs.length; ++i) {
                ((CompoundNotesDocument)cdoc).addDocument(docs[i]);
            }
            ndoc = cdoc;
        }
        try {
            if (ndoc != null && !((NotesDocument)ndoc).isLoaded()) {
                cdoc = this.clickGuard;
                synchronized (cdoc) {
                    if (this.clicksInProgress == 2) {
                        if (NotesDebug.ONE_CLICK_DEBUG.show()) {
                            LogSupport.message((Object)this, (String)"populateEditor", (String)"Second click in queue, not loading the document.");
                        }
                        return;
                    }
                    ((NotesDocument)ndoc).setKillLoad(false);
                    this.currentlyLoadingNDoc = ndoc;
                }
                ((NotesDocument)ndoc).loadNotes();
                cdoc = this.clickGuard;
                synchronized (cdoc) {
                    ((NotesDocument)ndoc).setKillLoad(false);
                    this.currentlyLoadingNDoc = null;
                    if (this.clicksInProgress == 2) {
                        if (NotesDebug.ONE_CLICK_DEBUG.show()) {
                            LogSupport.message((Object)this, (String)"populateEditor", (String)"Second click in queue, not setting the document.");
                        }
                        return;
                    }
                }
            }
            this.notesEditor.setDocument((NotesDocument)ndoc);
            if (ndoc != null && !((NotesDocument)ndoc).isNew() && this.module.isCurrentNotes((NotesDocument)ndoc) && this.module.isPlayingRecording()) {
                this.notesEditor.startTimeMonitor(1000);
            }
            this.notesImpl.retryMissedNotesForSession(this.module.getSessionName());
        }
        catch (IOException ex) {
            LogSupport.error((Object)this, (String)"populateEditor", (String)ex.toString());
        }
    }

    private NotesDocument[] getSelectedDocuments() {
        ArrayList<NotesDocument> sel = new ArrayList<NotesDocument>();
        List<NotesDocument> docs = this.documents;
        if (docs != null) {
            int[] rows = this.documentList.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                NotesDocument ndoc = docs.get(row);
                sel.add(ndoc);
            }
        }
        return sel.toArray(new NotesDocument[0]);
    }

    private void setSelectedDocuments(NotesDocument[] selectedDocuments) {
        if (selectedDocuments == null || this.documents == null) {
            this.documentList.clearSelection();
        } else {
            ArrayList<NotesDocument> list = new ArrayList<NotesDocument>(Arrays.asList(selectedDocuments));
            int[] rows = this.documentList.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                NotesDocument d = this.documents.get(row);
                int index = list.indexOf(d);
                if (index != -1) {
                    list.remove(index);
                    continue;
                }
                this.documentList.removeRowSelectionInterval(row, row);
            }
            for (NotesDocument d : list) {
                int row = this.documents.indexOf(d);
                if (row == -1) continue;
                this.documentList.addRowSelectionInterval(row, row);
            }
        }
    }

    public String getSearchString() {
        String srchStr = this.searchField.getText();
        if (srchStr.equals(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_SEARCHBACKGROUNDPROMPT))) {
            srchStr = "";
        }
        return srchStr;
    }

    private void doVerticalSplit() {
        int pos = this.verticalSplit.getDividerLocation();
        if (pos <= 1) {
            if (this.manageButton.isSelected()) {
                this.manageButton.setSelected(false);
            }
            this.searchField.setVisible(false);
            this.documentList.setFocusable(false);
        } else {
            if (!this.manageButton.isSelected()) {
                this.manageButton.setSelected(true);
            }
            this.searchField.setVisible(true);
            this.documentList.setFocusable(true);
        }
        this.revalidate();
    }

    private void doManageButton() {
        if (this.manageButton.isSelected()) {
            this.verticalSplit.setDividerLocation(this.verticalSplit.getLastDividerLocation());
        } else {
            this.verticalSplit.setDividerLocation(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportButton() {
        NotesDocument[] notesDocumentArray;
        NotesDocument doc = this.notesEditor.getDocument();
        if (doc == null) {
            notesDocumentArray = this.getSelectedDocuments();
        } else {
            NotesDocument[] notesDocumentArray2 = new NotesDocument[1];
            notesDocumentArray = notesDocumentArray2;
            notesDocumentArray2[0] = doc;
        }
        NotesDocument[] docs = notesDocumentArray;
        if (docs.length == 0) {
            return;
        }
        ExportAccessory accessPanel = docs.length > 1 ? new ExportAccessory() : null;
        String previousExt = null;
        for (int i = 0; i < docs.length; ++i) {
            NotesDocument ndoc = docs[i];
            File toSave = this.generateDocFile(this.lastDirectory, ndoc);
            if (i == 0 || accessPanel != null && !accessPanel.isAcceptingDefaults()) {
                toSave = this.presentFileChooserDialog(toSave, accessPanel);
                previousExt = previousExt == null ? FileSysUtils.getExtension((File)toSave) : previousExt;
            } else {
                toSave = this.checkAndManipulateFile(toSave, previousExt);
            }
            if (toSave == null) {
                return;
            }
            boolean loadedTemporarily = false;
            try {
                if (!ndoc.isLoaded()) {
                    ndoc.loadNotes();
                    loadedTemporarily = true;
                }
                if (this.lastFilter == this.notesDocumentFilter) {
                    ndoc.saveCopy(toSave);
                    continue;
                }
                if (this.lastFilter != this.textFileFilter) continue;
                ndoc.saveCopyAsText(toSave);
                continue;
            }
            catch (IOException ex) {
                LogSupport.error((Object)this, (String)"doExportButton", (String)ex.toString());
                ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_EXPORTFAILEDMESSAGE, new Object[]{ndoc.getSessionName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_EXPORTFAILEDTITLE), (int)0);
                continue;
            }
            finally {
                if (loadedTemporarily) {
                    ndoc.unloadNotes();
                }
            }
        }
    }

    private File checkAndManipulateFile(File toCheck, String previousExt) {
        String ext = FileSysUtils.getExtension((File)toCheck);
        if (ext == null || !ext.equals(previousExt)) {
            toCheck = FileSysUtils.setExtensionDefault((File)toCheck, (String)previousExt);
        }
        if (toCheck.exists()) {
            toCheck = this.presentFileChooserDialog(toCheck, null);
        }
        return toCheck;
    }

    private File generateDocFile(File lastDirectory, NotesDocument doc) {
        DateFormat df = DateFormat.getDateInstance(3);
        String sDate = df.format(doc.getSessionDate());
        sDate = sDate.replace(".", "-");
        sDate = sDate.replace("/", "-");
        sDate = (sDate = sDate.replace("\\", "-")).endsWith("-") ? sDate : sDate + "-";
        return new File(lastDirectory, sDate + doc.getSessionName());
    }

    private File presentFileChooserDialog(File f, ExportAccessory accessPanel) {
        FileSaveDialog ch = new FileSaveDialog(this.lastDirectory);
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        ch.addChoosableFileFilter((FileFilter)this.notesDocumentFilter);
        ch.addChoosableFileFilter((FileFilter)this.textFileFilter);
        ch.setFileFilter(this.lastFilter);
        ch.setSelectedFile(f);
        ch.setRequiredSuffix((FileFilter)this.notesDocumentFilter, ".eln");
        ch.setRequiredSuffix((FileFilter)this.textFileFilter, ".txt");
        ch.applyExtensionSilently(true);
        if (accessPanel != null) {
            ch.setAccessory((JComponent)accessPanel);
        }
        if (ch.showSaveDialog((Component)this) != 0) {
            return null;
        }
        f = ch.getSelectedFile();
        this.lastDirectory = ch.getCurrentDirectory();
        this.lastFilter = ch.getFileFilter();
        return f;
    }

    private void doImportButton() {
        CFileChooser ch = new CFileChooser(this.lastDirectory);
        ch.setMultiSelectionEnabled(true);
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        ch.addChoosableFileFilter((FileFilter)this.notesDocumentFilter);
        if (ch.showOpenDialog((Component)this) != 0) {
            return;
        }
        this.lastDirectory = ch.getCurrentDirectory();
        File[] files = ch.getSelectedFiles();
        this.importFiles(files);
    }

    protected void importFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            File fcopy = null;
            try {
                File notesDir = this.module.getNotesDirectory();
                if (!notesDir.exists()) {
                    notesDir.mkdirs();
                }
                fcopy = NotesModule.makeNotesFile(notesDir, f.getName());
                NotesBean.copyFile(f, fcopy);
                NotesDocument ndoc = new NotesDocument(fcopy);
                ndoc.loadHeader();
                this.module.getNotesIndex().addDocument(ndoc);
                if (this.manageButton.isSelected()) continue;
                this.verticalSplit.setDividerLocation(this.verticalSplit.getLastDividerLocation());
                continue;
            }
            catch (IOException ex) {
                if (fcopy != null && fcopy.exists()) {
                    fcopy.delete();
                }
                LogSupport.error((Object)this, (String)"doImportButton", (String)ex.toString());
                if (i + 1 < files.length) {
                    int choice = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPORTFAILEDQUESTION, new Object[]{f.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPORTFAILEDTITLE), (int)0, (int)0);
                    if (choice == 0) continue;
                    break;
                }
                ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPORTFAILEDMESSAGE, new Object[]{f.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPORTFAILEDTITLE), (int)0);
            }
        }
    }

    private void doSearchField() {
        if (this.userEditingSearch) {
            this.searchFilterTimer.scheduleIn(150L);
        }
    }

    private void doSearchFieldFocus(boolean focusGained) {
        if (focusGained) {
            if (!this.usesAquaSearchField && this.searchField.getText().equals(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_SEARCHBACKGROUNDPROMPT))) {
                this.searchField.setText("");
                this.searchField.setForeground(this.searchFieldForeground);
            }
            this.userEditingSearch = true;
        } else {
            this.userEditingSearch = false;
            if (!this.usesAquaSearchField && this.searchField.getText().length() == 0) {
                this.searchField.setForeground(Color.LIGHT_GRAY);
                this.searchField.setText(this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_SEARCHBACKGROUNDPROMPT));
            }
        }
    }

    private void doDeleteButton() {
        int choice;
        NotesDocument[] docs = this.getSelectedDocuments();
        if (docs.length == 0) {
            return;
        }
        if (docs.length == 1) {
            NotesDocument ndoc = docs[0];
            choice = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_CONFIRMDELETEQUESTION, new Object[]{ndoc.getSessionName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_CONFIRMDELETETITLE), (int)0, (int)3);
        } else {
            choice = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_CONFIRMMULTIPLEDELETEQUESTION), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_CONFIRMMULTIPLEDELETETITLE), (int)0, (int)3);
        }
        if (choice != 0) {
            return;
        }
        NotesIndex index = this.module.getNotesIndex();
        for (int i = 0; i < docs.length; ++i) {
            NotesDocument ndoc = docs[i];
            if (this.module.isCurrentNotes(ndoc) && index.getDocuments(ndoc.getSessionID()).size() == 1) {
                ndoc.delete();
                ndoc.removeAllNotes();
                ndoc.setAuthor(this.module.getPreferredAuthor());
                continue;
            }
            if (!ndoc.delete()) {
                if (i + 1 < docs.length) {
                    choice = ModalDialog.showConfirmDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DELETEFAILEDQUESTION, new Object[]{ndoc.getSessionName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DELETEFAILEDTITLE), (int)0, (int)0);
                    if (choice == 0) continue;
                    break;
                }
                ModalDialog.showMessageDialog((Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DELETEFAILEDMESSAGE, new Object[]{ndoc.getSessionName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DELETEFAILEDTITLE), (int)0);
                continue;
            }
            this.module.getNotesIndex().removeDocument(ndoc);
        }
    }

    private void doDocumentList(ListSelectionEvent e) {
        this.enableButtons();
        if (!e.getValueIsAdjusting()) {
            this.listSelectionTimer.scheduleIn(400L);
        }
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        int pos = preferences.getIntegerSetting(prefix + DIVIDER_POSITION_PREF, 150);
        this.verticalSplit.setLastDividerLocation(pos);
    }

    public void savePreferences(String prefix, Preferences preferences) {
        int pos = this.verticalSplit.getDividerLocation();
        if (pos <= 1) {
            pos = this.verticalSplit.getLastDividerLocation();
        }
        if (pos >= 50) {
            preferences.setSetting(prefix + DIVIDER_POSITION_PREF, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File newFile) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            out = new BufferedOutputStream(new FileOutputStream(newFile));
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private class DocumentListModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 7554430402697201823L;
        private static final int DATE_COLUMN = 0;
        private static final int NAME_COLUMN = 1;
        private boolean inited = false;
        private Comparator<NotesDocument> dateComparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                NotesDocument doc1 = (NotesDocument)obj1;
                NotesDocument doc2 = (NotesDocument)obj2;
                return doc2.getSessionDate().compareTo(doc1.getSessionDate());
            }

            @Override
            public boolean equals(Object obj) {
                return obj != this;
            }
        };

        private DocumentListModel() {
        }

        @Override
        public int getRowCount() {
            if (!this.inited) {
                this.init();
            }
            return NotesBean.this.documents != null ? NotesBean.this.documents.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_DATECOLUMN);
                }
                case 1: {
                    return NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_SESSIONCOLUMN);
                }
            }
            return null;
        }

        public Class<NotesDocument> getColumnClass(int column) {
            return NotesDocument.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return NotesBean.this.documents.get(row);
        }

        private synchronized void init() {
            if (NotesBean.this.module == null || !NotesBean.this.module.isModuleVisible()) {
                return;
            }
            NotesIndex index = NotesBean.this.module.getNotesIndex();
            if (index == null) {
                return;
            }
            this.inited = true;
            NotesBean.this.documents = this.getIndexDocuments();
            NotesDocument[] curDocs = NotesBean.this.module.getCurrentNotes();
            if (curDocs != null) {
                NotesBean.this.setSelectedDocuments(curDocs);
                NotesBean.this.notesEditor.requestFocusInDocument();
            }
            index.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (prop.equals("entry")) {
                        NotesDocument ndoc = (NotesDocument)e.getOldValue();
                        if (ndoc != null) {
                            DocumentListModel.this.documentRemoved(ndoc);
                        } else {
                            ndoc = (NotesDocument)e.getNewValue();
                            if (ndoc != null) {
                                DocumentListModel.this.documentAdded(ndoc);
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void documentRemoved(NotesDocument document) {
            List list = NotesBean.this.documents;
            synchronized (list) {
                int row = NotesBean.this.documents.indexOf(document);
                if (row != -1) {
                    NotesBean.this.documents.remove(row);
                    this.fireTableRowsDeleted(row, row);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void documentAdded(NotesDocument document) {
            String srch = NotesBean.this.getSearchString().toLowerCase();
            String name = document.getSessionName().toLowerCase();
            if (name.indexOf(srch) == -1) {
                return;
            }
            int row = -1;
            List list = NotesBean.this.documents;
            synchronized (list) {
                Date date = document.getSessionDate();
                for (int i = 0; i < NotesBean.this.documents.size(); ++i) {
                    NotesDocument ndoc = (NotesDocument)NotesBean.this.documents.get(i);
                    if (ndoc.getSessionDate().compareTo(date) >= 0) continue;
                    NotesBean.this.documents.add(i, document);
                    row = i;
                    break;
                }
                if (row == -1) {
                    NotesBean.this.documents.add(document);
                    row = NotesBean.this.documents.size() - 1;
                }
            }
            this.fireTableRowsInserted(row, row);
        }

        private List<NotesDocument> getIndexDocuments() {
            NotesIndex index = NotesBean.this.module.getNotesIndex();
            List list = index.findDocumentsByName(NotesBean.this.getSearchString());
            Collections.sort(list, this.dateComparator);
            return list;
        }

        public void filterDocuments() {
            NotesBean.this.documents = this.getIndexDocuments();
            this.fireTableDataChanged();
        }
    }

    private class DocumentRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 8356383971670248281L;
        private DateFormat dateFormat = DateFormat.getDateInstance(1);
        private Calendar calendar = Calendar.getInstance();
        private Font boldFont = null;

        private DocumentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            if (value == null) {
                return null;
            }
            NotesDocument ndoc = (NotesDocument)value;
            switch (table.convertColumnIndexToModel(column)) {
                case 0: {
                    int today = Calendar.getInstance().get(6);
                    Date date = ndoc.getSessionDate();
                    this.calendar.setTime(date);
                    int day = this.calendar.get(6);
                    if (day == today) {
                        this.setText(NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_TODAY));
                        break;
                    }
                    if (day == today - 1) {
                        this.setText(NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_YESTERDAY));
                        break;
                    }
                    this.setText(this.dateFormat.format(date));
                    break;
                }
                case 1: {
                    NotesIndex index = NotesBean.this.module.getNotesIndex();
                    if (index.getDocuments(ndoc.getSessionID()).size() > 1) {
                        this.setText(ndoc.getSessionName() + " (" + ndoc.getAuthor() + ")");
                        break;
                    }
                    this.setText(ndoc.getSessionName());
                }
            }
            if (NotesBean.this.module.isCurrentNotes(ndoc)) {
                this.setFont(this.getBoldFont());
            }
            return this;
        }

        private Font getBoldFont() {
            if (this.boldFont == null) {
                Font f = this.getFont();
                this.boldFont = f.deriveFont(1, f.getSize());
            }
            return this.boldFont;
        }
    }

    private class ExportAccessory
    extends JPanel {
        private static final long serialVersionUID = -1950088397774160807L;
        private JCheckBox accept;

        public ExportAccessory() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.fill = 2;
            gbc.insets.bottom = 6;
            this.accept = new JCheckBox(NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_APPLYTOALLBOX));
            this.add((Component)this.accept, gbc);
            gbc.insets.bottom = 0;
            MultilineLabel l = new MultilineLabel(NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_APPLYTOALLEXPLANATION));
            this.add((Component)l, gbc);
        }

        public boolean isAcceptingDefaults() {
            return this.accept.isSelected();
        }
    }

    private class FullSizeViewport
    extends JViewport {
        private static final long serialVersionUID = 8083305708003514423L;

        private FullSizeViewport() {
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Dimension s = this.getSize();
            if (newSize != null && newSize.height < s.height) {
                newSize = new Dimension(newSize.width, s.height);
            }
            super.setViewSize(newSize);
        }
    }

    private class NotesDocumentFilter
    extends FileFilter {
        private NotesDocumentFilter() {
        }

        @Override
        public String getDescription() {
            return NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_NOTESDOCUMENTFILTER);
        }

        @Override
        public boolean accept(File file) {
            if (FileSysUtils.isTraversableDirectory((File)file)) {
                return true;
            }
            String filename = file.getName();
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                return false;
            }
            String ext = filename.substring(pos);
            return ext.equalsIgnoreCase(".eln");
        }
    }

    private class NotesImpl
    implements NotesAPI {
        private Map<String, List<NoteCache>> noteMap = new HashMap<String, List<NoteCache>>();

        private NotesImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<NoteCache> getMissedNotesForSession(String sessionName) {
            if (sessionName == null) {
                return null;
            }
            Map<String, List<NoteCache>> map = this.noteMap;
            synchronized (map) {
                return this.noteMap.remove(sessionName);
            }
        }

        public void retryMissedNotesForSession(String sessionName) {
            List<NoteCache> noteCacheList = NotesBean.this.notesImpl.getMissedNotesForSession(NotesBean.this.module.getSessionName());
            if (noteCacheList == null || noteCacheList.isEmpty()) {
                return;
            }
            for (NoteCache noteCache : noteCacheList) {
                this.addNote(noteCache.getSlideName(), noteCache.getNote(), noteCache.getAuthor(), -1L, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addNote(String slideName, String note, String author, long sessionTimestamp, boolean allowDups) {
            NotesDocument doc;
            if (note == null) {
                return false;
            }
            if (sessionTimestamp < 0L) {
                sessionTimestamp = NotesBean.this.module.getSessionTime();
            }
            if ((doc = NotesBean.this.notesEditor.getDocument()) == null) {
                if (NotesBean.this.module.getSessionName() == null) {
                    return false;
                }
                Map<String, List<NoteCache>> map = this.noteMap;
                synchronized (map) {
                    if (this.noteMap.containsKey(NotesBean.this.module.getSessionName())) {
                        this.noteMap.get(NotesBean.this.module.getSessionName()).add(new NoteCache(slideName, note, author, sessionTimestamp));
                    } else {
                        ArrayList<NoteCache> cache = new ArrayList<NoteCache>();
                        cache.add(new NoteCache(slideName, note, author, sessionTimestamp));
                        this.noteMap.put(NotesBean.this.module.getSessionName(), cache);
                    }
                    return true;
                }
            }
            return doc.addUniqueNoteToDocument(slideName, note, author, sessionTimestamp, allowDups);
        }

        public List<String> getNotes(long startTime, long endTime) {
            Note[] notes;
            ArrayList<String> reply = new ArrayList<String>();
            boolean absEnd = endTime <= 0L;
            for (Note note : notes = NotesBean.this.notesEditor.getDocument().getNotes()) {
                if (note.getTime() < startTime || note.getTime() > endTime && !absEnd) continue;
                reply.add(note.getDataAsText());
            }
            return reply;
        }

        public String getProvider() {
            return NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_IMPSNAME);
        }

        public byte getTier() {
            return 32;
        }
    }

    private class TextFileFilter
    extends FileFilter {
        private TextFileFilter() {
        }

        @Override
        public String getDescription() {
            return NotesBean.this.i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_TEXTFILEFILTER);
        }

        @Override
        public boolean accept(File file) {
            if (FileSysUtils.isTraversableDirectory((File)file)) {
                return true;
            }
            String filename = file.getName();
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                return false;
            }
            String ext = filename.substring(pos);
            return ext.equalsIgnoreCase(".txt");
        }
    }
}

