/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.QuizMessage;
import com.elluminate.groupware.quiz.QuizResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import java.io.DataInputStream;

public class QuizProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "quiz";
    public static final String PROPERTY = "quiz.enabled";
    public static final byte CMD_NONE = 0;
    public static final byte LIB_ADD = 1;
    public static final byte LIB_ACQUIRE = 2;
    public static final byte LIB_RELEASE = 3;
    public static final byte LIB_UPDATE = 4;
    public static final byte LIB_DELETE = 5;
    public static final byte LIB_LOAD = 6;
    public static final byte HAND_OUT = 33;
    public static final byte START = 34;
    public static final byte STOP = 35;
    public static final byte RESPONSE = 36;
    public static final byte HAND_IN = 37;
    public static final byte REVIEW = 38;
    public static final byte CLOSE = 39;
    public static final byte OK = 80;
    public static final byte FAIL = 96;
    public static final byte FAIL_LOCKED = 97;
    public static final byte FAIL_NOT_LOCKED = 98;
    public static final byte FAIL_NOT_FOUND = 99;
    public static final byte FAIL_NO_ACCESS = 100;
    public static final byte FAIL_BAD_STATE = 101;
    public static final byte FAIL_NO_PARTICIPANTS = 102;
    public static final byte FAIL_INVALID = 103;
    public static final short TS_IDLE = 0;
    public static final short TS_SETUP = 1;
    public static final short TS_TESTING = 2;
    public static final short TS_CLEANUP = 3;
    public static final short TS_DONE = 4;
    public static final short TS_REVIEW = 5;
    public static final long START_TIME_LIMIT = 10000L;
    public static final long STOP_TIME_LIMIT = 5000L;
    public static final byte QUIZ_STATE_UNKNOWN = 0;
    public static final byte QUIZ_LOADED_FROM_FILE = 1;
    public static final byte QUIZ_CREATED = 2;
    public static final byte QUIZ_MODIFIED = 3;
    public static final byte QUIZ_SAVED = 4;

    public QuizProtocol() {
        this.defineChannel(CHANNEL, (byte)1);
        this.defineProperty(PROPERTY, (byte)1, Boolean.TRUE);
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "library add";
            }
            case 2: {
                return "library acquire";
            }
            case 3: {
                return "library release";
            }
            case 4: {
                return "library update";
            }
            case 5: {
                return "library delete";
            }
            case 6: {
                return "library load";
            }
            case 33: {
                return "hand out";
            }
            case 34: {
                return "start";
            }
            case 35: {
                return "stop";
            }
            case 36: {
                return "response";
            }
            case 37: {
                return "hand in";
            }
            case 38: {
                return "review";
            }
            case 39: {
                return "close";
            }
            case 80: {
                return "Okay";
            }
            case 96: {
                return "Failed";
            }
            case 97: {
                return "Failed - quiz is locked";
            }
            case 98: {
                return "Failed - quiz not locked";
            }
            case 99: {
                return "Failed - quiz not found";
            }
            case 100: {
                return "Failed - no access";
            }
            case 101: {
                return "Failed - invalid state";
            }
            case 102: {
                return "Failed - no participants";
            }
            case 103: {
                return "Failed - invalid quiz";
            }
        }
        return "***** UNKNOWN COMMAND " + cmd + " *****";
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        QuizMessage msg = new QuizMessage(cmd, str);
        return desc + " - " + msg;
    }

    public ProtocolResponder getResponder() {
        return new QuizResponder();
    }
}

