/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz;

import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizProtocol;
import com.elluminate.groupware.quiz.Responses;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class QuizMessage {
    public static final short QM_ID = 1;
    public static final short QM_DESC = 2;
    public static final short QM_QUESTIONS = 4;
    public static final short QM_MARKING_GUIDE = 8;
    public static final short QM_RESPONSES = 16;
    public static final short QM_DATE = 32;
    public static final short QM_STATS = 64;
    public static final short QM_RESPONSE = 128;
    public static final short QM_TIME_LIMIT = 256;
    public static final short QM_REQUEST = 512;
    public static final short QM_EXCEPTION = 1024;
    public static final short QM_FILE_URL = 2048;
    public static final short QM_ALL = 4095;
    public static final short QM_QUIZ = 127;
    public static final short QM_STUDENT = 423;
    public static final short QM_REVIEW = 111;
    private Quiz quiz = null;
    private String desc = null;
    private long id = 0L;
    private Responses resp = null;
    private long timeLimit = -1L;
    private long timeLeft = -1L;
    private byte req = 0;
    private QuizException ex = null;
    private String fileURL = null;

    public QuizMessage() {
    }

    public QuizMessage(ChannelDataEvent e) {
        DataInputStream str = e.read();
        this.readMessage(e.getCommand(), str);
        try {
            str.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public QuizMessage(byte cmd, DataInputStream str) {
        this.readMessage(cmd, str);
    }

    private void readMessage(byte cmd, DataInputStream str) {
        try {
            short mask = str.readShort();
            if ((mask & 4) != 0) {
                this.quiz = new Quiz(str, (mask & 8) != 0, (mask & 0x10) != 0, (mask & 0x40) != 0, (mask & 0x20) != 0);
            } else {
                if ((mask & 1) != 0) {
                    this.id = str.readLong();
                }
                if ((mask & 2) != 0) {
                    this.desc = str.readUTF();
                }
            }
            if ((mask & 0x80) != 0) {
                this.resp = new Responses(str);
            }
            if ((mask & 0x100) != 0) {
                this.timeLimit = str.readLong();
                this.timeLeft = str.readLong();
            }
            if ((mask & 0x200) != 0) {
                this.req = str.readByte();
            }
            if ((mask & 0x400) != 0) {
                this.ex = QuizException.read(cmd, str, false);
            }
            if ((mask & 0x800) != 0) {
                this.fileURL = str.readUTF();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"QuizMessage", (Throwable)ex, (boolean)true);
        }
    }

    public boolean encode(ChannelDataEvent e) {
        return this.encode(e, (short)4095);
    }

    public boolean encode(ChannelDataEvent e, short mask) {
        mask = this.filterMask(mask);
        try {
            DataOutputStream str = e.write();
            str.writeShort(mask);
            if ((mask & 4) != 0) {
                this.quiz.encode(str, (mask & 8) != 0, (mask & 0x10) != 0, (mask & 0x40) != 0, (mask & 0x20) != 0);
            } else {
                if ((mask & 1) != 0) {
                    str.writeLong(this.getID());
                }
                if ((mask & 2) != 0) {
                    str.writeUTF(this.getDesc());
                }
            }
            if ((mask & 0x80) != 0) {
                this.resp.encode(str);
            }
            if ((mask & 0x100) != 0) {
                str.writeLong(this.timeLimit);
                str.writeLong(this.timeLeft);
            }
            if ((mask & 0x200) != 0) {
                str.writeByte(this.req);
            }
            if ((mask & 0x400) != 0) {
                this.ex.encode(str, false);
            }
            if ((mask & 0x800) != 0) {
                str.writeUTF(this.fileURL);
            }
            str.close();
            return true;
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"encode", (Throwable)ex, (boolean)true);
            return false;
        }
    }

    public boolean hasQuiz() {
        return this.quiz != null;
    }

    public Quiz getQuiz() {
        return this.quiz;
    }

    public void setQuiz(Quiz q) {
        this.quiz = q;
        this.desc = q.getText();
        this.id = q.getID();
    }

    public boolean hasID() {
        if (this.quiz != null) {
            this.id = this.quiz.getID();
        }
        return this.id != 0L;
    }

    public long getID() {
        if (this.quiz != null) {
            this.id = this.quiz.getID();
        }
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
        if (this.quiz != null) {
            this.quiz.setID(id);
        }
    }

    public boolean hasDesc() {
        if (this.quiz != null) {
            this.desc = this.quiz.getText();
        }
        return this.desc != null;
    }

    public String getDesc() {
        if (this.quiz != null) {
            this.desc = this.quiz.getText();
        }
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
        if (this.quiz != null) {
            this.quiz.setText(desc);
        }
    }

    public boolean hasFileURL() {
        return this.fileURL != null;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public boolean hasResponse() {
        return this.resp != null;
    }

    public Responses getResponse() {
        return this.resp;
    }

    public void setResponse(Responses r) {
        this.resp = r;
    }

    public boolean hasRequest() {
        return this.req != 0;
    }

    public void setRequest(byte request) {
        this.req = request;
    }

    public byte getRequest() {
        return this.req;
    }

    public boolean hasException() {
        return this.ex != null;
    }

    public void setException(QuizException ex) {
        this.ex = ex;
    }

    public QuizException getException() {
        return this.ex;
    }

    public boolean hasTimeLimit() {
        return this.timeLimit > 0L;
    }

    public void setTimeLimit(long limit) {
        this.setTimeLimit(limit, limit);
    }

    public void setTimeLimit(long limit, long left) {
        this.timeLimit = limit;
        this.timeLeft = left;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    private short filterMask(short mask) {
        if (this.quiz == null) {
            int filter = -128;
            if (this.desc != null) {
                filter = (short)(filter | 2);
            }
            if (this.id != 0L) {
                filter = (short)(filter | 1);
            }
            mask = (short)(mask & filter);
        } else {
            if (!this.quiz.hasParticipants()) {
                mask = (short)(mask & 0xFFFFFFEF);
            }
            if (!this.quiz.hasMarkingGuide()) {
                mask = (short)(mask & 0xFFFFFFF7);
            }
            if (!this.quiz.hasStats()) {
                mask = (short)(mask & 0xFFFFFFBF);
            }
            if (!this.quiz.hasDateGiven()) {
                mask = (short)(mask & 0xFFFFFFDF);
            }
        }
        if (this.resp == null) {
            mask = (short)(mask & 0xFFFFFF7F);
        }
        if (this.timeLimit <= 0L) {
            mask = (short)(mask & 0xFFFFFEFF);
        }
        if (this.req == 0) {
            mask = (short)(mask & 0xFFFFFDFF);
        }
        if (this.ex == null) {
            mask = (short)(mask & 0xFFFFFBFF);
        }
        if (this.fileURL == null) {
            mask = (short)(mask & 0xFFFFF7FF);
        }
        return mask;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append("QuizMessage:\n");
        if (this.quiz != null) {
            buf.append(this.quiz.toString(prefix + "    "));
        } else {
            if (this.id != 0L) {
                buf.append(prefix);
                buf.append("    id=");
                buf.append(this.id);
                buf.append("\n");
            }
            if (this.desc != null) {
                buf.append(prefix);
                buf.append("    desc=");
                buf.append(this.desc);
                buf.append("\n");
            }
        }
        if (this.resp != null) {
            buf.append(this.resp.toString(prefix + "    "));
        }
        if (this.timeLimit >= 0L) {
            buf.append(prefix);
            buf.append("    timeout=");
            buf.append(this.timeLeft);
            buf.append("/");
            buf.append(this.timeLimit);
            buf.append("\n");
        }
        if (this.req != 0) {
            buf.append(new QuizProtocol().commandToString(this.req));
        }
        if (this.ex != null) {
            buf.append(this.ex.toString());
        }
        return buf.toString();
    }
}

