/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;

public class VClassURI {
    public static final String[] SCHEMES = new String[]{"http", "https", "news", "ftp", "mailto"};
    static final boolean[] HAS_SLASHES = new boolean[]{true, true, false, true, false};
    public static final int UNKNOWN_SCHEME = -1;
    public static final int HTTP_SCHEME = 0;
    public static final int HTTPS_SCHEME = 1;
    public static final int NEWS_SCHEME = 2;
    public static final int FTP_SCHEME = 3;
    public static final int MAILTO_SCHEME = 4;
    private String uriString;
    private int schemeIndex = -1;
    private String host = "";
    private String port = "";
    private int portNumber = -1;
    private String arguments = "";
    private String user = "";
    private boolean hostValid = false;
    private boolean hostValidTested = false;
    private boolean hasSlashes = false;
    private StringBuffer resultString = new StringBuffer();
    private final int MAXIMUM_PORT = 65535;

    public VClassURI(String uriString) throws MalformedURLException {
        int processingIndex = 0;
        if (uriString == null) {
            throw new MalformedURLException("null URI string");
        }
        this.uriString = uriString.trim();
        if (uriString.length() <= 0) {
            throw new MalformedURLException("URI string length <= 0");
        }
        URI uri = null;
        try {
            uri = new URI(this.uriString);
        }
        catch (URISyntaxException ex2) {
            throw new MalformedURLException("Unknown scheme: " + uriString);
        }
        String lowerURI = this.uriString.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < SCHEMES.length; ++i) {
            String prefix = SCHEMES[i];
            if (!uri.getScheme().equalsIgnoreCase(prefix)) continue;
            this.schemeIndex = i;
            break;
        }
        if (this.schemeIndex == -1) {
            throw new MalformedURLException("Unknown scheme: " + uriString);
        }
        processingIndex = SCHEMES[this.schemeIndex].length() + 1;
        if (lowerURI.substring(processingIndex).startsWith("//")) {
            processingIndex += 2;
            this.hasSlashes = true;
        }
        if (this.schemeIndex == 4) {
            int endUser = lowerURI.substring(processingIndex).indexOf("@");
            if (endUser < 0) {
                throw new MalformedURLException("mailto without @");
            }
            this.user = this.uriString.substring(processingIndex, processingIndex + endUser);
            processingIndex += endUser + 1;
        }
        this.resultString.append(SCHEMES[this.schemeIndex] + ":");
        if (HAS_SLASHES[this.schemeIndex] && !this.hasSlashes) {
            throw new MalformedURLException("Scheme requires slashes." + uriString);
        }
        if (!HAS_SLASHES[this.schemeIndex] && this.hasSlashes) {
            throw new MalformedURLException("Scheme should have no slashes." + uriString);
        }
        if (!this.user.equals("")) {
            this.resultString.append(this.user + "@");
        }
        if (HAS_SLASHES[this.schemeIndex]) {
            this.resultString.append("//");
        }
        this.resultString.append(this.uriString.substring(processingIndex));
        int portIndex = this.uriString.substring(processingIndex).indexOf(":");
        int portEnd = this.uriString.substring(processingIndex).indexOf("/");
        if (portIndex == 0) {
            throw new MalformedURLException("zero-length host part");
        }
        if (portIndex > 0 && (portEnd > 0 && portIndex < portEnd || portEnd < 0)) {
            this.host = this.uriString.substring(processingIndex, processingIndex + portIndex);
            if (portEnd < 0) {
                this.port = this.uriString.substring(processingIndex + portIndex + 1);
                processingIndex = this.uriString.length();
            } else {
                this.port = this.uriString.substring(processingIndex + portIndex + 1, processingIndex + portEnd);
                processingIndex += portEnd + 1;
            }
            try {
                this.portNumber = Integer.parseInt(this.port);
            }
            catch (NumberFormatException ex) {
                throw new MalformedURLException("non-integer port number: " + this.port);
            }
            if (this.portNumber > 65535) {
                throw new MalformedURLException("port number " + this.portNumber + " > " + 65535);
            }
        } else {
            int hostEnd = this.uriString.substring(processingIndex).indexOf("/");
            if (hostEnd < 0) {
                this.host = this.uriString.substring(processingIndex);
                processingIndex = this.uriString.length();
            } else {
                this.host = this.uriString.substring(processingIndex, processingIndex + hostEnd);
                processingIndex += hostEnd + 1;
            }
        }
        this.arguments = this.uriString.substring(processingIndex);
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isHostValid() {
        if (!this.hostValidTested) {
            if (this.host != null && !this.host.equals("")) {
                try {
                    InetAddress address = InetAddress.getByName(this.host);
                    this.hostValid = true;
                }
                catch (UnknownHostException ex) {
                    this.hostValid = false;
                }
            }
            this.hostValidTested = true;
        }
        return this.hostValid;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getScheme() {
        if (this.schemeIndex < 0) {
            return "UNKNOWN_SCHEME";
        }
        return SCHEMES[this.schemeIndex];
    }

    public int getSchemeIndex() {
        return this.schemeIndex;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return this.resultString.toString();
    }
}

