/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpHeaders;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class HttpRequest
extends HttpHeaders {
    public static final int NONE = -1;
    public static final int POST = 0;
    public static final int GET = 1;
    public static final int PUT = 2;
    public static final int CONNECT = 3;
    public static final String[] COMMANDS = new String[]{"POST", "GET", "PUT", "CONNECT"};
    protected boolean readable = false;
    protected boolean writable = false;
    protected boolean sent = false;
    protected int httpVer = 10;
    protected String uri = null;
    protected int cmd = -1;
    protected boolean close = true;
    protected int length = 0;
    protected boolean toProxy = false;
    protected boolean debug = false;

    public HttpRequest() {
    }

    public HttpRequest(int method, String host, int port, String uri, int len, boolean done, int httpVer, boolean proxy, boolean debug) {
        this.init(method, host, port, uri, len, done, httpVer, proxy, debug);
    }

    public HttpRequest(DataInputStream istr, boolean debug) throws IOException {
        this.init(istr, debug);
    }

    public void init(int method, String host, int port, String uri, int len, boolean done, int httpVer, boolean proxy, boolean debug) {
        this.httpVer = httpVer;
        this.uri = uri;
        this.cmd = method;
        this.close = done;
        this.length = len;
        this.toProxy = proxy;
        this.debug = debug;
        this.clear();
        switch (httpVer) {
            case 10: {
                if (this.toProxy) {
                    this.setHeader("Proxy-Connection", this.close ? "Close" : "Keep-Alive");
                    break;
                }
                this.setHeader("Connection", this.close ? "Close" : "Keep-Alive");
                break;
            }
            case 11: {
                if (this.close) {
                    this.setHeader("Connection", "Close");
                }
                this.setHeader("Host", host == null ? "" : host + ":" + port);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown http version " + httpVer);
            }
        }
        this.setHeader("Content-Length", Integer.toString(this.length));
        this.readable = false;
        this.writable = true;
        this.sent = false;
    }

    public void init(DataInputStream istr, boolean debug) throws IOException {
        this.clear();
        String line = istr.readLine();
        this.debug = debug;
        if (line == null) {
            throw new EOFException();
        }
        this.parseHttpLine(line);
        this.parseHeaders(istr, debug);
        this.evaluateHeaders();
    }

    public String getURI() {
        return this.uri;
    }

    public int getHttpVersion() {
        return this.httpVer;
    }

    public int getMethod() {
        return this.cmd;
    }

    public boolean isDone() {
        return this.close;
    }

    public int getLength() {
        return this.length;
    }

    public void send(DataOutputStream str) throws IOException {
        if (!this.sent && this.writable) {
            byte[] bytes;
            String httpHdr = this.toString();
            if (this.debug) {
                StringTokenizer lines = new StringTokenizer(httpHdr, "\n");
                while (lines.hasMoreTokens()) {
                    String token = lines.nextToken();
                    if (this.context != null) {
                        LogSupport.message(this, this.context, token);
                        continue;
                    }
                    LogSupport.message(this, "send", token);
                }
            }
            try {
                bytes = httpHdr.getBytes("ASCII7");
            }
            catch (UnsupportedEncodingException ex) {
                bytes = httpHdr.getBytes();
            }
            str.write(bytes);
            this.sent = true;
        }
        if (!this.sent) {
            throw new IllegalStateException("Attempt to send a write-protected response.");
        }
        this.readable = false;
        this.writable = false;
    }

    public String toString() {
        StringBuffer hdr = new StringBuffer();
        hdr.append(COMMANDS[this.cmd]);
        hdr.append(" ");
        hdr.append(this.getURI());
        if (this.httpVer == 10) {
            hdr.append(" HTTP/1.0\r\n");
        } else {
            hdr.append(" HTTP/1.1\r\n");
        }
        this.encodeHeaders(hdr);
        hdr.append("\r\n");
        return hdr.toString();
    }

    protected void parseHttpLine(String line) throws IOException {
        StringTokenizer parser;
        if (this.debug) {
            if (this.context != null) {
                LogSupport.message(this, this.context, line);
            } else {
                LogSupport.message(this, "parseHttpLine", line);
            }
        }
        if (!(parser = new StringTokenizer(line)).hasMoreTokens()) {
            throw new IOException("Invalid request '" + line + "'");
        }
        String token = parser.nextToken();
        this.cmd = -1;
        for (int i = 0; i < COMMANDS.length; ++i) {
            if (!token.equalsIgnoreCase(COMMANDS[i])) continue;
            this.cmd = i;
            break;
        }
        if (this.cmd == -1) {
            throw new IOException("Invalid method '" + token + "'");
        }
        if (!parser.hasMoreTokens()) {
            throw new IOException("Invalid request '" + line + "'");
        }
        this.uri = parser.nextToken();
        if (!parser.hasMoreTokens()) {
            throw new IOException("Invalid request '" + line + "'");
        }
        token = parser.nextToken();
        if (token.equalsIgnoreCase("http/1.0")) {
            this.httpVer = 10;
        } else if (token.equalsIgnoreCase("http/1.1")) {
            this.httpVer = 11;
        } else {
            throw new IOException("Unsupported HTTP version '" + line + "'");
        }
    }

    protected void evaluateHeaders() throws IOException {
        if (this.uri == null) {
            throw new IOException("Empty Http request.");
        }
        this.close = this.httpVer == 10;
        String hdr = this.getHeader("Connection");
        if (hdr == null) {
            hdr = this.getHeader("Proxy-Connection");
        }
        if (hdr != null) {
            if (hdr.equalsIgnoreCase("keep-alive")) {
                this.close = false;
            } else if (hdr.equalsIgnoreCase("close")) {
                this.close = true;
            }
        }
        hdr = this.getHeader("Content-Length", "0");
        try {
            this.length = Integer.parseInt(hdr);
        }
        catch (NumberFormatException ex) {
            this.close = true;
            throw new IOException("Invalid request header 'Content-Length: " + hdr + "'");
        }
        this.writable = false;
        this.readable = true;
        this.sent = false;
    }
}

