/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import com.elluminate.util.log.HistoryBuffer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class PrintStreamTap
extends PrintStream {
    private static final byte EOLN = PrintStreamTap.getEndOfLineByte();
    private PrintStream source = null;
    private boolean echoing = true;
    private ArrayList<PrintStream> taps = new ArrayList();
    private ByteArrayOutputStream lineBuf = new ByteArrayOutputStream(512);
    private HistoryBuffer history = null;

    private static byte getEndOfLineByte() {
        String s = System.getProperty("line.separator", "\n");
        byte[] raw = s.getBytes();
        if (raw.length < 1) {
            return 10;
        }
        return raw[raw.length - 1];
    }

    public PrintStreamTap(PrintStream srcStrm) {
        super(srcStrm, true);
        this.source = srcStrm;
    }

    public PrintStreamTap(PrintStream srcStrm, HistoryBuffer hbuf) {
        super(srcStrm, true);
        this.source = srcStrm;
        this.history = hbuf;
    }

    PrintStream getSourceStream() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHistory(HistoryBuffer hbuf) {
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            this.history = hbuf;
        }
    }

    public boolean isEchoing() {
        return this.echoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEchoing(boolean e) {
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            this.echoing = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTap(PrintStream strm) {
        if (strm == null) {
            return;
        }
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            if (!this.taps.contains(strm)) {
                this.taps.add(strm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTap(PrintStream strm) {
        if (strm == null) {
            return;
        }
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            this.taps.remove(strm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            this.taps.clear();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            if (this.echoing) {
                super.write(b);
            }
            for (PrintStream strm : this.taps) {
                strm.write(b);
            }
            this.lineBuf.write(b);
            if (b == EOLN) {
                this.flushHistory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int pos, int len) {
        if (buf == null) {
            return;
        }
        PrintStreamTap printStreamTap = this;
        synchronized (printStreamTap) {
            if (this.echoing) {
                super.write(buf, pos, len);
            }
            for (PrintStream strm : this.taps) {
                strm.write(buf, pos, len);
            }
            this.lineBuf.write(buf, pos, len);
            if (buf[pos + len - 1] == EOLN) {
                this.flushHistory();
            }
        }
    }

    private void flushHistory() {
        if (this.history != null && this.lineBuf.size() > 0) {
            this.history.append(this.lineBuf.toString());
        }
        this.lineBuf.reset();
    }
}

