/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogConstants;
import com.elluminate.util.log.LogEmitter;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class Logger
implements LogConstants {
    private LogEmitter emitter = null;
    private byte timestampType = 0;
    private byte showThreadGroup = (byte)16;
    private byte showThread = (byte)16;

    @Inject
    public Logger(LogEmitter em) {
        this.emitter = em;
        LogSupport.initialize(this, em);
    }

    public void setTimestampType(byte kind) {
        this.timestampType = kind;
    }

    public byte getTimestampType() {
        return this.timestampType;
    }

    public void setShowThreadMask(byte show) {
        this.showThread = show;
    }

    public byte getShowThreadMask() {
        return this.showThread;
    }

    public void setShowThreadGroupMask(byte show) {
        this.showThreadGroup = show;
    }

    public byte getShowThreadGroupmask() {
        return this.showThreadGroup;
    }

    public void log(String msg) {
        this.println((byte)1, msg);
    }

    public void proxyLog(String forGrp, String forThread, String msg) {
        this.println(forGrp, forThread, (byte)1, msg);
    }

    public void log(Object src, String method, String msg) {
        this.println((byte)1, this.getClassName(src) + "." + method + ": " + msg);
    }

    public void proxyLog(String forGrp, String forThread, Object src, String method, String msg) {
        this.println(forGrp, forThread, (byte)1, this.getClassName(src) + "." + method + ": " + msg);
    }

    public void message(String msg) {
        this.println((byte)2, msg);
    }

    public void proxyMessage(String forGrp, String forThread, String msg) {
        this.println(forGrp, forThread, (byte)2, msg);
    }

    public void message(Object src, String method, String msg) {
        this.println((byte)2, this.getClassName(src) + "." + method + ": " + msg);
    }

    public void message(Object src, String method, String msg, long time) {
        this.println((byte)2, this.getClassName(src) + "." + method + ": " + msg, time);
    }

    public void proxyMessage(String forGrp, String forThread, Object src, String method, String msg) {
        this.println(forGrp, forThread, (byte)2, this.getClassName(src) + "." + method + ": " + msg);
    }

    public void error(String msg) {
        this.println((byte)4, "Application Error: " + msg);
    }

    public void proxyError(String forGrp, String forThread, String msg) {
        this.println(forGrp, forThread, (byte)4, "Application Error: " + msg);
    }

    public void error(Object src, String method, String msg) {
        this.println((byte)4, "Application error in " + this.getClassName(src) + "." + method + ": " + msg);
    }

    public void proxyError(String forGrp, String forThread, Object src, String method, String msg) {
        this.println(forGrp, forThread, (byte)4, "Application error in " + this.getClassName(src) + "." + method + ": " + msg);
    }

    public void exception(Object src, String method, Throwable ex, boolean trace) {
        this.exception(src, method, ex, trace, null);
    }

    public void proxyException(String forGrp, String forThread, Object src, String method, Throwable ex, boolean trace) {
        this.proxyException(forGrp, forThread, src, method, ex, trace, null);
    }

    public void exception(Object src, String method, Throwable ex, boolean trace, String msg) {
        this.logException(this.getThreadContext((byte)8), src, method, ex, trace, msg);
    }

    public void proxyException(String forGrp, String forThread, Object src, String method, Throwable ex, boolean trace, String msg) {
        this.logException(this.getProxyContext(forGrp, forThread, (byte)8), src, method, ex, trace, msg);
    }

    private void logException(String context, Object src, String method, Throwable ex, boolean trace, String msg) {
        StringBuilder entry = new StringBuilder("Application Exception");
        String where = null;
        if (method != null) {
            where = this.getClassName(src) + "." + method;
            entry.append(" in ");
            entry.append(where);
        }
        if (msg != null) {
            entry.append("\n");
            entry.append(msg);
        }
        entry.append(": ");
        boolean hasValidTrace = false;
        if (trace) {
            String stackTrace = Debug.getStackTrace(ex);
            int linePos = stackTrace.indexOf(10);
            hasValidTrace = linePos >= 0 && (stackTrace.indexOf(" at ", linePos) >= 0 || stackTrace.indexOf("\tat ", linePos) >= 0);
            entry.append(stackTrace);
        } else {
            entry.append(ex);
        }
        if (ex instanceof OutOfMemoryError) {
            entry.append("\n" + Platform.getExtendedMemoryStatus());
        }
        if (trace && !hasValidTrace) {
            entry.append("\nReported by: " + Debug.getStackTrace(new Throwable()));
        }
        ExTRASupport.reportException(where, ex, msg);
        this.println(context, entry.toString());
    }

    private void println(byte type, String str, long time) {
        this.println(this.getThreadContext(type), str, time);
    }

    private void println(byte type, String str) {
        this.println(this.getThreadContext(type), str);
    }

    private void println(String grp, String thr, byte type, String str) {
        this.println(this.getProxyContext(grp, thr, type), str);
    }

    private void println(String context, String str) {
        this.println(context, str, System.currentTimeMillis());
    }

    private void println(String context, String str, long now) {
        this.emitter.add(context, str, now, this.timestampType);
    }

    private String getClassName(Object src) {
        if (src == null) {
            return "N/A";
        }
        String full = src instanceof String ? (String)src : (src instanceof Class ? ((Class)src).getName() : src.getClass().getName());
        int loc = full.lastIndexOf(".");
        return full.substring(loc + 1);
    }

    private String getThreadContext(byte type) {
        String threadGroupNm = null;
        String threadNm = null;
        if ((this.showThreadGroup & this.showThread & type) != 0) {
            Thread thr = Thread.currentThread();
            ThreadGroup grp = thr.getThreadGroup();
            threadNm = thr.getName();
            if (grp != null) {
                threadGroupNm = grp.getName();
            }
        } else if ((this.showThreadGroup & type) != 0) {
            ThreadGroup grp = Thread.currentThread().getThreadGroup();
            if (grp != null) {
                threadGroupNm = grp.getName();
            }
        } else if ((this.showThread & type) != 0) {
            threadNm = Thread.currentThread().getName();
        }
        if (threadGroupNm != null && threadGroupNm.equals("")) {
            threadGroupNm = null;
        }
        if (threadNm != null && !threadNm.equals("")) {
            threadNm = null;
        }
        if (threadGroupNm != null && threadNm != null) {
            return threadGroupNm + "." + threadNm;
        }
        if (threadGroupNm != null) {
            return threadGroupNm;
        }
        if (threadNm != null) {
            return threadNm;
        }
        return null;
    }

    private String getProxyContext(String grp, String thr, byte type) {
        if ((type & this.showThreadGroup) == 0) {
            grp = null;
        }
        if ((type & this.showThread) == 0) {
            thr = null;
        }
        if (thr != null && grp != null) {
            return "[" + grp + "." + thr + "]";
        }
        if (grp != null) {
            return "[" + grp + "]";
        }
        if (thr != null) {
            return "[" + thr + "]";
        }
        return null;
    }
}

