/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image.gif;

import com.elluminate.util.TimedExecution;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.ImageObject;

public abstract class AnimationInstance {
    private static final TimedExecution timedExecution = new TimedExecution();
    private int frameCount;
    private int width;
    private int height;
    private boolean waiting = false;
    private int frameNumber = 0;
    private AnimateRunnable animateRunnable = null;
    private long frameUpdateTime = 0L;

    protected AnimationInstance(ImageObject imageObject) {
        this.frameCount = imageObject.getFrameCount();
        this.width = imageObject.getWidth();
        this.height = imageObject.getHeight();
        this.frameNumber = 0;
    }

    public AnimationFrame getAnimationFrame(ImageObject imageObject) {
        return imageObject == null ? null : imageObject.getAnimationFrame(this.frameNumber);
    }

    public int getWidth() {
        return this.height;
    }

    public int getHeight() {
        return this.width;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public long getTimeRemaining() {
        long dT = this.frameUpdateTime - System.currentTimeMillis();
        if (dT < 0L) {
            dT = 0L;
        }
        return dT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageRendered(ImageObject imageObject) {
        AnimationInstance animationInstance = this;
        synchronized (animationInstance) {
            if (this.frameCount <= 1 || this.waiting || System.currentTimeMillis() < this.frameUpdateTime) {
                return false;
            }
            if (this.animateRunnable == null) {
                this.animateRunnable = new AnimateRunnable();
            }
            this.animateRunnable.scheduleFrame(imageObject.getAnimationFrame(this.frameNumber));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation() {
        AnimationInstance animationInstance = this;
        synchronized (animationInstance) {
            this.frameNumber = 0;
            this.frameCount = 0;
            if (this.animateRunnable != null) {
                this.animateRunnable.stop();
            }
            this.animateRunnable = null;
            this.frameUpdateTime = 0L;
            this.waiting = false;
        }
    }

    protected abstract boolean canAnimate();

    protected abstract void animate(int var1, int var2, int var3, int var4);

    protected abstract AnimationFrame getFrame();

    class AnimateRunnable
    implements Runnable {
        AnimateRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AnimationInstance.this.waiting = false;
            if (!AnimationInstance.this.canAnimate()) {
                return;
            }
            AnimationFrame animationFrame = null;
            AnimateRunnable animateRunnable = this;
            synchronized (animateRunnable) {
                AnimationInstance.this.frameNumber++;
                if (AnimationInstance.this.frameNumber >= AnimationInstance.this.frameCount) {
                    AnimationInstance.this.frameNumber = 0;
                }
                animationFrame = AnimationInstance.this.getFrame();
            }
            if (animationFrame != null) {
                AnimationInstance.this.animate(animationFrame.getLeftOffset(), animationFrame.getTopOffset(), animationFrame.getWidth(), animationFrame.getHeight());
            }
        }

        public void stop() {
            timedExecution.removeRunnable(this);
            AnimationInstance.this.waiting = false;
        }

        public void scheduleFrame(AnimationFrame frame) {
            AnimationInstance.this.waiting = true;
            long time = System.currentTimeMillis();
            AnimationInstance.this.frameUpdateTime = time + frame.getAnimationTime();
            timedExecution.addRunnable(AnimationInstance.this.frameUpdateTime, this, this);
        }
    }
}

