/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.StringUtils;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.ImageProviderAPI;
import com.elluminate.util.image.SizeProvider;
import com.elluminate.util.log.LogSupport;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ImageSupport {
    public static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final int MAX_COMPRESSION = 9;
    public static final int MIN_COMPRESSION = 0;
    private static final ArrayList<ImageProviderAPI> providers = new ArrayList();
    private static final LinkedHashSet<String> inputTypes = new LinkedHashSet();
    private static final LinkedHashSet<String> outputTypes = new LinkedHashSet();
    private static final String[] PROVIDER_CLASS = new String[]{"com.elluminate.util.image.IIOImageProvider", "com.elluminate.util.image.PICTImageProvider"};
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final MediaTracker tracker;
    private static int trackerID;

    private static void updateImageTypes() {
        inputTypes.clear();
        outputTypes.clear();
        for (ImageProviderAPI ip : providers) {
            if (UtilDebug.IMAGE_LOADING.show()) {
                LogSupport.message(ImageSupport.class, "updateImageTypes", ip.getClass().getName() + " input=" + StringUtils.getStringValue(ip.getInputTypes()) + " output=" + StringUtils.getStringValue(ip.getOutputTypes()));
            }
            for (String t : ip.getInputTypes()) {
                if (t == null || t.trim().length() == 0) continue;
                inputTypes.add(t);
            }
            for (String t : ip.getOutputTypes()) {
                if (t == null || t.trim().length() == 0) continue;
                outputTypes.add(t);
            }
        }
        if (UtilDebug.IMAGE_LOADING.show()) {
            LogSupport.message(ImageSupport.class, "updateImageTypes", "inputTypes:  " + inputTypes + "\n" + "outputTypes: " + outputTypes);
        }
    }

    public static String[] getInputTypes() {
        return inputTypes.toArray(new String[inputTypes.size()]);
    }

    public static String[] getOutputTypes() {
        return outputTypes.toArray(new String[outputTypes.size()]);
    }

    public static Dimension getMaxSize() {
        return maxSize;
    }

    public static long getMaxPixels() {
        return ImageSupport.maxSize.height * ImageSupport.maxSize.width;
    }

    public static void setMaxSize(Dimension maxSize) {
        ImageSupport.maxSize = maxSize;
        for (ImageProviderAPI ip : providers) {
            ip.setMaxSize(maxSize);
        }
    }

    public static void setAutoScaleSizeProvider(SizeProvider sp) {
        for (ImageProviderAPI ip : providers) {
            ip.setAutoScaleSizeProvider(sp);
        }
    }

    public static Image loadImage(String mime, byte[] imageBytes) throws IOException {
        Image result = null;
        Iterator<ImageProviderAPI> itr = providers.iterator();
        while (itr.hasNext() && result == null) {
            ImageProviderAPI ip = itr.next();
            if (!ip.isSupportedInputType(mime) || (result = ip.loadImage(imageBytes, mime)) == null || !UtilDebug.IMAGE_LOADING.show()) continue;
            LogSupport.message(ImageSupport.class, "loadImage", "Loaded " + mime + " using " + ip);
        }
        if (result == null) {
            throw new UnsupportedImageDataTypeOrContentException(mime);
        }
        return result;
    }

    public static ImageInfo loadImage(String mime, byte[] imageBytes, boolean autoScale) throws IOException {
        ImageInfo result = null;
        Iterator<ImageProviderAPI> itr = providers.iterator();
        while (itr.hasNext() && result == null) {
            ImageProviderAPI ip = itr.next();
            if (!ip.isSupportedInputType(mime) || (result = ip.loadImage(imageBytes, mime, autoScale)) == null || !UtilDebug.IMAGE_LOADING.show()) continue;
            LogSupport.message(ImageSupport.class, "loadImage", "Loaded " + mime + " using " + ip);
        }
        if (result == null) {
            throw new UnsupportedImageDataTypeOrContentException(mime);
        }
        return result;
    }

    public static Image loadImage(byte[] imageBytes, File f) throws IOException {
        String mimeType = Platform.getMimeType(f);
        return ImageSupport.loadImage(mimeType, imageBytes);
    }

    public static Image loadImage(URL url) throws IOException {
        Image result = null;
        URLConnection connect = url.openConnection();
        String mimeType = connect.getContentType();
        Iterator<ImageProviderAPI> itr = providers.iterator();
        while (itr.hasNext() && result == null) {
            ImageProviderAPI ip = itr.next();
            if (!ip.isSupportedInputType(mimeType) || (result = ip.loadImage(url)) == null || !UtilDebug.IMAGE_LOADING.show()) continue;
            LogSupport.message(ImageSupport.class, "loadImage", "Loaded " + url + " using " + ip);
        }
        if (result == null) {
            throw new UnsupportedImageDataTypeOrContentException(url.toString());
        }
        return result;
    }

    public static Image loadImage(File f) throws IOException {
        return ImageSupport.loadImage(f, false);
    }

    public static Image loadImage(File f, boolean autoScale) throws IOException {
        Image result = null;
        String mimeType = Platform.getMimeType(f);
        Iterator<ImageProviderAPI> itr = providers.iterator();
        while (itr.hasNext() && result == null) {
            ImageProviderAPI ip = itr.next();
            if (!ip.isSupportedInputType(mimeType) || (result = ip.loadImage(f, autoScale)) == null || !UtilDebug.IMAGE_LOADING.show()) continue;
            LogSupport.message(ImageSupport.class, "loadImage", "Loaded " + f.getName() + " using " + ip);
        }
        if (result == null) {
            throw new UnsupportedImageDataTypeOrContentException(f.getName());
        }
        return result;
    }

    public static boolean hasTransparencySupport(Image img) {
        if (img == null) {
            return false;
        }
        if (img instanceof Transparency) {
            return ((Transparency)((Object)img)).getTransparency() != 1;
        }
        try {
            Method getColorModel = img.getClass().getMethod("getColorModel", new Class[0]);
            ColorModel cm = (ColorModel)getColorModel.invoke((Object)img, new Object[0]);
            return cm.getTransparency() != 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static BufferedImage toBufferedImage(Image img) {
        return ImageSupport.toBufferedImage(img, -1);
    }

    public static BufferedImage toBufferedImage(Image img, int type) {
        return ImageSupport.toBufferedImage(img, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toBufferedImage(Image img, int type, AlphaComposite alpha) {
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)img;
            if (type == -1) {
                return bufferedImage;
            }
            if (bufferedImage.getType() == type) {
                return bufferedImage;
            }
        }
        if (type == -1) {
            type = ImageSupport.hasTransparencySupport(img) ? 2 : 1;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage result = new BufferedImage(w, h, type);
        Graphics2D g = null;
        try {
            g = result.createGraphics();
            if (alpha != null) {
                g.setComposite(alpha);
            }
            g.drawImage(img, 0, 0, null);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScaledInstance(Image img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        if (img == null) {
            return null;
        }
        int type = ImageSupport.hasTransparencySupport(img) ? 2 : 1;
        Image result = null;
        Image toPaint = img;
        if (higherQuality) {
            w = img.getWidth(null);
            h = img.getHeight(null);
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = null;
            try {
                g2 = tmp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                g2.drawImage(toPaint, 0, 0, w, h, null);
            }
            finally {
                g2.dispose();
            }
            if (result != null) {
                result.flush();
            }
            result = tmp;
            toPaint = tmp;
        } while (w != targetWidth || h != targetHeight);
        return result;
    }

    public static int[] getImageArray(Image image) {
        if (image == null) {
            return null;
        }
        int imgW = image.getWidth(null);
        int imgH = image.getHeight(null);
        int[] imageRaster = new int[imgW * imgH];
        ImageSupport.getImageArray(image, imgW, imgH, imageRaster);
        return imageRaster;
    }

    public static void getImageArray(Image image, int imgW, int imgH, int[] imageRaster) {
        if (image == null) {
            throw new IllegalArgumentException("image is null");
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            bi.getRGB(0, 0, imgW, imgH, imageRaster, 0, imgW);
            return;
        }
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, imgW, imgH, imageRaster, 0, imgW);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException ex) {
            LogSupport.exception(ImageSupport.class, "getImageArray", ex, true);
        }
    }

    public static byte[] encodeAsPNG(Image img, int compression) {
        return ImageSupport.encodeImage(img, PNG_MIME_TYPE, compression);
    }

    public static byte[] encodeAsPNG(Image img) {
        return ImageSupport.encodeImage(img, PNG_MIME_TYPE, 9);
    }

    public static byte[] encodeAsJPEG(Image img, int quality) {
        return ImageSupport.encodeImage(img, JPEG_MIME_TYPE, quality);
    }

    public static byte[] encodeImage(Image img, String mime, int param) {
        if (img == null) {
            return null;
        }
        if (JPEG_MIME_TYPE.equalsIgnoreCase(mime) && ImageSupport.hasTransparencySupport(img)) {
            img = ImageSupport.toBufferedImage(img, 1);
        }
        byte[] result = null;
        for (ImageProviderAPI ip : providers) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                if (!ip.isSupportedOutputType(mime) || !ip.storeImage(img, bos, mime, param)) continue;
                result = bos.toByteArray();
                break;
            }
            catch (Exception ignored) {
            }
        }
        return result;
    }

    public static void saveAsPNG(Image img, int compression, File f) throws IOException {
        ImageSupport.saveToFile(img, f, PNG_MIME_TYPE, compression);
    }

    public static void saveAsJPEG(Image img, int quality, File f) throws IOException {
        ImageSupport.saveToFile(img, f, JPEG_MIME_TYPE, quality);
    }

    public static void saveToFile(Image img, File f, String mime) throws IOException {
        int param = 0;
        if (PNG_MIME_TYPE.equals(mime)) {
            param = 9;
        } else if (JPEG_MIME_TYPE.equals(mime)) {
            param = 85;
        }
        ImageSupport.saveToFile(img, f, mime, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(Image img, File f, String mime, int param) throws IOException {
        if (img == null) {
            throw new IllegalArgumentException("image is null");
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(f);
            bos = new BufferedOutputStream(fos, 16384);
            ImageSupport.saveToStream(img, bos, mime, param);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Throwable ignored) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    public static void saveToStream(Image img, OutputStream outStrm, String mime, int param) throws IOException {
        if (img == null) {
            throw new IllegalArgumentException("image is null");
        }
        if (JPEG_MIME_TYPE.equalsIgnoreCase(mime) && img instanceof BufferedImage) {
            img = ImageSupport.toBufferedImage(img, 1);
        }
        boolean success = false;
        for (ImageProviderAPI ip : providers) {
            if (!ip.storeImage(img, outStrm, mime, param)) continue;
            success = true;
            break;
        }
        if (!success) {
            throw new UnsupportedImageDataTypeOrContentException(mime);
        }
    }

    public static boolean waitForImage(Image image) {
        return ImageSupport.waitForImage(image, 5000L);
    }

    public boolean waitFor(Image image) {
        return ImageSupport.waitForImage(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image, long timeout) {
        int id;
        if (image == null) {
            return false;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            id = trackerID++;
        }
        tracker.addImage(image, id);
        try {
            tracker.waitForID(id, timeout);
            int status = tracker.statusID(id, false);
            if (status == 0) {
                LogSupport.message(ImageSupport.class, "waitForImage", "Failed to start loading image, status=" + status);
                boolean bl = false;
                return bl;
            }
            if (UtilDebug.IMAGE_LOADING.show() && (status & 0xFFFFFFF7) != 0) {
                int allKnownFlags;
                StringBuilder buf = new StringBuilder();
                if ((status & 4) != 0) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("errored");
                }
                if ((status & 2) != 0) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("aborted");
                }
                if ((status & 1) != 0) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("loading");
                }
                if ((status & 8) != 0) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("complete");
                }
                if ((status & ~(allKnownFlags = 15)) != 0) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append("UNKNOWN");
                }
                LogSupport.message(ImageSupport.class, "waitForImage", "Incomplete image load, status=" + buf + "=0x" + Integer.toHexString(status));
            }
            if ((status & 5) != 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ImageSupport.class, "waitForImage", ex, true);
            boolean bl = false;
            return bl;
        }
        finally {
            tracker.removeImage(image, id);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJpegRGBA(byte[] bytes) throws IOException {
        FilterInputStream istr = null;
        try {
            istr = new DataInputStream(new ByteArrayInputStream(bytes));
            boolean bl = ImageSupport.isJpegRGBA((DataInputStream)istr);
            return bl;
        }
        finally {
            if (istr != null) {
                istr.close();
            }
        }
    }

    public static boolean isJpegRGBA(DataInputStream istr) throws IOException {
        JpegBlock block = null;
        try {
            block = ImageSupport.nextBlock(istr);
            if (block != JpegBlock.SOI) {
                throw new IllegalArgumentException("Stream is not a JPEG stream");
            }
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Stream is not a JPEG stream");
        }
        while (true) {
            switch (block) {
                case SOF0: 
                case SOF2: {
                    int len = istr.readUnsignedShort();
                    byte bitsPerSample = istr.readByte();
                    int height = istr.readUnsignedShort();
                    int width = istr.readUnsignedShort();
                    byte nComponents = istr.readByte();
                    if (UtilDebug.JPEG.show()) {
                        System.out.print("(" + width + "x" + height + "," + nComponents + " components x " + bitsPerSample + " bits)");
                    }
                    return nComponents == 4;
                }
                case SOI: 
                case EOI: {
                    break;
                }
                case DNL: {
                    istr.skip(2L);
                    break;
                }
                default: {
                    int len = istr.readUnsignedShort();
                    if (len <= 2) break;
                    istr.skip(len - 2);
                }
            }
            block = ImageSupport.nextBlock(istr);
        }
    }

    private static JpegBlock nextBlock(DataInputStream istr) throws IOException {
        int tag;
        JpegBlock blk;
        do {
            if ((tag = istr.read()) != 255) {
                throw new EOFException();
            }
            tag = istr.read();
            if (tag >= 0) continue;
            throw new EOFException();
        } while ((blk = JpegBlock.find(tag)) == null);
        return blk;
    }

    static {
        for (String name : PROVIDER_CLASS) {
            try {
                Class<?> cls = Class.forName(name);
                ImageProviderAPI prov = (ImageProviderAPI)cls.newInstance();
                providers.add(prov);
            }
            catch (Throwable t) {
                if (!UtilDebug.IMAGE_LOADING.show()) continue;
                LogSupport.message(ImageSupport.class, "<clinit>", "Failed to initialize image loading provider " + name + "\n" + Debug.getStackTrace(t));
            }
        }
        ImageSupport.updateImageTypes();
        tracker = new MediaTracker(new Container(){
            private static final long serialVersionUID = 1L;
        });
        trackerID = 0;
    }

    public static class InsufficientMemoryExcetpion
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Dimension sr;

        InsufficientMemoryExcetpion(Dimension sr) {
            this.sr = sr;
        }

        public Dimension getReducedSize() {
            return this.sr;
        }
    }

    private static enum JpegBlock {
        SOI(216),
        SOF0(192),
        SOF1(193),
        SOF2(194),
        SOF3(195),
        SOF5(197),
        SOF6(198),
        SOF7(199),
        SOF8(200),
        SOF9(201),
        SOF10(202),
        SOF11(203),
        SOF13(205),
        SOF14(206),
        SOF15(207),
        DHT(196),
        DAT(204),
        RST0(208),
        RST1(209),
        RST2(210),
        RST3(211),
        RST4(212),
        RST5(213),
        RST6(214),
        RST7(215),
        DQT(219),
        SOS(218),
        DNL(220),
        DRI(221),
        DHP(222),
        EXP(223),
        APP0(224),
        APP1(225),
        APP2(226),
        APP3(227),
        APP4(228),
        APP5(229),
        APP6(230),
        APP7(231),
        APP8(232),
        APP9(233),
        APP10(234),
        APP11(235),
        APP12(236),
        APP13(237),
        APP14(238),
        APP15(239),
        EXT0(240),
        EXT1(241),
        EXT2(242),
        EXT3(243),
        EXT4(244),
        EXT5(245),
        EXT6(246),
        EXT7(247),
        EXT8(248),
        EXT9(249),
        EXTA(250),
        EXTB(251),
        EXTC(252),
        EXTD(253),
        COM(254),
        EOI(217);

        int code;

        private JpegBlock(int code) {
            this.code = code;
        }

        static JpegBlock find(int code) {
            for (JpegBlock blk : JpegBlock.values()) {
                if (blk.code != code) continue;
                return blk;
            }
            return null;
        }
    }

    public static class OversizeImageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OversizeImageException(long max) {
            super("Image too large, exceeds pixel limit of " + max);
        }
    }

    public static class UnsupportedImageDataTypeOrContentException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnsupportedImageDataTypeOrContentException(String source) {
            super("Failed to decode image data: " + source);
        }
    }
}

