/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.platform.Platform;
import com.elluminate.util.image.ImageSupport;
import java.io.File;

public class ImageMimeUtilities {
    private static final String[] COMMON_TYPES = new String[]{"image/gif", "image/jpeg", "image/png"};
    private static final char PARAM_SEPARATOR = ';';

    private ImageMimeUtilities() {
    }

    public static String getRawImageMimeType(String type) {
        if (type == null) {
            return null;
        }
        int idx = type.indexOf(59);
        if (idx < 0) {
            return type;
        }
        return type.substring(0, idx);
    }

    public static boolean isValidImageMimeType(String type) {
        if (type == null) {
            return false;
        }
        String[] mimeTypes = ImageSupport.getInputTypes();
        for (int ix = 0; ix < mimeTypes.length; ++ix) {
            if (!mimeTypes[ix].equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidImageMimeFile(File f) {
        String type = null;
        try {
            type = Platform.getMimeType(f);
            return ImageMimeUtilities.isValidImageMimeType(type);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isCommonImageType(String type) {
        if (type == null) {
            return false;
        }
        for (String t : COMMON_TYPES) {
            if (!type.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCommonImageFile(File f) {
        String type = null;
        try {
            type = Platform.getMimeType(f);
            return ImageMimeUtilities.isCommonImageType(type);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

