/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.event;

import com.elluminate.util.event.URLFillErrorEvent;
import com.elluminate.util.event.URLFillErrorEventSource;
import java.util.EventObject;

public class BufferFillEvent
extends EventObject {
    public static final int BUFFER_WRITE = 1;
    public static final int BUFFER_RESET = 2;
    public static final int BUFFER_DONE = 3;
    public static final int BUFFER_ABORT = 4;
    private int eventType;
    private long currentLength;
    private long totalLength;
    private byte[] lastBuffer;
    private int lastLength;

    public BufferFillEvent(Object src, int type, long current, long total, byte[] data, int len) {
        super(src);
        this.eventType = type;
        this.currentLength = current;
        this.totalLength = total;
        this.lastBuffer = data;
        this.lastLength = len;
    }

    public int getType() {
        return this.eventType;
    }

    public long getCurrentLength() {
        return this.currentLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public byte[] getLastBuffer() {
        return this.lastBuffer;
    }

    public int getLastLength() {
        return this.lastLength;
    }

    public void fireParseError(int errType, Throwable cause, int dispMask) {
        if (!(this.getSource() instanceof URLFillErrorEventSource)) {
            return;
        }
        if (this.eventType == 2 || this.eventType == 4) {
            return;
        }
        URLFillErrorEventSource url = (URLFillErrorEventSource)this.getSource();
        URLFillErrorEvent ev = new URLFillErrorEvent(url, errType, cause, dispMask);
        url.fireURLFillErrorListener(ev);
    }

    public void fireParseError(int errType, String msg, int dispMask) {
        if (!(this.getSource() instanceof URLFillErrorEventSource)) {
            return;
        }
        if (this.eventType == 2 || this.eventType == 4) {
            return;
        }
        URLFillErrorEventSource url = (URLFillErrorEventSource)this.getSource();
        URLFillErrorEvent ev = new URLFillErrorEvent(url, errType, msg, dispMask);
        url.fireURLFillErrorListener(ev);
    }

    public void fireParseError(int errType, Throwable cause, String msg, int dispMask) {
        if (!(this.getSource() instanceof URLFillErrorEventSource)) {
            return;
        }
        if (this.eventType == 2 || this.eventType == 4) {
            return;
        }
        URLFillErrorEventSource url = (URLFillErrorEventSource)this.getSource();
        URLFillErrorEvent ev = new URLFillErrorEvent(url, errType, cause, msg, dispMask);
        url.fireURLFillErrorListener(ev);
    }
}

