/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto.net;

import com.elluminate.util.StringComparator;
import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.CBCMode;
import com.elluminate.util.crypto.CryptoFactory;
import com.elluminate.util.crypto.MD4;
import com.elluminate.util.crypto.SecureHash;
import com.elluminate.util.crypto.ThreeDES;
import com.elluminate.util.crypto.net.AuthenticationException;
import com.elluminate.util.crypto.net.SequenceManager;
import com.elluminate.util.net.URLString;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class URLVerifier {
    private static StringComparator comparator = new StringComparator();
    private HashMap sources = new HashMap();
    private String encoding = System.getProperty("file.encoding");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(BigInteger uid, BigInteger key) {
        HashMap hashMap = this.sources;
        synchronized (hashMap) {
            if (this.sources.containsKey(uid)) {
                throw new IllegalArgumentException("Duplicate source " + uid.toString(36));
            }
            this.sources.put(uid, new SourceInfo(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(BigInteger uid) {
        HashMap hashMap = this.sources;
        synchronized (hashMap) {
            this.sources.remove(uid);
        }
    }

    public void setEncoding(String coding) throws UnsupportedEncodingException {
        URLEncoder.encode("this is a test", coding);
        this.encoding = coding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map verify(URL url, Set names, String enc) throws AuthenticationException, UnsupportedEncodingException {
        return this.verify(url.toString(), names, enc);
    }

    public Map verify(URL url, Set names) throws AuthenticationException {
        return this.verify(url.toString(), names);
    }

    public Map verify(URLString url, Set names, String enc) throws AuthenticationException, UnsupportedEncodingException {
        return this.verify(url.toString(), names, enc);
    }

    public Map verify(URLString url, Set names) throws AuthenticationException {
        return this.verify(url.toString(), names);
    }

    public Map verify(String url, Set names, String enc) throws AuthenticationException, UnsupportedEncodingException {
        Map m = this.parseArgs(url, enc);
        return this.verify(m, names);
    }

    public Map verify(String url, Set names) throws AuthenticationException {
        try {
            return this.verify(url, names, this.encoding);
        }
        catch (UnsupportedEncodingException uex) {
            throw new RuntimeException("verify failed:" + uex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map verify(Map args, Set names) throws AuthenticationException {
        BigInteger signature;
        byte[] iv;
        BlkCipher cipher;
        SecureHash sha;
        TreeSet<String> ordered = new TreeSet<String>(comparator);
        String idStr = (String)args.get("sigID");
        String seqStr = (String)args.get("sigSeq");
        String authStr = (String)args.get("sigAuth");
        String algStr = (String)args.get("sigAlg");
        String verStr = (String)args.get("sigVer");
        int ver = 1;
        BigInteger id = null;
        BigInteger seqInt = null;
        if (idStr == null || seqStr == null || authStr == null) {
            throw new AuthenticationException("URL is not signed.", 1);
        }
        if (algStr == null) {
            sha = new MD4();
            cipher = new ThreeDES();
        } else {
            try {
                CryptoFactory.BlockSignerPair pair = CryptoFactory.getBlockSignerPair(algStr);
                cipher = pair.cipher;
                sha = pair.hash;
            }
            catch (Throwable t) {
                throw new AuthenticationException("URL is signed with an unsupported algorithm set - " + algStr, 6);
            }
        }
        if (verStr != null && verStr.equals("2")) {
            ver = 2;
        }
        int hashlen = sha.hashByteLength();
        int blklen = cipher.getBlockByteLength();
        try {
            id = new BigInteger(idStr, 36);
        }
        catch (Throwable t) {
            throw new AuthenticationException("Invalid sigID: " + t, 2);
        }
        try {
            seqInt = new BigInteger(seqStr, 36);
        }
        catch (Throwable t) {
            throw new AuthenticationException("Invalid sigSeq: " + t, 2);
        }
        SourceInfo src = null;
        HashMap hashMap = this.sources;
        synchronized (hashMap) {
            src = (SourceInfo)this.sources.get(id);
        }
        if (src == null) {
            throw new AuthenticationException("Unknown originator id: " + idStr, 5);
        }
        int dot = authStr.indexOf(46);
        if (dot <= 0) throw new AuthenticationException("Malformed authentication string", 2);
        String ivstr = authStr.substring(0, dot);
        String sigstr = authStr.substring(dot + 1);
        try {
            BigInteger ivint = new BigInteger(ivstr, 36);
            iv = ivint.toByteArray();
            signature = new BigInteger(sigstr, 36);
            if (iv.length != blklen) {
                byte[] newiv = new byte[blklen];
                int ivoff = Math.max(0, iv.length - blklen);
                int newoff = Math.max(0, blklen - iv.length);
                int len = Math.min(blklen, iv.length);
                System.arraycopy(iv, ivoff, newiv, newoff, len);
                if (newoff > 0 && iv[ivoff] < 0) {
                    Arrays.fill(newiv, 0, newoff, (byte)-1);
                }
                iv = newiv;
            }
        }
        catch (Throwable t) {
            throw new AuthenticationException("Malformed authentication string", 2);
        }
        ordered.addAll(names);
        ordered.add("sigID");
        ordered.add("sigSeq");
        ordered.add("sigAlg");
        ordered.add("sigVer");
        for (String name : ordered) {
            String value = (String)args.get(name);
            if (value == null) continue;
            if (ver == 2) {
                try {
                    sha.process(name.getBytes("UTF-8"));
                    sha.process(value.getBytes("UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException uex) {
                    throw new AuthenticationException("UTF-8 encoding not supported.", 0);
                }
            }
            sha.process(name.getBytes());
            sha.process(value.getBytes());
        }
        byte[] hash = sha.hash();
        if (hashlen % blklen != 0) {
            int pad = blklen - hashlen % blklen;
            byte[] padded = new byte[hash.length + pad];
            System.arraycopy(hash, 0, padded, pad, hash.length);
            hash = padded;
        }
        CBCMode cbc = new CBCMode(cipher, src.srcKey.toByteArray());
        byte[] auth = new byte[hash.length];
        cbc.encrypt(iv, 0, hash, 0, auth, 0, hash.length);
        BigInteger authInt = new BigInteger(auth);
        if (!authInt.equals(signature)) {
            throw new AuthenticationException("Authentication failed.", 7);
        }
        src.srcSeq.checkSequence(seqInt.longValue());
        return args;
    }

    private Map parseArgs(String url, String enc) throws UnsupportedEncodingException {
        TreeMap<String, String> m = new TreeMap<String, String>(comparator);
        int i = url.lastIndexOf(63);
        while (i > 0) {
            int eq = url.indexOf(61, i + 1);
            String name = url.substring(i + 1, eq);
            i = url.indexOf(38, eq + 1);
            String value = i < 0 ? url.substring(eq + 1) : url.substring(eq + 1, i);
            try {
                m.put(URLDecoder.decode(name, enc), URLDecoder.decode(value, enc));
            }
            catch (UnsupportedEncodingException uex) {
                uex.printStackTrace();
                throw new RuntimeException(uex.toString());
            }
        }
        return m;
    }

    public static void main(String[] args) {
        HashMap<String, String> test1 = new HashMap<String, String>();
        HashMap<String, String> test2 = new HashMap<String, String>();
        HashMap<String, String> test3 = new HashMap<String, String>();
        HashSet<String> names = new HashSet<String>();
        URLVerifier verifier = new URLVerifier();
        BigInteger key = new BigInteger("13tdppqdcb7ol6jsg3darxj8wjfxdpq9y0ug3u", 36);
        BigInteger id = new BigInteger("1po1vk3hop6dy", 36);
        names.add("req");
        names.add("conf");
        names.add("name");
        test1.put("conf", "dev|eLive-TNG1");
        test1.put("name", "Bob");
        test1.put("req", "join");
        test1.put("sigAlg", "SHA256.AES-128");
        test1.put("sigID", "1po1vk3hop6dy");
        test1.put("sigSeq", "1");
        test1.put("sigAuth", "-5tc4bj6p65a5678fxh1ujzk00.-2w3mp1g09947rhma4b5owpenkln0xhkxweew8ujyfhzdmh6nc");
        test2.put("conf", "dev|eLive-TNG1");
        test2.put("name", "Bob");
        test2.put("req", "join");
        test2.put("sigAlg", "SHA256.AES-128");
        test2.put("sigID", "1po1vk3hop6dy");
        test2.put("sigSeq", "2");
        test2.put("sigAuth", "-41zzp3qrp9ryn5vrguqywr2qj.-14ysf8sva6o9l88ot1yot4qli0p9k1bkanorzeaaxs03b4s313");
        test2.put("extra", "stuff");
        test3.put("conf", "dev|eLive-TNG1");
        test3.put("name", "Joe");
        test3.put("req", "join");
        test3.put("sigAlg", "SHA256.AES-128");
        test3.put("sigID", "1po1vk3hop6dy");
        test3.put("sigSeq", "3");
        test3.put("sigAuth", "3cqzp45bruba71rxg9ptrb3ce.jdyxnu4rkz9mi7wrgfoh1p5ty6a9xmed7nfxyre6mysijqh2y");
        verifier.addSource(id, key);
        try {
            verifier.verify(test1, names);
            System.out.println("Test 1 succeeded - signature verified");
        }
        catch (AuthenticationException ax) {
            System.out.println("Test 1 failed - " + ax);
        }
        try {
            verifier.verify(test1, names);
            System.out.println("Test 1 repeat failed - replay accepted.");
        }
        catch (AuthenticationException ax) {
            System.out.println("Test 1 repeat succeeded - replay rejected.");
        }
        try {
            verifier.verify(test2, names);
            System.out.println("Test 2 succeeded - signature verified, extra stuff ignored.");
        }
        catch (AuthenticationException ax) {
            System.out.println("Test 2 failed - " + ax);
        }
        try {
            test3.put("name", "Bob");
            verifier.verify(test3, names);
            System.out.println("Test 3 failed - corrupted data accepted.");
        }
        catch (AuthenticationException ax) {
            System.out.println("Test 3 succeeded - corrupted data rejected.");
        }
    }

    class SourceInfo {
        BigInteger srcKey;
        SequenceManager srcSeq;

        public SourceInfo(BigInteger key) {
            this.srcKey = key;
            this.srcSeq = new SequenceManager();
        }
    }
}

