/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto.net;

import com.elluminate.util.crypto.net.AuthenticationException;
import java.util.LinkedList;
import java.util.ListIterator;

public class SequenceManager {
    public static final long OBSOLETE_LIMIT = 65536L;
    private LinkedList values = new LinkedList();
    private Block opt = new Block(1L, Long.MAX_VALUE);
    private long next = 1L;
    private long latest = 0L;

    public SequenceManager() {
        this.values.add(this.opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNext() {
        long seq = 0L;
        SequenceManager sequenceManager = this;
        synchronized (sequenceManager) {
            seq = this.next++;
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSequence(long value) throws AuthenticationException {
        SequenceManager sequenceManager = this;
        synchronized (sequenceManager) {
            if (value > this.latest) {
                this.latest = value;
            }
            if (this.opt != null) {
                if (this.opt.from == value) {
                    ++this.opt.from;
                    if (this.opt.from > this.opt.to) {
                        this.values.remove(this.opt);
                        this.opt = null;
                    }
                    return;
                }
                if (value == this.opt.to) {
                    --this.opt.to;
                    return;
                }
            }
            this.opt = null;
            if (value < this.latest - 65536L) {
                throw new AuthenticationException("Sequence number " + value + " is stale", 3);
            }
            ListIterator<Block> i = this.values.listIterator();
            while (i.hasNext()) {
                Block b = (Block)i.next();
                if (value < b.from) {
                    throw new AuthenticationException("Sequence number " + value + " has already been used.", 4);
                }
                if (value > b.to) {
                    if (b.to >= value - 65536L) continue;
                    i.remove();
                    continue;
                }
                if (value == b.from) {
                    ++b.from;
                    if (b.from > b.to) {
                        i.remove();
                        this.opt = (Block)i.next();
                        return;
                    }
                    this.opt = b;
                    return;
                }
                if (value == b.to) {
                    --b.to;
                    return;
                }
                Block split = new Block(value + 1L, b.to);
                b.to = value - 1L;
                i.add(split);
                this.opt = split;
                return;
            }
        }
        throw new AuthenticationException("Sequence number " + value + " has already been used.", 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        SequenceManager sequenceManager = this;
        synchronized (sequenceManager) {
            for (Block b : this.values) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(b);
            }
        }
        return buf.toString();
    }

    class Block {
        long from;
        long to;

        public Block(long min, long max) {
            this.from = min;
            this.to = max;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.from);
            buf.append('-');
            buf.append(this.to);
            return buf.toString();
        }
    }
}

