/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.AES;
import com.elluminate.util.crypto.CBCMode;
import com.elluminate.util.crypto.Hex;
import com.elluminate.util.crypto.MD4;
import com.elluminate.util.crypto.SHA256;
import com.elluminate.util.crypto.SecureHash;
import com.elluminate.util.crypto.ThreeDES;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RSALicenseDecoder
extends InputStream {
    public static final byte FORMAT_V1 = 1;
    public static final byte FORMAT_V2 = 2;
    static final byte[] TAG_RSA2 = new byte[]{82, 83, 65, 2};
    private byte[] buffer;
    private int count;
    private int off;
    private byte format;
    private BigInteger exp;
    private BigInteger mod;

    public RSALicenseDecoder(byte[] ciphertext, BigInteger exp, BigInteger mod) throws IOException {
        this.exp = exp;
        this.mod = mod;
        this.format = RSALicenseDecoder.checkTag(ciphertext, TAG_RSA2) ? this.decodeV2(ciphertext) : this.decodeV1(ciphertext);
    }

    private byte decodeV2(byte[] ciphertext) throws IOException {
        DataInputStream cstr = new DataInputStream(new ByteArrayInputStream(ciphertext));
        cstr.skipBytes(TAG_RSA2.length);
        BigInteger sessionKey = this.readBigInt(cstr);
        BigInteger sessionHash = this.readBigInt(cstr);
        BigInteger key = sessionKey.modPow(this.exp, this.mod);
        BigInteger hash = sessionHash.modPow(this.exp, this.mod);
        AES aes = new AES(128);
        SHA256 sha = new SHA256();
        int blkLen = aes.getBlockByteLength();
        byte[] vector = new byte[blkLen];
        CBCMode cbc = new CBCMode(aes, key.toByteArray());
        cstr.readFully(vector);
        this.count = cstr.available();
        if (this.count % blkLen != 0) {
            throw new IOException("RSALicense block is corrupt - Invalid content length of " + this.count);
        }
        this.buffer = new byte[this.count];
        this.off = ciphertext.length - this.count;
        cbc.decrypt(vector, 0, ciphertext, this.off, this.buffer, 0, this.count);
        BigInteger computed = RSALicenseDecoder.getHash(sha, this.buffer);
        if (!computed.equals(hash)) {
            throw new IOException("RSALicense block is corrupt - Hash mismatch.");
        }
        this.off = 0;
        return 2;
    }

    private byte decodeV1(byte[] ciphertext) throws IOException {
        DataInputStream cstr = new DataInputStream(new ByteArrayInputStream(ciphertext));
        BigInteger key = this.readBigInt(cstr);
        key = key.modPow(this.exp, this.mod);
        byte[] vector = new byte[8];
        cstr.readFully(vector);
        ThreeDES des = new ThreeDES();
        MD4 md4 = new MD4();
        byte[] block = new byte[8];
        this.count = cstr.available() - md4.hashByteLength();
        if (this.count % 8 != 0) {
            throw new IOException("RSALicense block is corrupt - Invalid content length of " + this.count);
        }
        des.init(key.toByteArray(), false);
        this.buffer = new byte[this.count];
        for (int i = 0; i < this.count; i += 8) {
            cstr.readFully(block);
            des.processBlock(block, 0, this.buffer, i);
            for (int j = 0; j < 8; ++j) {
                int n = i + j;
                this.buffer[n] = (byte)(this.buffer[n] ^ vector[j]);
            }
            System.arraycopy(block, 0, vector, 0, 8);
        }
        md4.process(this.buffer);
        byte[] hash = new byte[md4.hashByteLength()];
        cstr.readFully(hash);
        if (!Hex.toString(hash).equals(Hex.toString(md4.hash()))) {
            throw new IOException("RSALicense block is corrupt - Hash mismatch.");
        }
        this.off = 0;
        return 1;
    }

    @Override
    public int read() {
        if (this.off == this.count) {
            return -1;
        }
        return this.buffer[this.off++] & 0xFF;
    }

    @Override
    public int available() {
        return this.count - this.off;
    }

    public byte getFormat() {
        return this.format;
    }

    public static byte getFormat(byte[] ciphertext) {
        if (RSALicenseDecoder.checkTag(ciphertext, TAG_RSA2)) {
            return 2;
        }
        return 1;
    }

    private BigInteger readBigInt(DataInputStream str) throws IOException {
        short nBytes = str.readShort();
        byte[] data = new byte[nBytes];
        str.readFully(data);
        return new BigInteger(data);
    }

    private static boolean checkTag(byte[] buffer, byte[] tag) {
        if (buffer.length < tag.length) {
            return false;
        }
        for (int i = 0; i < tag.length; ++i) {
            if (buffer[i] == tag[i]) continue;
            return false;
        }
        return true;
    }

    public static BigInteger getHash(SecureHash sha, byte[] buffer) {
        sha.process(buffer);
        byte[] hashBytes = sha.hash();
        if ((hashBytes[0] & 0x80) != 0) {
            byte[] padded = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, padded, 1, hashBytes.length);
            hashBytes = padded;
        }
        return new BigInteger(hashBytes);
    }
}

