/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.Hex;
import com.elluminate.util.crypto.SecureHash;

public class MD4
implements SecureHash {
    private static final byte[] PAD = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] SHIFT1 = new int[]{3, 7, 11, 19, 3, 7, 11, 19, 3, 7, 11, 19, 3, 7, 11, 19};
    private static final int[] SHIFT2 = new int[]{3, 5, 9, 13, 3, 5, 9, 13, 3, 5, 9, 13, 3, 5, 9, 13};
    private static final int[] SHIFT3 = new int[]{3, 9, 11, 15, 3, 9, 11, 15, 3, 9, 11, 15, 3, 9, 11, 15};
    private static final int[] SEQ1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SEQ2 = new int[]{0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15};
    private static final int[] SEQ3 = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};
    private int A = 1732584193;
    private int B = -271733879;
    private int C = -1732584194;
    private int D = 271733878;
    private long total = 0L;
    private int[] buf = new int[16];
    private int word = 0;
    private int shift = 0;
    private RoundFunc FF = new Round1();
    private RoundFunc GG = new Round2();
    private RoundFunc HH = new Round3();

    public MD4() {
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
    }

    @Override
    public String getName() {
        return "MD4";
    }

    @Override
    public void reset() {
        this.A = 1732584193;
        this.B = -271733879;
        this.C = -1732584194;
        this.D = 271733878;
        this.total = 0L;
        this.word = 0;
        this.shift = 0;
    }

    @Override
    public void process(byte[] data) {
        this.doProcess(data, 0, data.length, true);
    }

    @Override
    public void process(byte[] data, int off, int len) {
        this.doProcess(data, off, len, true);
    }

    @Override
    public byte[] hash() {
        this.pad();
        byte[] hash = new byte[16];
        this.writeInt(this.A, hash, 0);
        this.writeInt(this.B, hash, 4);
        this.writeInt(this.C, hash, 8);
        this.writeInt(this.D, hash, 12);
        this.reset();
        return hash;
    }

    @Override
    public int hashByteLength() {
        return 16;
    }

    @Override
    public int hashBitLength() {
        return 128;
    }

    private int F(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    private int G(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private int H(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int rotl(int X, int N) {
        return X << N | X >>> 32 - N;
    }

    private void compute() {
        int AA = this.A;
        int BB = this.B;
        int CC = this.C;
        int DD = this.D;
        this.doRound(this.FF, SEQ1, SHIFT1);
        this.doRound(this.GG, SEQ2, SHIFT2);
        this.doRound(this.HH, SEQ3, SHIFT3);
        this.A += AA;
        this.B += BB;
        this.C += CC;
        this.D += DD;
    }

    private void dumpState(String prefix) {
        System.out.println(prefix + Hex.toString(this.A) + "," + Hex.toString(this.B) + "," + Hex.toString(this.C) + "," + Hex.toString(this.D));
    }

    private void doRound(RoundFunc func, int[] seq, int[] shifts) {
        for (int i = 0; i < 16; ++i) {
            this.A = func.exec(this.A, this.B, this.C, this.D, this.buf[seq[i]], shifts[i]);
            this.D = func.exec(this.D, this.A, this.B, this.C, this.buf[seq[++i]], shifts[i]);
            this.C = func.exec(this.C, this.D, this.A, this.B, this.buf[seq[++i]], shifts[i]);
            this.B = func.exec(this.B, this.C, this.D, this.A, this.buf[seq[++i]], shifts[i]);
        }
    }

    private void doProcess(byte[] data, int off, int len, boolean count) {
        while (len > 0) {
            int n = this.word++;
            this.buf[n] = this.buf[n] | (data[off] & 0xFF) << this.shift;
            ++off;
            --len;
            this.shift += 8;
            if (this.shift == 32) {
                this.shift = 0;
            }
            if (this.word == 16) {
                this.compute();
                for (int i = 0; i < this.buf.length; ++i) {
                    this.buf[i] = 0;
                }
                this.word = 0;
            }
            if (!count) continue;
            this.total += 8L;
        }
    }

    private void pad() {
        int at = (int)(this.total % 512L) / 8;
        int len = at < 56 ? 56 - at : 120 - at;
        this.doProcess(PAD, 0, len, false);
        byte[] bits = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bits[i] = (byte)(this.total >> 8 * i & 0xFFL);
        }
        this.doProcess(bits, 0, bits.length, false);
    }

    private void writeInt(int V, byte[] buf, int off) {
        for (int i = 0; i < 4; ++i) {
            buf[off + i] = (byte)(V >> i * 8 & 0xFF);
        }
    }

    private class Round1
    implements RoundFunc {
        private Round1() {
        }

        @Override
        public int exec(int a, int b, int c, int d, int k, int s) {
            return MD4.this.rotl(a + MD4.this.F(b, c, d) + k, s);
        }
    }

    private class Round2
    implements RoundFunc {
        private Round2() {
        }

        @Override
        public int exec(int a, int b, int c, int d, int k, int s) {
            return MD4.this.rotl(a + MD4.this.G(b, c, d) + k + 1518500249, s);
        }
    }

    private class Round3
    implements RoundFunc {
        private Round3() {
        }

        @Override
        public int exec(int a, int b, int c, int d, int k, int s) {
            return MD4.this.rotl(a + MD4.this.H(b, c, d) + k + 1859775393, s);
        }
    }

    static interface RoundFunc {
        public int exec(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

