/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.SecureHash;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HashedOutputStream
extends FilterOutputStream {
    private SecureHash hash = null;
    private byte[] buffer = new byte[1];

    public HashedOutputStream(OutputStream out, SecureHash h) {
        super(out);
        this.hash = h;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[0] = (byte)(b & 0xFF);
        this.hash.process(this.buffer);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.hash.process(b, off, len);
        this.out.write(b, off, len);
    }

    public byte[] getHash() {
        return this.hash.hash();
    }

    public int getHashBitLength() {
        return this.hash.hashBitLength();
    }

    public int getHashByteLength() {
        return this.hash.hashByteLength();
    }
}

