/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.AES;
import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.DES;
import com.elluminate.util.crypto.Hex;
import com.elluminate.util.crypto.ThreeDES;
import java.security.SecureRandom;

public class CBCMode {
    private static SecureRandom rnd = new SecureRandom();
    private BlkCipher cipher;
    int blkBytes;
    private byte[] key;
    private byte[] temp1;
    private byte[] temp2;

    public CBCMode(BlkCipher cipher, byte[] key) {
        this.cipher = cipher;
        this.key = key;
        this.blkBytes = cipher.getBlockByteLength();
    }

    public byte[] createIV() {
        byte[] iv = new byte[this.cipher.getBlockByteLength()];
        rnd.nextBytes(iv);
        return iv;
    }

    public void encrypt(byte[] iv, int ivOff, byte[] plainTxt, int plainOff, byte[] cipherTxt, int cipherOff, int len) {
        this.cipher.init(this.key, true);
        if (len % this.blkBytes != 0) {
            throw new IllegalArgumentException("length is not a multiple of the cipher block size.");
        }
        while (len > 0) {
            for (int i = 0; i < this.blkBytes; ++i) {
                cipherTxt[cipherOff + i] = (byte)(plainTxt[plainOff + i] ^ iv[ivOff + i]);
            }
            this.cipher.processBlock(cipherTxt, cipherOff);
            iv = cipherTxt;
            ivOff = cipherOff;
            len -= this.blkBytes;
            plainOff += this.blkBytes;
            cipherOff += this.blkBytes;
        }
    }

    public void decrypt(byte[] iv, int ivOff, byte[] cipherTxt, int cipherOff, byte[] plainTxt, int plainOff, int len) {
        this.cipher.init(this.key, false);
        if (len % this.blkBytes != 0) {
            throw new IllegalArgumentException("length is not a multiple of the cipher block size.");
        }
        if (this.temp1 == null) {
            this.temp1 = new byte[this.blkBytes];
            this.temp2 = new byte[this.blkBytes];
        }
        System.arraycopy(iv, ivOff, this.temp1, 0, this.blkBytes);
        byte[] blk = this.temp2;
        iv = this.temp1;
        while (len > 0) {
            System.arraycopy(cipherTxt, cipherOff, blk, 0, this.blkBytes);
            this.cipher.processBlock(cipherTxt, cipherOff, plainTxt, plainOff);
            for (int i = 0; i < this.blkBytes; ++i) {
                int n = plainOff + i;
                plainTxt[n] = (byte)(plainTxt[n] ^ iv[i]);
            }
            byte[] tmp = iv;
            iv = blk;
            blk = tmp;
            cipherOff += this.blkBytes;
            plainOff += this.blkBytes;
            len -= this.blkBytes;
        }
    }

    public static void main(String[] args) {
        byte[] plain = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, 15, 30, 45, 60, 75, 90, 105, 120, -121, -106, -91, -76, -61, -46, -31, -16, 18, -17, -2, 16, 35, -51, -36, 50, 69, -85, -70, 84, 103, -119, -104, 118, 15, -31, 45, -61, 75, -91, 105, -121};
        byte[] cipher = new byte[plain.length];
        byte[] decode = new byte[plain.length];
        BlkCipher[] ciphers = new BlkCipher[]{new DES(), new ThreeDES(), new AES(128), new AES(192), new AES(256)};
        String hexOrig = Hex.toString(plain);
        for (int i = 0; i < ciphers.length; ++i) {
            byte[] key = new byte[ciphers[i].getKeyByteLength()];
            rnd.nextBytes(key);
            CBCMode cbc = new CBCMode(ciphers[i], key);
            byte[] iv = cbc.createIV();
            cbc.encrypt(iv, 0, plain, 0, cipher, 0, plain.length);
            cbc.decrypt(iv, 0, cipher, 0, decode, 0, cipher.length);
            String hexIV = Hex.toString(iv);
            String hexCipher = Hex.toString(cipher);
            String hexDecode = Hex.toString(decode);
            System.out.println(ciphers[i].getName());
            if (!hexOrig.equals(hexDecode)) {
                System.out.print("  FAILED");
            } else {
                System.out.print("  PASSED");
            }
            System.out.println("  " + hexOrig + " -> \n    [" + hexIV + "]" + hexCipher + "\n -> " + hexDecode);
            System.arraycopy(plain, 0, cipher, 0, plain.length);
            cbc.encrypt(iv, 0, cipher, 0, cipher, 0, cipher.length);
            cbc.decrypt(iv, 0, cipher, 0, cipher, 0, cipher.length);
            hexCipher = Hex.toString(cipher);
            if (!hexOrig.equals(hexCipher)) {
                System.out.println("  FAILED in place");
                continue;
            }
            System.out.println("  PASSED in place");
        }
    }
}

