/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command.net;

import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointListener;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.util.Debug;
import com.elluminate.util.command.CommandProcessor;
import com.elluminate.util.command.net.HangupCmd;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class RemoteCommandProcessor {
    private CommandProcessor cp = null;
    private PrintStream out = null;
    private PrintStream err = null;
    private BufferedReader console = null;
    private Endpoint endpoint = null;
    private File keyFile = null;
    private char[] keyPass = null;
    private File trustFile = null;
    private char[] trustPass = null;

    public RemoteCommandProcessor(CommandProcessor cp) {
        this.cp = cp;
        cp.addCommand("bye", new HangupCmd(this));
        cp.setPrompt("");
    }

    public boolean isAttached() {
        return this.endpoint != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(Endpoint s) throws IllegalStateException {
        boolean running = true;
        Debug.lockEnter(this, "attach", null, this);
        RemoteCommandProcessor remoteCommandProcessor = this;
        synchronized (remoteCommandProcessor) {
            if (this.endpoint != null) {
                throw new IllegalStateException("AlreadyAttached");
            }
            this.endpoint = s;
        }
        Debug.lockLeave(this, "attach", null, this);
        PrintStream saveErr = this.cp.getErrorStream();
        PrintStream saveOut = this.cp.getOutputStream();
        BufferedReader saveIn = this.cp.getReader();
        try {
            InputStream rawIn = s.getInputStream();
            OutputStream rawOut = s.getOutputStream();
            this.console = new BufferedReader(new InputStreamReader(rawIn));
            this.err = this.out = new PrintStream(rawOut);
            this.cp.setErrorStream(this.err);
            this.cp.setOutputStream(this.out);
            this.cp.setReader(this.console);
            this.cp.run();
            running = false;
        }
        catch (IOException ex) {
            running = true;
        }
        this.cp.setErrorStream(saveErr);
        this.cp.setOutputStream(saveOut);
        this.cp.setReader(saveIn);
        Debug.lockEnter(this, "attach", null, this);
        RemoteCommandProcessor remoteCommandProcessor2 = this;
        synchronized (remoteCommandProcessor2) {
            this.endpoint = null;
        }
        Debug.lockLeave(this, "attach", null, this);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hangup() {
        Debug.lockEnter(this, "attach", null, this);
        RemoteCommandProcessor remoteCommandProcessor = this;
        synchronized (remoteCommandProcessor) {
            if (this.endpoint != null) {
                this.endpoint.closeForce();
            }
        }
        Debug.lockLeave(this, "attach", null, this);
    }

    public void setKeyInfo(String store, char[] pass) {
        if (store == null) {
            this.keyFile = null;
            this.keyPass = null;
        } else {
            this.keyFile = new File(store);
            this.keyPass = pass;
        }
    }

    public void setTrustInfo(String store, char[] pass) {
        if (store == null) {
            this.trustFile = null;
            this.trustPass = null;
        } else {
            this.trustFile = new File(store);
            this.trustPass = pass;
        }
    }

    public void listen(int port, int timeout) {
        EndpointListener l = null;
        Endpoint ep = null;
        try {
            l = new EndpointListener("direct", port);
        }
        catch (IOException ex) {
            LogSupport.exception(this, "listen", ex, true);
            return;
        }
        while (true) {
            try {
                do {
                    ep = l.accept();
                } while (this.attach(ep = EndpointSecurity.secureServer(ep, this.keyFile, this.keyPass, this.trustFile, this.trustPass, true)));
                ep.closeForce();
            }
            catch (Exception ex) {
                LogSupport.exception(this, "listen", ex, false);
                if (ep == null) continue;
                ep.closeForce();
                continue;
            }
            break;
        }
        l.closeForce();
    }
}

