/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UtilDebug;
import com.elluminate.util.WorkQueue;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;

public class WorkerPool {
    public static final long WORKER_TIMEOUT = 60000L;
    public static final int DEFAULT_POOL_SIZE = 4;
    private Object wLock = new Object();
    private int wIndex = 0;
    private String wName;
    private Worker[] pool = null;
    private WorkQueue queue = null;
    private Object lock = null;
    private int nLive = 0;
    private int nWorkers = 0;
    private ThreadGroup threadGroup = null;
    private boolean shutdown = false;
    private int priority = 5;

    public WorkerPool(String name, WorkQueue queue) {
        this(name, queue, 4);
    }

    public WorkerPool(String name, WorkQueue queue, int poolSize) {
        this(name, queue, poolSize, Thread.currentThread().getThreadGroup());
    }

    public WorkerPool(String name, WorkQueue queue, int poolSize, ThreadGroup grp) {
        this.threadGroup = grp;
        this.pool = new Worker[poolSize];
        this.queue = queue;
        this.wName = name;
        queue.setWorkerPool(this);
        this.lock = queue.getLock();
    }

    public void setPriority(int pri) {
        this.priority = pri;
    }

    public int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = true;
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] == null) continue;
                this.pool[i].shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNow(Runnable r, boolean spawn) {
        boolean doSpawn;
        Worker w;
        block8: {
            w = null;
            doSpawn = false;
            Object object = this.lock;
            synchronized (object) {
                block7: {
                    if (this.nWorkers != 0) break block7;
                    if (this.nLive >= this.pool.length && !spawn) break block8;
                    ++this.nLive;
                    doSpawn = true;
                    break block8;
                }
                for (int i = 0; i < this.pool.length; ++i) {
                    if (this.pool[i] == null) continue;
                    w = this.pool[i];
                    this.pool[i] = null;
                    --this.nWorkers;
                    break;
                }
            }
        }
        if (doSpawn) {
            w = new Worker(this);
            w.execute(r);
            w.start();
        } else if (w != null) {
            w.execute(r);
        }
        return w != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Worker w) {
        Object object = this.lock;
        synchronized (object) {
            Runnable r = this.queue.getWork();
            if (r != null) {
                w.execute(r);
                return false;
            }
            if (this.shutdown || this.nWorkers == this.pool.length) {
                --this.nLive;
                return false;
            }
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != null) continue;
                this.pool[i] = w;
                ++this.nWorkers;
                this.lock.notify();
                return true;
            }
            --this.nLive;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dequeue(Worker w) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] != w) continue;
                this.pool[i] = null;
                --this.nWorkers;
                --this.nLive;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getWorkerName() {
        String nm;
        Object object = this.wLock;
        synchronized (object) {
            nm = this.wName + "-" + ++this.wIndex;
        }
        return nm;
    }

    ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public static class Worker
    extends WorkerThread {
        private WorkerPool pool;
        private Runnable run = null;
        private boolean shutdown = false;
        private Object barrier = new Object();

        public Worker(WorkerPool p) {
            super(p.getThreadGroup(), p.getWorkerName(), 5);
            if (UtilDebug.THREAD_POOL.show()) {
                LogSupport.message(this, "<init>", "Created worker thread " + this.getName() + "(" + System.identityHashCode(this) + ")");
            }
            this.setDaemon(true);
            this.setPriority(p.priority);
            this.pool = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                this.run = this.waitForWork(60000L);
                if (this.run == null) {
                    if (this.pool.dequeue(this)) {
                        if (UtilDebug.THREAD_POOL.show()) {
                            LogSupport.message(this, "run", "Worker thread " + System.identityHashCode(this) + " shutting down on timeout.");
                        }
                        return;
                    }
                    this.run = this.waitForWork(20L);
                }
                while (this.run != null) {
                    if (UtilDebug.THREAD_POOL.show()) {
                        LogSupport.message(this, "run", "Worker thread " + System.identityHashCode(this) + " executing runnable " + this.run.getClass().toString());
                    }
                    try {
                        Object object = this.barrier;
                        synchronized (object) {
                            this.run.run();
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception(this, "run", t, true);
                    }
                    this.run = this.pool.queue.getWork();
                }
                if (!this.pool.enqueue(this)) {
                    if (this.run != null) continue;
                    if (UtilDebug.TIMERS.show()) {
                        LogSupport.message(this, "run", "Worker thread " + System.identityHashCode(this) + " shutting down on queue full.");
                    }
                    return;
                }
                if (!UtilDebug.TIMERS.show()) continue;
                LogSupport.message(this, "run", "Worker thread " + System.identityHashCode(this) + " returned to pool.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Worker worker = this;
            synchronized (worker) {
                this.shutdown = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable waitForWork(long delay) {
            long now = System.currentTimeMillis();
            long timeout = now + delay;
            Worker worker = this;
            synchronized (worker) {
                while (this.run == null && delay > 0L && !this.shutdown) {
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                    delay = timeout - System.currentTimeMillis();
                }
            }
            return this.run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable r) {
            Worker worker = this;
            synchronized (worker) {
                this.run = r;
                this.notify();
            }
        }
    }
}

