/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class VarMsgFormat {
    private VarMsgFormat() {
    }

    public static String format(String pattern, Map vars) {
        if (vars == null || vars.size() == 0) {
            return pattern;
        }
        Object[] args = new Object[vars.size()];
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        int idx = 0;
        for (String key : vars.keySet()) {
            args[idx] = vars.get(key);
            names.put(key, new Integer(idx++));
        }
        StringBuffer buf = new StringBuffer(pattern);
        while (VarMsgFormat.substituteVariable(buf, names)) {
        }
        return MessageFormat.format(buf.toString(), args);
    }

    private static boolean substituteVariable(StringBuffer buf, Map names) {
        for (String name : names.keySet()) {
            int idx = (Integer)names.get(name);
            if (VarMsgFormat.replace(buf, "{" + name + ",", idx)) {
                return true;
            }
            if (!VarMsgFormat.replace(buf, "{" + name + "}", idx)) continue;
            return true;
        }
        return false;
    }

    private static boolean replace(StringBuffer buf, String pattern, int idx) {
        String search = buf.toString();
        int where = search.indexOf(pattern);
        if (where > 1) {
            buf.setLength(0);
            buf.append(search.substring(0, where + 1));
            buf.append(idx);
            buf.append(search.substring(where + pattern.length() - 1));
            return true;
        }
        return false;
    }
}

