/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UnlockedChainHead;
import com.elluminate.util.UtilTuning;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

final class UnlockedChainHead64
extends UnlockedChainHead {
    public static long POOL_SIZE = Integer.MAX_VALUE;
    public static long STAMP_DELTA = 0x100000000L;
    public static long INDEX_MASK = Integer.MAX_VALUE;
    public static long STAMP_MASK = 0x7FFFFFFF00000000L;
    private static AtomicLong sharedPoolHead;
    private static AtomicLong sharedStamp;
    private AtomicLong listHead;
    private AtomicLong poolHead;
    private AtomicLong stamp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnlockedChainHead64(int size) {
        if (size < 0) {
            size = UtilTuning.ObjectPoolSize.getIntValue();
            Object object = sharedPoolLock;
            synchronized (object) {
                if (sharedPoolHead == null) {
                    this.createPool(size);
                    sharedPool = this.pool;
                    sharedPoolHead = new AtomicLong(0L);
                    sharedStamp = new AtomicLong(0L);
                } else {
                    this.pool = sharedPool;
                    this.poolSize = size;
                }
                this.poolHead = sharedPoolHead;
                this.stamp = sharedStamp;
            }
        } else {
            this.createPool(size);
            this.poolHead = new AtomicLong(0L);
            this.stamp = new AtomicLong(0L);
        }
        this.listHead = new AtomicLong(-1L);
    }

    @Override
    public Iterator beginScavenge() {
        long was = this.listHead.get();
        while (!this.listHead.compareAndSet(was, -2L)) {
            was = this.listHead.get();
        }
        if (was == -2L) {
            throw new RuntimeException("beginScavenge while scavenging.");
        }
        this.iterator.reset((int)(was & INDEX_MASK));
        return this.iterator;
    }

    @Override
    public void endScavenge() {
        long newHead = this.iterator.getHead();
        long id = this.nextStamp();
        long next = id | newHead & INDEX_MASK;
        if (!this.listHead.compareAndSet(-2L, next)) {
            throw new RuntimeException("endScavenge when not scavenging.");
        }
    }

    @Override
    public int alloc(long id) {
        return this.doRemove(this.poolHead, id);
    }

    @Override
    public void free(int index, long id) {
        this.doInsert(this.poolHead, id, index);
    }

    @Override
    public void listInsert(int index, long id) {
        this.doInsert(this.listHead, id, index);
    }

    @Override
    public int listRemove(long id) {
        return this.doRemove(this.listHead, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRemove(AtomicLong head, long id) {
        int widx;
        while (true) {
            long was;
            if ((was = head.get()) == -2L) {
                UnlockedChainHead64 unlockedChainHead64 = this;
                synchronized (unlockedChainHead64) {
                }
            }
            widx = (int)(was & INDEX_MASK);
            if (widx < 0 || widx >= this.poolSize) {
                return -1;
            }
            long next = id | (long)this.pool[widx].next & INDEX_MASK;
            if (head.compareAndSet(was, next)) break;
        }
        return widx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInsert(AtomicLong head, long id, int idx) {
        while (true) {
            int widx;
            long was;
            if ((was = head.get()) == -2L) {
                UnlockedChainHead64 unlockedChainHead64 = this;
                synchronized (unlockedChainHead64) {
                }
            }
            this.pool[idx].next = widx = (int)(was & INDEX_MASK);
            long next = id | (long)idx;
            if (head.compareAndSet(was, next)) break;
        }
        return true;
    }

    @Override
    protected long nextStamp() {
        long prev = this.stamp.get();
        long next = prev + STAMP_DELTA & STAMP_MASK;
        while (!this.stamp.compareAndSet(prev, next)) {
            prev = this.stamp.get();
            next = prev + STAMP_DELTA & STAMP_MASK;
        }
        return next;
    }

    public static int getMaxSize() {
        return (int)POOL_SIZE;
    }
}

