/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UnlockedChainHead;
import com.elluminate.util.UtilTuning;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

final class UnlockedChainHead32
extends UnlockedChainHead {
    public static int POOL_SIZE = 131071;
    public static int STAMP_DELTA = 131072;
    public static int INDEX_MASK = 131071;
    public static int STAMP_MASK = 2147352576;
    private static AtomicInteger sharedPoolHead;
    private static AtomicInteger sharedStamp;
    private AtomicInteger listHead;
    private AtomicInteger poolHead;
    private AtomicInteger stamp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnlockedChainHead32(int size) {
        if (size < 0) {
            size = UtilTuning.ObjectPoolSize.getIntValue();
            Object object = sharedPoolLock;
            synchronized (object) {
                if (sharedPoolHead == null) {
                    this.createPool(size);
                    sharedPool = this.pool;
                    sharedPoolHead = new AtomicInteger(0);
                    sharedStamp = new AtomicInteger(0);
                } else {
                    this.pool = sharedPool;
                    this.poolSize = size;
                }
                this.poolHead = sharedPoolHead;
                this.stamp = sharedStamp;
            }
        } else {
            this.createPool(size);
            this.poolHead = new AtomicInteger(0);
            this.stamp = new AtomicInteger(0);
        }
        this.listHead = new AtomicInteger(-1);
    }

    @Override
    public Iterator beginScavenge() {
        int was = this.listHead.get();
        while (!this.listHead.compareAndSet(was, -2)) {
            was = this.listHead.get();
        }
        if (was == -2) {
            throw new RuntimeException("beginScavenge while scavenging.");
        }
        this.iterator.reset(was & INDEX_MASK);
        return this.iterator;
    }

    @Override
    public void endScavenge() {
        int newHead = this.iterator.getHead();
        int id = (int)this.nextStamp();
        int next = id | newHead & INDEX_MASK;
        if (!this.listHead.compareAndSet(-2, next)) {
            throw new RuntimeException("endScavenge when not scavenging.");
        }
    }

    @Override
    public int alloc(long id) {
        return this.doRemove(this.poolHead, (int)id);
    }

    @Override
    public void free(int index, long id) {
        this.doInsert(this.poolHead, (int)id, index);
    }

    @Override
    public void listInsert(int index, long id) {
        this.doInsert(this.listHead, (int)id, index);
    }

    @Override
    public int listRemove(long id) {
        return this.doRemove(this.listHead, (int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRemove(AtomicInteger head, int id) {
        int widx;
        while (true) {
            int was;
            if ((was = head.get()) == -2) {
                UnlockedChainHead32 unlockedChainHead32 = this;
                synchronized (unlockedChainHead32) {
                }
            }
            widx = was & INDEX_MASK;
            if (widx < 0 || widx >= this.poolSize) {
                return -1;
            }
            int next = id | this.pool[widx].next & INDEX_MASK;
            if (head.compareAndSet(was, next)) break;
        }
        return widx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInsert(AtomicInteger head, int id, int idx) {
        while (true) {
            int widx;
            int was;
            if ((was = head.get()) == -2) {
                UnlockedChainHead32 unlockedChainHead32 = this;
                synchronized (unlockedChainHead32) {
                }
            }
            this.pool[idx].next = widx = was & INDEX_MASK;
            int next = id | idx;
            if (head.compareAndSet(was, next)) break;
        }
        return true;
    }

    @Override
    protected long nextStamp() {
        int prev = this.stamp.get();
        int next = prev + STAMP_DELTA & STAMP_MASK;
        while (!this.stamp.compareAndSet(prev, next)) {
            prev = this.stamp.get();
            next = prev + STAMP_DELTA & STAMP_MASK;
        }
        return next;
    }

    public static int getMaxSize() {
        return POOL_SIZE;
    }
}

