/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ChainHead;
import com.elluminate.util.Chained;
import com.elluminate.util.UnlockedChainHead32;
import com.elluminate.util.UnlockedChainHead64;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.UtilTuning;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;

public abstract class UnlockedChainHead
extends ChainHead {
    public static final int SCAVENGE_INDEX = -2;
    public static final int NULL_INDEX = -1;
    protected static final Object sharedPoolLock = new Object();
    protected static Indirect[] sharedPool = null;
    protected int poolSize;
    protected Indirect[] pool = null;
    protected ScavengeIterator iterator = new ScavengeIterator();

    public static UnlockedChainHead getInstance(int size) {
        int n = size;
        if (size < 0) {
            n = UtilTuning.ObjectPoolSize.getIntValue();
        }
        if (n <= UnlockedChainHead32.getMaxSize()) {
            return new UnlockedChainHead32(size);
        }
        return new UnlockedChainHead64(size);
    }

    protected abstract void free(int var1, long var2);

    protected abstract int alloc(long var1);

    protected abstract void listInsert(int var1, long var2);

    protected abstract int listRemove(long var1);

    protected abstract long nextStamp();

    protected void createPool(int size) {
        this.poolSize = size;
        this.pool = new Indirect[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            this.pool[i] = new Indirect(i + 1);
        }
        this.pool[this.poolSize - 1].next = -1;
    }

    @Override
    public abstract Iterator beginScavenge();

    @Override
    public abstract void endScavenge();

    @Override
    public final void insert(Chained c) {
        long id = this.nextStamp();
        int box = this.alloc(id);
        if (box < 0) {
            if (UtilDebug.OBJECT_POOL.show()) {
                LogSupport.message(this, "insert", "Dropped " + c.getClass().getName());
            }
            return;
        }
        this.pool[box].ref = c;
        this.listInsert(box, id);
    }

    @Override
    public final Chained remove() {
        long id = this.nextStamp();
        int box = this.listRemove(id);
        if (box < 0) {
            return null;
        }
        Chained c = this.pool[box].ref;
        this.pool[box].ref = null;
        this.free(box, id);
        return c;
    }

    protected static class Indirect {
        volatile Chained ref = null;
        volatile int next;

        public Indirect(int nxt) {
            this.next = nxt;
        }
    }

    protected final class ScavengeIterator
    implements Iterator {
        private int head = -1;
        private int curr = -1;
        private int prev = -1;
        private int next = -1;

        ScavengeIterator() {
        }

        void reset(int head) {
            if (head >= UnlockedChainHead.this.pool.length) {
                head = -1;
            }
            this.head = head;
            this.curr = -1;
            this.prev = -1;
            this.next = head;
        }

        int getHead() {
            return this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        public Object next() {
            this.prev = this.curr;
            this.curr = this.next;
            if (this.curr >= 0) {
                this.next = UnlockedChainHead.this.pool[this.curr].next;
                if (this.next >= UnlockedChainHead.this.poolSize) {
                    this.next = -1;
                }
            } else {
                this.next = -1;
            }
            if (this.curr >= 0 && this.curr < UnlockedChainHead.this.poolSize) {
                return UnlockedChainHead.this.pool[this.curr].ref;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.prev < 0) {
                this.head = this.next;
            } else {
                UnlockedChainHead.this.pool[this.prev].next = this.next;
            }
            UnlockedChainHead.this.pool[this.curr].ref = null;
            UnlockedChainHead.this.free(this.curr, UnlockedChainHead.this.nextStamp());
            this.curr = this.prev;
        }
    }
}

