/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.lang.reflect.Array;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final Comparator LOCAL_COMPARATOR = new LocalComparator();
    public static final Comparator LOCAL_INSENSITIVE_COMPARATOR = new LocalInsensitiveComparator();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getStringValue(Object o) {
        if (o != null && o.getClass().isArray()) {
            StringBuffer result = new StringBuffer(4096);
            int n = Array.getLength(o);
            result.append(o.getClass().getName() + "#" + n);
            result.append('[');
            for (int idx = 0; idx < n; ++idx) {
                if (idx > 0) {
                    result.append(',');
                }
                result.append(StringUtils.getStringValue(Array.get(o, idx)));
            }
            result.append(']');
            return result.toString();
        }
        return String.valueOf(o);
    }

    public static boolean containsIgnoreCase(String s, String pattern) {
        return s.toLowerCase().toUpperCase().indexOf(pattern.toLowerCase().toUpperCase()) >= 0;
    }

    public static String dumpBytes(byte[] data, int offset, int length, long base) {
        StringBuffer result = new StringBuffer(Math.min(length * 2 + (length + 31) / 32 * 19, 256));
        if (offset < 0) {
            offset = 0;
        }
        if (offset + length > data.length) {
            length = data.length - offset;
        }
        for (int ix = offset; ix < offset + length; ix += 32) {
            if (ix > 0) {
                result.append('\n');
            }
            result.append(StringUtils.padLeft(Long.toHexString(base + (long)ix), 8, '0'));
            for (int bx = 0; bx < 32 && ix + bx < offset + length; ++bx) {
                int val;
                if (bx % 4 == 0) {
                    result.append(' ');
                }
                if (bx % 16 == 0) {
                    result.append(' ');
                }
                if ((val = data[ix + bx] & 0xFF) < 16) {
                    result.append('0');
                }
                result.append(Integer.toHexString(val));
            }
        }
        return result.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            hex[i * 2] = HEX_CHARS[bytes[i] >> 4 & 0xF];
            hex[i * 2 + 1] = HEX_CHARS[bytes[i] & 0xF];
        }
        return new String(hex);
    }

    public static byte[] bytesFromHex(String str) {
        byte[] result = new byte[str.length() / 2];
        int a = 0;
        int i = 0;
        while (i + 1 < str.length()) {
            a = 0;
            switch (str.charAt(i)) {
                default: {
                    break;
                }
                case '1': {
                    a = 1;
                    break;
                }
                case '2': {
                    a = 2;
                    break;
                }
                case '3': {
                    a = 3;
                    break;
                }
                case '4': {
                    a = 4;
                    break;
                }
                case '5': {
                    a = 5;
                    break;
                }
                case '6': {
                    a = 6;
                    break;
                }
                case '7': {
                    a = 7;
                    break;
                }
                case '8': {
                    a = 8;
                    break;
                }
                case '9': {
                    a = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    a = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    a = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    a = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    a = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    a = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    a = 15;
                }
            }
            a = (byte)(a << 4);
            switch (str.charAt(i + 1)) {
                default: {
                    break;
                }
                case '1': {
                    a = (byte)(a + 1);
                    break;
                }
                case '2': {
                    a = (byte)(a + 2);
                    break;
                }
                case '3': {
                    a = (byte)(a + 3);
                    break;
                }
                case '4': {
                    a = (byte)(a + 4);
                    break;
                }
                case '5': {
                    a = (byte)(a + 5);
                    break;
                }
                case '6': {
                    a = (byte)(a + 6);
                    break;
                }
                case '7': {
                    a = (byte)(a + 7);
                    break;
                }
                case '8': {
                    a = (byte)(a + 8);
                    break;
                }
                case '9': {
                    a = (byte)(a + 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    a = (byte)(a + 10);
                    break;
                }
                case 'B': 
                case 'b': {
                    a = (byte)(a + 11);
                    break;
                }
                case 'C': 
                case 'c': {
                    a = (byte)(a + 12);
                    break;
                }
                case 'D': 
                case 'd': {
                    a = (byte)(a + 13);
                    break;
                }
                case 'E': 
                case 'e': {
                    a = (byte)(a + 14);
                    break;
                }
                case 'F': 
                case 'f': {
                    a = (byte)(a + 15);
                }
            }
            result[i / 2] = a;
            i += 2;
        }
        return result;
    }

    public static String padLeft(String s, int w, char c) {
        if (s.length() >= w) {
            return s;
        }
        StringBuffer result = new StringBuffer(Math.max(s.length(), w));
        while (result.length() + s.length() < w) {
            result.append(c);
        }
        result.append(s);
        return result.toString();
    }

    public static String escape(String s, String toEscape, char escapeChar) {
        String pattern;
        if (s == null) {
            return null;
        }
        if (s.length() < 1) {
            return s;
        }
        if (toEscape == null) {
            toEscape = "";
        }
        if ((pattern = toEscape).indexOf(escapeChar) < 0) {
            pattern = toEscape + escapeChar;
        }
        StringBuffer result = new StringBuffer(s.length() * 2);
        int pos = 0;
        while (pos < s.length()) {
            int idx = StringUtils.search(s, pos, pattern);
            if (idx < 0) {
                result.append(s.substring(pos));
                break;
            }
            if (idx > pos) {
                result.append(s.substring(pos, idx));
            }
            result.append(escapeChar);
            result.append(s.charAt(idx));
            pos = idx + 1;
        }
        return result.toString();
    }

    public static String escape(String s, String toEscape) {
        return StringUtils.escape(s, toEscape, '\\');
    }

    public static String unescape(String s, char escapeChar) {
        if (s == null) {
            return null;
        }
        if (s.length() < 1) {
            return s;
        }
        int pos = 0;
        StringBuffer result = new StringBuffer(s.length());
        while (pos < s.length()) {
            int idx = s.indexOf(escapeChar, pos);
            if (idx < 0) {
                result.append(s.substring(pos));
                break;
            }
            if (idx > pos) {
                result.append(s.substring(pos, idx));
            }
            if (idx + 1 < s.length()) {
                result.append(s.charAt(idx + 1));
            }
            pos = idx + 2;
        }
        return result.toString();
    }

    public static String unescape(String s) {
        return StringUtils.unescape(s, '\\');
    }

    public static int indexOfEscaped(String s, String pattern, int fromIndex, char escapeChar) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int pos = fromIndex;
        while (pos < s.length()) {
            int idx = s.indexOf(pattern, pos);
            if (idx < 0) {
                return -1;
            }
            if (idx == fromIndex) {
                return fromIndex;
            }
            if (s.charAt(idx - 1) != escapeChar) {
                return idx;
            }
            pos = idx + 1;
        }
        return -1;
    }

    public static int indexOfEscaped(String s, String pattern, char escapeChar) {
        return StringUtils.indexOfEscaped(s, pattern, 0, escapeChar);
    }

    public static int indexOfEscaped(String s, String pattern, int fromIndex) {
        return StringUtils.indexOfEscaped(s, pattern, fromIndex, '\\');
    }

    public static int indexOfEscaped(String s, String pattern) {
        return StringUtils.indexOfEscaped(s, pattern, 0, '\\');
    }

    public static String rtrim(String s, String trim) {
        if (s == null) {
            return null;
        }
        for (int ix = s.length() - 1; ix >= 0; --ix) {
            char c = s.charAt(ix);
            if (trim.indexOf(c) >= 0) continue;
            return s.substring(0, ix + 1);
        }
        return "";
    }

    public static String rtrim(String s) {
        return StringUtils.rtrim(s, " \t");
    }

    public static String ltrim(String s, String trim) {
        if (s == null) {
            return null;
        }
        for (int ix = 0; ix < s.length(); ++ix) {
            char c = s.charAt(ix);
            if (trim.indexOf(c) >= 0) continue;
            return s.substring(ix);
        }
        return "";
    }

    public static String ltrim(String s) {
        return StringUtils.ltrim(s, " \t");
    }

    public static String before(String s, String pattern) {
        int pos = s.indexOf(pattern);
        if (pos >= 0) {
            return s.substring(0, pos);
        }
        return "";
    }

    public static String beforeLast(String s, String pattern) {
        int pos = s.lastIndexOf(pattern);
        if (pos >= 0) {
            return s.substring(0, pos);
        }
        return "";
    }

    public static String after(String s, String pattern) {
        int pos = s.indexOf(pattern);
        if (pos >= 0) {
            return s.substring(pos + 1);
        }
        return s;
    }

    public static String afterLast(String s, String pattern) {
        int pos = s.lastIndexOf(pattern);
        if (pos >= 0) {
            return s.substring(pos + 1);
        }
        return s;
    }

    public static int search(String s, String set) {
        return StringUtils.search(s, 0, set);
    }

    public static int search(String s, int startPos, String set) {
        if (s == null) {
            return -1;
        }
        if (set == null) {
            return -1;
        }
        for (int idx = startPos; idx < s.length(); ++idx) {
            char c = s.charAt(idx);
            if (set.indexOf(c) < 0) continue;
            return idx;
        }
        return -1;
    }

    public static int verify(String s, String set) {
        return StringUtils.verify(s, 0, set);
    }

    public static int verify(String s, int startPos, String set) {
        if (startPos < 0) {
            throw new IllegalArgumentException("Invalid start position: " + startPos);
        }
        if (s == null) {
            return -1;
        }
        if (set == null) {
            return 0;
        }
        for (int idx = startPos; idx < s.length(); ++idx) {
            char c = s.charAt(idx);
            if (set.indexOf(c) >= 0) continue;
            return idx;
        }
        return -1;
    }

    public static String formatTimeStamp(long time) {
        return StringUtils.formatTimeStamp(time, true);
    }

    public static String formatTimeStamp(long time, boolean showMillis) {
        if (time < 0L) {
            return Long.toString(time);
        }
        StringBuffer result = new StringBuffer(12);
        int msec = (int)(time % 1000L);
        int sec = (int)(time / 1000L % 60L);
        int min = (int)(time / 60000L % 60L);
        int hrs = (int)(time / 3600000L);
        if (!showMillis) {
            if ((msec > 500 || msec == 500 && sec % 2 == 1) && ++sec == 60) {
                sec = 0;
                ++min;
            }
            msec = 0;
        }
        if (hrs > 0) {
            result.append(hrs);
            result.append(":");
            if (min < 10) {
                result.append("0");
            }
        }
        result.append(min);
        result.append(":");
        if (sec < 10) {
            result.append("0");
        }
        result.append(sec);
        if (showMillis) {
            result.append(".");
            if (msec < 100) {
                result.append("0");
            }
            if (msec < 10) {
                result.append("0");
            }
            result.append(msec);
        }
        return result.toString();
    }

    public static long parseTimeStamp(String s) {
        boolean hasDecimal = false;
        boolean wasDelimiter = true;
        int decimalPlaces = 0;
        StringTokenizer parser = new StringTokenizer(s.trim(), ":.", true);
        Stack<Integer> stack = new Stack<Integer>();
        stack.ensureCapacity(parser.countTokens());
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            if (token.equals(".")) {
                if (hasDecimal) {
                    throw new RuntimeException("Invalid timestamp format -- multiple decimals: " + s);
                }
                hasDecimal = true;
                wasDelimiter = true;
                continue;
            }
            if (token.equals(":")) {
                if (hasDecimal) {
                    throw new RuntimeException("Invalid timestamp format -- separator following decimal: " + s);
                }
                if (wasDelimiter) {
                    throw new RuntimeException("Invalid timestamp format -- repeated delimiters without intervening value: " + s);
                }
                wasDelimiter = true;
                continue;
            }
            wasDelimiter = false;
            if (hasDecimal) {
                decimalPlaces = token.length();
            }
            try {
                stack.push(new Integer(Integer.parseInt(token)));
            }
            catch (NumberFormatException nfx) {
                throw new RuntimeException("Invalid timestamp format -- invalid numeric term: " + s, nfx);
            }
        }
        long result = 0L;
        if (hasDecimal) {
            result = ((Integer)stack.pop()).intValue();
            if (decimalPlaces < 0) {
                throw new RuntimeException("Invalid timestamp format -- invalid number of decimal places (" + decimalPlaces + "): " + s);
            }
            while (decimalPlaces < 3) {
                result *= 10L;
                ++decimalPlaces;
            }
            while (decimalPlaces > 4) {
                result /= 10L;
                --decimalPlaces;
            }
            if (decimalPlaces == 4) {
                result = (result + 5L) / 10L;
            }
        }
        int pos = 0;
        int multiplier = 1;
        while (!stack.empty()) {
            switch (pos) {
                case 0: {
                    multiplier *= 1000;
                    break;
                }
                case 1: {
                    multiplier *= 60;
                    break;
                }
                case 2: {
                    multiplier *= 60;
                    break;
                }
                case 3: {
                    multiplier *= 24;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid timestamp format -- too many terms: " + s);
                }
            }
            result += ((Integer)stack.pop()).longValue() * (long)multiplier;
        }
        return result;
    }

    public static String fromCamelCase(String s) {
        if (s == null || !(s instanceof String)) {
            return null;
        }
        if (s.indexOf(" ") != -1) {
            return s;
        }
        char[] chars = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i]) && i != 0) {
                buf.append(" ");
            }
            buf.append(chars[i]);
        }
        if (buf.length() > 0) {
            buf.replace(0, 1, String.valueOf(buf.charAt(0)).toUpperCase());
        }
        return buf.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null || !(s instanceof String)) {
            return null;
        }
        if (s.length() < 1) {
            return s;
        }
        String[] words = s.split(" ");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            String temp = words[i].toLowerCase();
            buf.append(temp.substring(0, 1).toUpperCase() + temp.substring(1));
        }
        return buf.toString();
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqual(String s1, String s2) {
        if (StringUtils.isEqualIgnoreCase(s1, s2)) {
            return s1.equals(s2);
        }
        return false;
    }

    public static String htmlEscape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    b.append("&lt;");
                    continue block7;
                }
                case '>': {
                    b.append("&gt;");
                    continue block7;
                }
                case '&': {
                    b.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    b.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    b.append("<br/>");
                    continue block7;
                }
                default: {
                    b.append(ch);
                }
            }
        }
        return b.toString();
    }

    public static void main(String[] args) {
        String s1 = "one, two, three";
        String s2 = "four, five, six";
        String s3 = StringUtils.escape(s1, ", ") + "," + StringUtils.escape(s2, ", ");
        System.err.println("escape: '" + s1 + "' + '" + s2 + "' => '" + s3 + "'");
        int pos = 0;
        while (pos < s3.length()) {
            int idx = StringUtils.indexOfEscaped(s3, ",", pos);
            System.err.println("indexOfEscaped from " + pos + ": " + idx + (idx >= 0 ? " " + s3.charAt(idx) : ""));
            if (idx < 0) {
                System.err.println("unescape: @" + pos + " '" + StringUtils.unescape(s3.substring(pos)) + "'");
                break;
            }
            String s = s3.substring(pos, idx);
            System.err.println("unescape: @" + pos + " '" + StringUtils.unescape(s) + "'");
            pos = idx + 1;
        }
    }

    private static class LocalComparator
    implements Comparator {
        private Collator collator;

        public LocalComparator() {
            this.collator = Collator.getInstance();
        }

        public LocalComparator(Locale lc) {
            this.collator = Collator.getInstance(lc);
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            String s1 = obj1.toString();
            String s2 = obj2.toString();
            return this.collator.compare(s1, s2);
        }
    }

    public static class LocalInsensitiveComparator
    implements Comparator {
        private Locale locale;
        private Collator collator;

        public LocalInsensitiveComparator() {
            this(Locale.getDefault());
        }

        public LocalInsensitiveComparator(Locale lc) {
            this.locale = lc;
            this.collator = Collator.getInstance(lc);
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            String s1 = obj1.toString().toLowerCase(this.locale).toUpperCase(this.locale);
            String s2 = obj2.toString().toLowerCase(this.locale).toUpperCase(this.locale);
            return this.collator.compare(s1, s2);
        }
    }
}

