/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.util.Comparator;

public class StringComparator
implements Comparator<String> {
    public static final int CASE_SENSITIVE = 0;
    public static final int CASE_INSENSITIVE_ORDER = 1;
    public static final int CASE_INSENSITIVE = 2;
    boolean allowNull = false;
    int caseHandling = 0;

    public StringComparator() {
    }

    public StringComparator(boolean nullOK) {
        this.allowNull = nullOK;
    }

    public StringComparator(boolean nullOK, int caseMode) {
        this.allowNull = nullOK;
        this.caseHandling = caseMode;
    }

    @Override
    public int compare(String s1, String s2) {
        if (this.allowNull) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
        }
        int result = 0;
        switch (this.caseHandling) {
            case 2: {
                result = this.cmpIgnoreCase(s1, s2);
                break;
            }
            case 1: {
                result = this.cmpIgnoreCase(s1, s2);
                if (result != 0) break;
                result = s1.compareTo(s2);
                break;
            }
            case 0: {
                result = s1.compareTo(s2);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StringComparator;
    }

    public int hashCode() {
        return 1234567;
    }

    private int cmpIgnoreCase(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int i1 = 0;
        for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
            char c2;
            char c1 = s1.charAt(i1);
            if (c1 == (c2 = s2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }
}

