/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.StringUtils;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.TreeMap;

public class StateMachine {
    private boolean tracing = false;
    private State curState = null;
    private TreeMap stateMap = new TreeMap();
    private TreeMap eventListenerMap = new TreeMap();
    private ArrayList globalStateListeners = new ArrayList();

    public StateMachine(Object[] stateKeys, Object[][] eventDefs, Object[][] transitions, Object initialState) {
        int ix;
        for (ix = 0; ix < stateKeys.length; ++ix) {
            if (this.stateMap.get(stateKeys[ix]) != null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "Duplicate state key, " + ix + ": " + stateKeys[ix]);
                }
                throw new IllegalArgumentException("Duplicate state key, " + ix + ": " + stateKeys[ix]);
            }
            this.stateMap.put(stateKeys[ix], this.createState(stateKeys[ix]));
        }
        for (ix = 0; ix < eventDefs.length; ++ix) {
            Object[] def = eventDefs[ix];
            if (def == null || def.length < 2) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "Malformed event definition, " + ix + ": " + StringUtils.getStringValue(def));
                }
                throw new IllegalArgumentException("Malformed event definition, " + ix + ": " + StringUtils.getStringValue(def));
            }
            State state = this.getState(def[0]);
            if (state == null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "Invalid state key '" + state + "' in event definition, " + ix + ": " + StringUtils.getStringValue(def));
                }
                throw new IllegalArgumentException("Invalid state key '" + state + "' in event definition, " + ix + ": " + StringUtils.getStringValue(def));
            }
            for (int evIdx = 1; evIdx < def.length; ++evIdx) {
                if (def[evIdx] == null) {
                    if (UtilDebug.STATE_MACHINE.show()) {
                        LogSupport.message(this, "<init>", "Null event key in event definition, " + ix + ": " + StringUtils.getStringValue(def));
                    }
                    throw new IllegalArgumentException("Null event key in event definition, " + ix + ": " + StringUtils.getStringValue(def));
                }
                if (state.getEvent(def[evIdx]) != null) {
                    if (UtilDebug.STATE_MACHINE.show()) {
                        LogSupport.message(this, "<init>", "Event '" + def[evIdx] + "' already defined for state, " + ix + ": " + StringUtils.getStringValue(def));
                    }
                    throw new IllegalArgumentException("Event '" + def[evIdx] + "' already defined for state, " + ix + ": " + StringUtils.getStringValue(def));
                }
                state.addEvent(def[evIdx]);
            }
        }
        for (ix = 0; ix < transitions.length; ++ix) {
            Object[] trans = transitions[ix];
            if (trans == null || trans.length != 3) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "Malformed transition, " + ix + ": " + StringUtils.getStringValue(trans));
                }
                throw new IllegalArgumentException("Malformed transition, " + ix + ": " + StringUtils.getStringValue(trans));
            }
            State origState = this.getState(trans[0]);
            if (origState == null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "No state '" + trans[0] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
                }
                throw new IllegalArgumentException("No state '" + trans[0] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
            }
            Event ev = origState.getEvent(trans[1]);
            if (ev == null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "No event '" + trans[1] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
                }
                throw new IllegalArgumentException("No event '" + trans[1] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
            }
            if (ev.getTransition() != null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "Event '" + ev.getKey() + " of state '" + origState.getKey() + "'" + "' already has transition, " + ix + ": " + StringUtils.getStringValue(trans));
                }
                throw new IllegalArgumentException("Event '" + ev.getKey() + " of state '" + origState.getKey() + "'" + "' already has transition, " + ix + ": " + StringUtils.getStringValue(trans));
            }
            if (trans[2] instanceof ConditionalTransition) {
                ev.setTransition(trans[2]);
                continue;
            }
            State destState = this.getState(trans[2]);
            if (destState == null) {
                if (UtilDebug.STATE_MACHINE.show()) {
                    LogSupport.message(this, "<init>", "No state '" + trans[2] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
                }
                throw new IllegalArgumentException("No state '" + trans[2] + "' in transition, " + ix + ": " + StringUtils.getStringValue(trans));
            }
            ev.setTransition(destState);
        }
        State state = this.getState(initialState);
        if (state == null) {
            if (UtilDebug.STATE_MACHINE.show()) {
                LogSupport.message(this, "<init>", "Invalid initial state: " + initialState);
            }
            throw new IllegalArgumentException("Invalid initial state: " + initialState);
        }
        this.setState(state);
    }

    public Object[] getStates() {
        return this.stateMap.keySet().toArray();
    }

    public boolean isValidState(Object key) {
        return this.getState(key) != null;
    }

    public synchronized Object getCurrentState() {
        if (this.curState == null) {
            return null;
        }
        return this.curState.getKey();
    }

    public synchronized void setCurrentState(Object stateKey, Object data) {
        State origState = this.curState;
        State destState = this.getState(stateKey);
        if (destState == null) {
            throw new IllegalArgumentException("Invalid destination state: " + stateKey);
        }
        if (destState == this.curState) {
            return;
        }
        this.setState(destState);
        origState.fireStateListeners(null, origState.getKey(), data);
        destState.fireStateListeners(null, origState.getKey(), data);
        this.fireGlobalStateListeners(null, origState.getKey(), data);
    }

    public synchronized boolean setCurrentStateConditional(Object inStateKey, Object toStateKey, Object data) {
        State origState = this.curState;
        State inState = this.getState(inStateKey);
        if (inState == null) {
            throw new IllegalArgumentException("Invalid conditional state: " + inStateKey);
        }
        State destState = this.getState(toStateKey);
        if (destState == null) {
            throw new IllegalArgumentException("Invalid destination state: " + toStateKey);
        }
        if (inState != origState) {
            return false;
        }
        if (destState == origState) {
            return false;
        }
        this.setState(destState);
        origState.fireStateListeners(null, inState.getKey(), data);
        destState.fireStateListeners(null, inState.getKey(), data);
        this.fireGlobalStateListeners(null, inState.getKey(), data);
        return true;
    }

    public synchronized Object applyEvent(Object eventKey, Object data) {
        State origState = this.curState;
        this.curState.applyEvent(eventKey, data);
        this.fireGlobalEventListeners(eventKey, origState.getKey(), data);
        return this.curState.getKey();
    }

    public synchronized Object applyEventIfInState(Object inStateKey, Object eventKey, Object data) {
        State origState = this.curState;
        State inState = this.getState(inStateKey);
        if (inState == null) {
            throw new IllegalArgumentException("Invalid conditional state: " + inStateKey);
        }
        if (inState != this.curState) {
            return this.curState.getKey();
        }
        this.curState.applyEvent(eventKey, data);
        this.fireGlobalEventListeners(eventKey, origState.getKey(), data);
        return this.curState.getKey();
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    public String toString() {
        State state = this.getState();
        StringBuffer states = new StringBuffer();
        Object[] stateList = this.getStates();
        for (int ix = 0; ix < stateList.length; ++ix) {
            if (ix > 0) {
                states.append(",");
            }
            states.append(stateList[ix]);
        }
        return super.toString() + " curState=" + (state == null ? null : state.getKey()) + " states=[" + states.toString() + "]";
    }

    public synchronized void addGlobalStateListener(StateMachineStateListener l) {
        if (this.globalStateListeners.contains(l)) {
            return;
        }
        this.globalStateListeners.add(l);
    }

    public synchronized void removeGlobalStateListener(StateMachineStateListener l) {
        this.globalStateListeners.remove(l);
    }

    protected void fireGlobalStateListeners(Object eventKey, Object origState, Object data) {
        StateMachineEvent ev = null;
        for (StateMachineStateListener l : this.globalStateListeners) {
            if (ev == null) {
                ev = new StateMachineEvent(this, eventKey, origState, this.curState.getKey(), data);
            }
            try {
                l.stateExited(ev);
                l.stateEntered(ev);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "fireListeners", t, true);
            }
        }
    }

    public synchronized void addStateListener(Object stateKey, StateMachineStateListener l) {
        State state = this.getState(stateKey);
        state.addStateListener(l);
    }

    public synchronized void removeStateListener(Object stateKey, StateMachineStateListener l) {
        State state = this.getState(stateKey);
        state.removeStateListener(l);
    }

    public synchronized void addEventListener(Object stateKey, Object eventKey, StateMachineEventListener l) {
        State state = this.getState(stateKey);
        state.addEventListener(eventKey, l);
    }

    public synchronized void removeEventListener(Object stateKey, Object eventKey, StateMachineEventListener l) {
        State state = this.getState(stateKey);
        state.removeEventListener(eventKey, l);
    }

    public synchronized void addGlobalEventListener(Object eventKey, StateMachineEventListener l) {
        ArrayList<StateMachineEventListener> listenerList = (ArrayList<StateMachineEventListener>)this.eventListenerMap.get(eventKey);
        if (listenerList == null) {
            listenerList = new ArrayList<StateMachineEventListener>();
            this.eventListenerMap.put(eventKey, listenerList);
        }
        if (listenerList.contains(l)) {
            return;
        }
        listenerList.add(l);
    }

    public synchronized void removeGlobalEventListener(Object eventKey, StateMachineEventListener l) {
        ArrayList listenerList = (ArrayList)this.eventListenerMap.get(eventKey);
        if (listenerList == null) {
            return;
        }
        listenerList.remove(l);
    }

    protected void fireGlobalEventListeners(Object eventKey, Object origState, Object data) {
        ArrayList listenerList = (ArrayList)this.eventListenerMap.get(eventKey);
        if (listenerList == null) {
            return;
        }
        StateMachineEvent ev = null;
        for (StateMachineEventListener l : listenerList) {
            if (ev == null) {
                ev = new StateMachineEvent(this, eventKey, origState, this.curState.getKey(), data);
            }
            try {
                l.eventFired(ev);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "fireListeners", t, true);
            }
        }
    }

    protected State getState() {
        return this.curState;
    }

    protected State getState(Object stateKey) {
        if (stateKey == null) {
            return null;
        }
        return (State)this.stateMap.get(stateKey);
    }

    protected void setState(State destState) {
        if (this.tracing || UtilDebug.STATE_CHANGE.show()) {
            LogSupport.message(this, "setState", super.toString() + " old=" + (this.curState == null ? null : this.curState.getKey()) + " new=" + (destState == null ? null : destState.getKey()));
        }
        this.curState = destState;
    }

    protected State createState(Object key) {
        return new State(key);
    }

    protected Event createEvent(State state, Object key) {
        return new Event(state, key);
    }

    public static interface ConditionalTransition {
        public Object checkTransition(StateMachine var1, Object var2, Object var3, Object var4);
    }

    protected class Event {
        private Object key;
        private State state;
        private Object transition = null;
        private ArrayList eventListeners = new ArrayList();

        protected Event(State state, Object key) {
            if (state == null) {
                throw new IllegalArgumentException("Null state for event " + key);
            }
            if (key == null) {
                throw new IllegalArgumentException("Null event key");
            }
            this.key = key;
            this.state = state;
        }

        public Object getKey() {
            return this.key;
        }

        public String toString() {
            return super.toString() + " key=" + this.key + " state=" + (this.state == null ? null : this.state.getKey()) + " transition=" + this.getTransitionText();
        }

        protected State getState() {
            return this.state;
        }

        protected void setTransition(Object transition) {
            this.transition = transition;
        }

        protected Object getTransition() {
            return this.transition;
        }

        protected String getTransitionText() {
            if (this.transition == null) {
                return null;
            }
            if (this.transition instanceof State) {
                return "" + ((State)this.transition).getKey();
            }
            return this.transition.toString();
        }

        protected State getTargetState(Object data) {
            if (this.transition == null) {
                return this.state;
            }
            if (this.transition instanceof State) {
                return (State)this.transition;
            }
            if (this.transition instanceof ConditionalTransition) {
                ConditionalTransition ct = (ConditionalTransition)this.transition;
                Object destKey = ct.checkTransition(StateMachine.this, this.state.getKey(), this.key, data);
                if (destKey == null) {
                    return this.state;
                }
                State dest = StateMachine.this.getState(destKey);
                if (dest == null) {
                    throw new RuntimeException("Invalid state transition: " + destKey);
                }
                return dest;
            }
            State dest = StateMachine.this.getState(this.transition);
            if (dest == null) {
                throw new RuntimeException("Invalid state transition: " + this.transition);
            }
            return dest;
        }

        protected void apply(Object data) {
            State destState = this.getTargetState(data);
            StateMachineEvent ev = new StateMachineEvent(StateMachine.this, this.key, this.state.getKey(), destState.getKey(), data);
            this.fireEventListeners(ev);
            destState = StateMachine.this.getState(ev.getTransitionState());
            if (destState != null && destState != StateMachine.this.curState) {
                StateMachine.this.setState(destState);
            }
        }

        protected void addEventListener(StateMachineEventListener l) {
            if (this.eventListeners.contains(l)) {
                return;
            }
            this.eventListeners.add(l);
        }

        protected void removeEventListener(StateMachineEventListener l) {
            this.eventListeners.remove(l);
        }

        protected void fireEventListeners(StateMachineEvent ev) {
            for (StateMachineEventListener l : this.eventListeners) {
                try {
                    l.eventFired(ev);
                }
                catch (Throwable t) {
                    ev.abortTransition();
                    LogSupport.exception(this, "fireListeners", t, true);
                }
            }
        }
    }

    protected class State {
        private Object key;
        private TreeMap eventMap = new TreeMap();
        private ArrayList stateListeners = new ArrayList();

        protected State(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("Null state key");
            }
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object[] getEvents() {
            return this.eventMap.keySet().toArray();
        }

        public String toString() {
            return super.toString() + " key=" + this.key + " events=" + StringUtils.getStringValue(this.getEvents());
        }

        protected Event getEvent(Object key) {
            return (Event)this.eventMap.get(key);
        }

        protected void addEvent(Object eventKey) {
            this.addEvent(eventKey, this.createEvent(eventKey));
        }

        protected void addEvent(Object eventKey, Event event) {
            this.eventMap.put(eventKey, event);
        }

        protected void addStateListener(StateMachineStateListener l) {
            if (this.stateListeners.contains(l)) {
                return;
            }
            this.stateListeners.add(l);
        }

        protected void removeStateListener(StateMachineStateListener l) {
            this.stateListeners.remove(l);
        }

        protected void fireStateListeners(Object eventKey, Object origState, Object data) {
            StateMachineEvent ev = null;
            for (StateMachineStateListener l : this.stateListeners) {
                if (ev == null) {
                    ev = new StateMachineEvent(StateMachine.this, eventKey, origState, StateMachine.this.curState.getKey(), data);
                }
                try {
                    l.stateExited(ev);
                    l.stateEntered(ev);
                }
                catch (Throwable t) {
                    LogSupport.exception(this, "fireListeners", t, true);
                }
            }
        }

        protected void addEventListener(Object eventKey, StateMachineEventListener l) {
            Event event = this.getEvent(eventKey);
            event.addEventListener(l);
        }

        protected void removeEventListener(Object eventKey, StateMachineEventListener l) {
            Event event = this.getEvent(eventKey);
            event.removeEventListener(l);
        }

        protected void applyEvent(Object eventKey, Object data) {
            State origState = StateMachine.this.curState;
            Event event = this.getEvent(eventKey);
            if (event != null) {
                event.apply(data);
            }
            if (StateMachine.this.curState != origState) {
                origState.fireStateListeners(eventKey, origState.getKey(), data);
                StateMachine.this.curState.fireStateListeners(eventKey, origState.getKey(), data);
                StateMachine.this.fireGlobalStateListeners(eventKey, origState.getKey(), data);
            }
        }

        protected Event createEvent(Object eventKey) {
            return StateMachine.this.createEvent(this, eventKey);
        }
    }

    public static class StateMachineEvent
    extends EventObject {
        private Object event;
        private Object origState;
        private Object destState;
        private Object data;
        private boolean stateChange;
        private Object postState = null;
        private boolean transitionAborted = false;

        public StateMachineEvent(StateMachine sMach, Object event, Object origState, Object destState, Object data) {
            super(sMach);
            this.event = event;
            this.origState = origState;
            this.destState = destState;
            this.data = data;
            this.stateChange = origState == destState ? false : (origState == null ? true : !origState.equals(destState));
        }

        public StateMachine getStateMachine() {
            return (StateMachine)this.getSource();
        }

        public Object getEvent() {
            return this.event;
        }

        public boolean isStateChanging() {
            return this.stateChange;
        }

        public Object getOriginalState() {
            return this.origState;
        }

        public Object getDestinationState() {
            return this.destState;
        }

        public Object getData() {
            return this.data;
        }

        public boolean isStateChangePending() {
            return this.stateChange || this.postState != null;
        }

        public void abortTransition() {
            this.transitionAborted = true;
        }

        public boolean isTransitionAborted() {
            return this.transitionAborted;
        }

        public void requestStateChange(Object stateKey) {
            if (stateKey == null || !this.getStateMachine().isValidState(stateKey)) {
                throw new IllegalArgumentException("Invalid state: " + stateKey);
            }
            if (stateKey.equals(this.getTransitionState())) {
                return;
            }
            if (this.isStateChangePending()) {
                throw new IllegalStateException("State change already pending to " + this.getTransitionState());
            }
            this.postState = stateKey;
        }

        public Object getTransitionState() {
            if (this.transitionAborted) {
                return null;
            }
            if (this.postState != null) {
                return this.postState;
            }
            return this.destState;
        }
    }

    public static interface StateMachineEventListener
    extends EventListener {
        public void eventFired(StateMachineEvent var1);
    }

    public static interface StateMachineStateListener
    extends EventListener {
        public void stateEntered(StateMachineEvent var1);

        public void stateExited(StateMachineEvent var1);
    }
}

