/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import java.lang.reflect.InvocationTargetException;

public class SerializerThread {
    private static int serialCounter = 0;
    private MTPriorityQueue queue = null;
    private long maxIdleTime = -1L;
    private long lastAction = System.currentTimeMillis();
    private final Runnable idleAction = new Runnable(){

        @Override
        public void run() {
            if (SerializerThread.this.maxIdleTime < 0L) {
                return;
            }
            if (SerializerThread.this.queue == null) {
                return;
            }
            if (UtilDebug.SERIALIZER_THREAD.show()) {
                LogSupport.message(this, "run", "Idle for " + SerializerThread.this.getIdleTime());
            }
            if (SerializerThread.this.queue.getIdleTime() < SerializerThread.this.maxIdleTime / 2L) {
                return;
            }
            if (!SerializerThread.this.queue.stopIfIdle()) {
                SerializerThread.this.idleTimer.scheduleIn(SerializerThread.this.maxIdleTime);
            } else if (UtilDebug.SERIALIZER_THREAD.show()) {
                LogSupport.message(this, "run", "Stopped queue: " + SerializerThread.this);
            }
        }
    };
    private final LightweightTimer idleTimer = new LightweightTimer(this.idleAction);
    private static SerializerThread instance = null;

    public SerializerThread() {
        this("SerializerThread: " + ++serialCounter);
    }

    public SerializerThread(String name) {
        this(name, null);
    }

    public SerializerThread(String name, ThreadGroup grp) {
        this.queue = new MTPriorityQueue(name, new Processor());
        this.queue.setRestartable(true);
        if (grp != null) {
            this.queue.setThreadGroup(grp);
        }
    }

    public boolean isProcessingThread() {
        return this.queue.isProcessingThread();
    }

    public void setDaemon(boolean on) {
        this.queue.setDaemon(on);
    }

    public boolean isDaemon() {
        return this.queue.isDaemon();
    }

    public void setIdleTime(int maxIdleSeconds) {
        this.maxIdleTime = (long)maxIdleSeconds * 1000L;
    }

    public int getIdleTime() {
        return (int)(this.maxIdleTime / 1000L);
    }

    public String toString() {
        return super.toString() + " maxIdleTime=" + this.maxIdleTime + "ms queue: " + this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SerializerThread serializerThread = this;
        synchronized (serializerThread) {
            this.queue.setEnabled(false);
            this.queue.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runner) throws InvocationTargetException {
        QueuedItem item;
        if (this.queue.isProcessingThread()) {
            runner.run();
            return;
        }
        QueuedItem queuedItem = item = new QueuedItem(runner, true);
        synchronized (queuedItem) {
            SerializerThread serializerThread = this;
            synchronized (serializerThread) {
                if (!this.queue.isEnabled()) {
                    throw new IllegalThreadStateException("Processing thread is disabled");
                }
                if (!this.queue.process(item)) {
                    throw new RuntimeException("Failed to queue action");
                }
                this.lastAction = System.currentTimeMillis();
                if (this.maxIdleTime > 0L) {
                    this.idleTimer.scheduleIn(this.maxIdleTime);
                }
            }
            while (!item.isCompleted()) {
                try {
                    item.wait(440L);
                }
                catch (InterruptedException iex) {}
            }
        }
        Throwable t = item.getException();
        if (t != null) {
            throw new InvocationTargetException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runner) {
        QueuedItem item = new QueuedItem(runner, false);
        SerializerThread serializerThread = this;
        synchronized (serializerThread) {
            if (!this.queue.isEnabled()) {
                throw new IllegalThreadStateException("Processing thread is disabled");
            }
            this.queue.process(item);
            this.lastAction = System.currentTimeMillis();
            if (this.maxIdleTime > 0L) {
                this.idleTimer.scheduleIn(this.maxIdleTime);
            }
        }
    }

    public static boolean threadIsProcessingThread() {
        SerializerThread cur = instance;
        if (cur == null) {
            return false;
        }
        return cur.isProcessingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void threadInvokeLater(Runnable runner) {
        if (instance == null) {
            Class<SerializerThread> clazz = SerializerThread.class;
            // MONITORENTER : com.elluminate.util.SerializerThread.class
            if (instance == null) {
                instance = new SerializerThread("Default Serializer Thread");
                instance.setDaemon(true);
            }
            // MONITOREXIT : clazz
        }
        instance.invokeLater(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCommon(ThreadGroup grp) {
        Class<SerializerThread> clazz = SerializerThread.class;
        synchronized (SerializerThread.class) {
            if (instance == null) {
                instance = new SerializerThread("Default Serializer Thread", grp);
                instance.setDaemon(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) {
        int val;
        int ix;
        UtilDebug.SERIALIZER_THREAD.setEnabled(true);
        SerializerThread.threadInvokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        LogSupport.message("Testing sync:");
        for (ix = 0; ix < 10; ++ix) {
            val = ix + 1;
            try {
                instance.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ix) {
                            // empty catch block
                        }
                        LogSupport.message("Running sync: " + val);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                continue;
            }
            catch (InvocationTargetException ite) {
                LogSupport.message(Debug.getStackTrace(ite));
                continue;
            }
            catch (Throwable t) {
                LogSupport.message(Debug.getStackTrace(t));
            }
        }
        LogSupport.message("Done sync.");
        LogSupport.message("\nTesting async:");
        for (ix = 0; ix < 10; ++ix) {
            val = ix + 1;
            SerializerThread.threadInvokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                    LogSupport.message("Running async: " + val);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
        LogSupport.message("Done async.");
        try {
            instance.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LogSupport.message("Queue drained.");
                }
            });
        }
        catch (Throwable t) {
            // empty catch block
        }
        LogSupport.message("\nTesting stop:");
        final SerializerThread st = new SerializerThread();
        Thread stopper = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LogSupport.message("Stopping...");
                st.stop();
            }
        };
        stopper.start();
        for (int ix2 = 0; ix2 < 5; ++ix2) {
            final int val2 = ix2 + 1;
            try {
                LogSupport.message("Queuing stop: " + val2);
                st.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ix) {
                            // empty catch block
                        }
                        LogSupport.message("Running stop: " + val2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                for (int jx = 0; jx < 5; ++jx) {
                    final int val22 = jx + 1;
                    st.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ix) {
                                // empty catch block
                            }
                            LogSupport.message("Running stop: " + val2 + " => " + val22);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                }
                continue;
            }
            catch (InvocationTargetException ite) {
                LogSupport.message(Debug.getStackTrace(ite));
                continue;
            }
            catch (Throwable t) {
                LogSupport.message(Debug.getStackTrace(t));
                break;
            }
        }
        LogSupport.message("Done stop.");
        LogSupport.message("\nTesting idle timeout:");
        SerializerThread idleTest = new SerializerThread();
        idleTest.setIdleTime(10);
        idleTest.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogSupport.message("Running: idle test initial item.");
            }
        });
        try {
            Thread.sleep(21000L);
        }
        catch (InterruptedException intx) {
            // empty catch block
        }
        idleTest.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogSupport.message("Running: idle test restart item.");
            }
        });
        LogSupport.message("Done idle timeout.");
    }

    private static class DiscardedException
    extends RuntimeException {
        DiscardedException(String msg) {
            super(msg);
        }
    }

    private static class Processor
    extends QueuedProcessorAdapter {
        private Processor() {
        }

        @Override
        public void process(Object data, Object context) {
            if (!(data instanceof QueuedItem)) {
                return;
            }
            ((QueuedItem)data).run();
        }

        @Override
        public void discard(Object data) {
            if (!(data instanceof QueuedItem)) {
                return;
            }
            ((QueuedItem)data).discard();
        }
    }

    private static class QueuedItem
    implements Runnable {
        Runnable runner;
        boolean wait;
        volatile Throwable exc;
        volatile boolean done;

        QueuedItem(Runnable r) {
            this(r, false);
        }

        QueuedItem(Runnable r, boolean wait) {
            this.runner = r;
            this.wait = wait;
            this.exc = null;
            this.done = false;
        }

        public boolean isCompleted() {
            return this.done;
        }

        public Throwable getException() {
            return this.exc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runner.run();
            }
            catch (Throwable t) {
                if (this.wait) {
                    this.exc = t;
                } else {
                    LogSupport.exception(this, "run", t, true, "Executing: " + this.runner);
                }
            }
            finally {
                this.done = true;
                if (this.wait) {
                    QueuedItem queuedItem = this;
                    synchronized (queuedItem) {
                        this.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discard() {
            if (this.wait) {
                this.exc = new DiscardedException("Action discarded from queue");
            }
            this.done = true;
            if (this.wait) {
                QueuedItem queuedItem = this;
                synchronized (queuedItem) {
                    this.notify();
                }
            }
        }
    }
}

