/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;

public class Resource {
    private Object context;
    private String relPath;

    public Resource(String relPath) {
        this.context = null;
        this.relPath = relPath;
    }

    public Resource(Object context, String relPath) {
        this.context = context;
        this.relPath = relPath;
    }

    public String getPath() {
        return this.relPath;
    }

    public boolean exists() {
        URL url = this.find();
        InputStream str = null;
        if (url == null) {
            return false;
        }
        try {
            str = url.openStream();
            str.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (NullPointerException ne) {
            return false;
        }
    }

    public URL find() {
        ClassLoader cl;
        URL url = null;
        if (this.context != null) {
            url = this.context instanceof Class ? ((Class)this.context).getResource(this.relPath) : this.context.getClass().getResource(this.relPath);
        }
        if (url == null && (cl = this.getClass().getClassLoader()) != null) {
            url = cl.getResource(this.relPath);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(this.relPath);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] load() throws IOException {
        URL resourceURL = this.find();
        if (resourceURL != null) {
            InputStream resourceStm = null;
            ByteArrayOutputStream dataStm = new ByteArrayOutputStream(32768);
            byte[] resource = null;
            try {
                resourceStm = resourceURL.openStream();
                this.copy(resourceStm, dataStm);
                resource = dataStm.toByteArray();
            }
            finally {
                if (resourceStm != null) {
                    try {
                        resourceStm.close();
                    }
                    catch (Throwable t) {}
                }
                if (dataStm != null) {
                    try {
                        dataStm.close();
                    }
                    catch (Throwable t) {}
                }
            }
            if (UtilDebug.RESOURCE.show()) {
                LogSupport.message(this, "load", "Read " + resource.length + " bytes from " + this.relPath);
            }
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws IOException {
        String result = null;
        URL resourceURL = this.find();
        if (resourceURL != null) {
            StringBuffer resbuf = new StringBuffer(this.length());
            InputStreamReader reader = new InputStreamReader(resourceURL.openStream());
            try {
                int ch;
                while ((ch = reader.read()) >= 0) {
                    resbuf.append((char)ch);
                }
            }
            finally {
                reader.close();
            }
            result = resbuf.toString();
            if (UtilDebug.RESOURCE.show()) {
                LogSupport.message(this, "readString", "Read " + result.length() + " characters from " + this.relPath);
            }
        }
        return result;
    }

    public int length() {
        byte[] resource = null;
        try {
            resource = this.load();
        }
        catch (Throwable t) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        return resource.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath) throws IOException {
        URL resourceURL = this.find();
        if (resourceURL == null) {
            return;
        }
        File targetFile = new File(filePath);
        FileOutputStream targetStm = null;
        InputStream resourceStm = null;
        try {
            resourceStm = resourceURL.openStream();
            targetStm = new FileOutputStream(targetFile);
            int nBytes = this.copy(resourceStm, targetStm);
            if (UtilDebug.RESOURCE.show()) {
                LogSupport.message(this, "save", "Saved " + nBytes + " bytes from " + this.relPath + " to file " + filePath);
            }
        }
        finally {
            if (resourceStm != null) {
                try {
                    resourceStm.close();
                }
                catch (Throwable t) {}
            }
            if (targetStm != null) {
                try {
                    targetStm.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static ResourceBundle getResourceFor(String pkg, String bndle, Class cls) {
        ResourceBundle rsrc = null;
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            rsrc = ResourceBundle.getBundle(pkg + "." + bndle, Locale.getDefault(), loader);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return rsrc;
    }

    private int copy(InputStream is, OutputStream os) throws IOException {
        int result = 0;
        int retryCount = 0;
        int nRead = 0;
        byte[] buffer = new byte[4096];
        while (nRead >= 0) {
            try {
                nRead = is.read(buffer);
            }
            catch (EOFException eofx) {
                nRead = -1;
            }
            if (nRead > 0) {
                retryCount = 0;
                os.write(buffer, 0, nRead);
                result += nRead;
                continue;
            }
            if (nRead != 0) continue;
            if (retryCount > 12) {
                throw new IOException("Transfer stalled.");
            }
            if (retryCount > 3) {
                try {
                    Thread.sleep(25 * retryCount);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
            }
            ++retryCount;
        }
        os.flush();
        return result;
    }
}

