/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.WorkQueue;

public class CircularWorkQueue
extends WorkQueue {
    public static final short EX_URGENT = 1;
    public static final short EX_QUEUE_SPAWN = 2;
    public static final short EX_QUEUE_BLOCK = 3;
    public static final short EX_QUEUE_RETURN = 4;
    private Runnable[] pending;
    private int nPending;
    private int pendingHead = 0;
    private int pendingTail = 0;

    public CircularWorkQueue(int size) {
        this.pending = new Runnable[size];
        this.nPending = 0;
    }

    @Override
    public int size() {
        return this.nPending;
    }

    public boolean execute(Runnable r) {
        return this.execute(r, (short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Runnable r, short flags) {
        Object object = this.lock;
        synchronized (object) {
            if (this.startNow(r, flags == 1)) {
                ++this.nQueued;
                ++this.nProcessed;
                return true;
            }
            if (this.queueWork(r)) {
                ++this.nQueued;
                return true;
            }
            if (flags == 3) {
                do {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ix) {
                        return false;
                    }
                } while (!this.queueWork(r));
                ++this.nQueued;
                return true;
            }
            if (flags == 2) {
                ++this.nQueued;
                Runnable r2 = this.getWork();
                this.queueWork(r);
                return this.startNow(r2, true);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable getWork() {
        Object object = this.lock;
        synchronized (object) {
            Runnable r = null;
            if (this.nPending == 0) {
                return null;
            }
            r = this.pending[this.pendingHead];
            this.pending[this.pendingHead] = null;
            ++this.pendingHead;
            if (this.pendingHead == this.pending.length) {
                this.pendingHead = 0;
            }
            --this.nPending;
            this.lock.notify();
            ++this.nProcessed;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueWork(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nPending == this.pending.length) {
                return false;
            }
            this.pending[this.pendingTail++] = r;
            if (this.pendingTail == this.pending.length) {
                this.pendingTail = 0;
            }
            ++this.nPending;
            return true;
        }
    }
}

