/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CPropertyChangeSupport {
    private Object lock = new Object();
    private Object src = null;
    private ArrayList listeners = new ArrayList();
    private HashMap filteredListeners = new HashMap();

    public CPropertyChangeSupport(Object source) {
        this.src = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener lst) {
        if (lst == null) {
            return;
        }
        Debug.lockEnter(this, "addPropertyChangeListener", "lock", this.lock);
        Object object = this.lock;
        synchronized (object) {
            ArrayList<PropertyChangeListener> newList = new ArrayList<PropertyChangeListener>(this.listeners);
            newList.add(lst);
            this.listeners = newList;
        }
        Debug.lockLeave(this, "addPropertyChangeListener", "lock", this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        if (lst == null) {
            return;
        }
        Debug.lockEnter(this, "addPropertyChangeListener", "lock", this.lock);
        Object object = this.lock;
        synchronized (object) {
            ArrayList origList = (ArrayList)this.filteredListeners.get(prop);
            if (origList == null) {
                origList = new ArrayList();
            }
            ArrayList<PropertyChangeListener> newList = new ArrayList<PropertyChangeListener>(origList);
            newList.add(lst);
            this.filteredListeners.put(prop, newList);
        }
        Debug.lockLeave(this, "addPropertyChangeListener", "lock", this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener lst) {
        if (lst == null) {
            return;
        }
        Debug.lockEnter(this, "removePropertyChangeListener", "lock", this.lock);
        Object object = this.lock;
        synchronized (object) {
            ArrayList newList = new ArrayList(this.listeners);
            newList.remove(lst);
            this.listeners = newList;
        }
        Debug.lockLeave(this, "removePropertyChangeListener", "lock", this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        if (lst == null) {
            return;
        }
        Debug.lockEnter(this, "removePropertyChangeListener", "lock", this.lock);
        Object object = this.lock;
        synchronized (object) {
            ArrayList origList = (ArrayList)this.filteredListeners.get(prop);
            if (origList != null) {
                ArrayList newList = new ArrayList(origList);
                newList.remove(lst);
                this.filteredListeners.put(prop, newList);
            }
        }
        Debug.lockLeave(this, "removePropertyChangeListener", "lock", this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(PropertyChangeEvent ev) {
        PropertyChangeListener lst;
        Iterator filtered;
        Iterator global = this.listeners.iterator();
        Debug.lockEnter(this, "fireEvent", "lock", this.lock);
        Object object = this.lock;
        synchronized (object) {
            ArrayList l = (ArrayList)this.filteredListeners.get(ev.getPropertyName());
            filtered = l == null ? null : l.iterator();
        }
        Debug.lockLeave(this, "fireEvent", "lock", this.lock);
        while (global.hasNext()) {
            try {
                lst = (PropertyChangeListener)global.next();
                lst.propertyChange(ev);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "fireEvent", t, true);
            }
        }
        while (filtered != null && filtered.hasNext()) {
            try {
                lst = (PropertyChangeListener)filtered.next();
                lst.propertyChange(ev);
            }
            catch (Throwable t) {
                LogSupport.exception(this, "fireEvent", t, true);
            }
        }
    }

    public void firePropertyChange(String name, long from, long to) {
        if (from == to) {
            return;
        }
        this.fireEvent(new PropertyChangeEvent(this.src, name, new Long(from), new Long(to)));
    }

    public void firePropertyChange(String name, int from, int to) {
        if (from == to) {
            return;
        }
        this.fireEvent(new PropertyChangeEvent(this.src, name, new Integer(from), new Integer(to)));
    }

    public void firePropertyChange(String name, boolean from, boolean to) {
        if (from == to) {
            return;
        }
        this.fireEvent(new PropertyChangeEvent(this.src, name, from ? Boolean.TRUE : Boolean.FALSE, to ? Boolean.TRUE : Boolean.FALSE));
    }

    public void firePropertyChange(String name, Object from, Object to) {
        if (from != null && to != null && from.equals(to)) {
            return;
        }
        this.fireEvent(new PropertyChangeEvent(this.src, name, from, to));
    }

    public void firePropertyChange(PropertyChangeEvent ev) {
        Object from = ev.getOldValue();
        Object to = ev.getNewValue();
        if (from != null && to != null && from.equals(to)) {
            return;
        }
        this.fireEvent(ev);
    }
}

