/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.platform;

import com.elluminate.platform.AppLookupAPI;
import com.elluminate.platform.GenericPlatform;
import com.elluminate.platform.Platform;
import com.elluminate.platform.PlatformDebug;
import com.elluminate.util.Debug;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.StringUtils;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class MacOSXPlatform
extends GenericPlatform {
    private static final String APP_BUNDLE_EXTENSION = ".app";
    private static final String APP_DIRECTORY_NAME = "Applications";
    private static final String ILLEGAL_FILENAME_CHARACTERS = "/";
    private static CarbonLock theLock = null;
    private final long cpuFrequency;
    private AppLookupAPI launchServices;
    private Method findByCreatorMethod;
    private Method findByBundleMethod;
    private Method getBundleIDMethod;
    private Method getNativePathMethod;
    private File tempDirCache;
    private File prefDirCache;
    private Object mrjHelper;
    private Method getFileTypeMethod;
    private Integer tmpFolderType;
    private Integer prefFolderType;
    private Method findFolder;
    private static final String[] macTypes = new String[]{"BMPf", "BMP ", "BMPp", "GIFf", "GIF ", "ICO ", "JPEG", "JFIF", "PCXx", "PICT", "PNGf", "PNG ", "8BPS", "TPIC", "TIFF", "jp2 ", "SLD8"};
    private static final String[] mimeTypes = new String[]{"image/bmp", "image/bmp", "image/bmp", "image/gif", "image/gif", "image/ico", "image/jpeg", "image/jpeg", "image/pcx", "image/pict", "image/png", "image/png", "image/psd", "image/targa", "image/tiff", "image/jpeg2000", "application/x-ms-powerpoint"};

    private static Method findMethod(Class cls, String name, Class[] paramList) {
        try {
            return cls.getMethod(name, paramList);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public MacOSXPlatform() {
        block7: {
            block6: {
                this.launchServices = null;
                this.findByCreatorMethod = null;
                this.findByBundleMethod = null;
                this.getBundleIDMethod = null;
                this.getNativePathMethod = null;
                this.tempDirCache = null;
                this.prefDirCache = null;
                this.mrjHelper = null;
                this.getFileTypeMethod = null;
                this.tmpFolderType = null;
                this.prefFolderType = null;
                this.findFolder = null;
                this.platform = 2;
                this.opSystem = 202;
                try {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    this.getFileTypeMethod = fileMgr.getDeclaredMethod("getFileType", String.class);
                    this.findFolder = fileMgr.getDeclaredMethod("findFolder", Integer.TYPE);
                    this.tmpFolderType = new Integer(MacOSXPlatform.convertFileType("temp"));
                    this.prefFolderType = new Integer(MacOSXPlatform.convertFileType("pref"));
                }
                catch (Throwable t) {
                    if (!PlatformDebug.GENERAL.show()) break block6;
                    LogSupport.message(this, "<init>", Debug.getStackTrace(t));
                }
            }
            try {
                Class<?> lsc = Class.forName("com.elluminate.platform.macos.LaunchServicesJNI");
                this.launchServices = (AppLookupAPI)lsc.newInstance();
                this.findByCreatorMethod = lsc.getMethod("findAppByCreator", Integer.TYPE);
                this.findByBundleMethod = lsc.getMethod("findAppByBundle", String.class);
                this.getBundleIDMethod = lsc.getMethod("getBundleID", File.class);
                this.getNativePathMethod = lsc.getMethod("getNativePath", File.class);
            }
            catch (Throwable t) {
                if (!PlatformDebug.GENERAL.show()) break block7;
                LogSupport.message(this, "<init>", Debug.getStackTrace(t));
            }
        }
        WorkerThread initializer = new WorkerThread("Platform Details Harvester"){

            @Override
            public void run() {
                block5: {
                    String[] cmd = new String[]{"system_profiler", "SPHardwareDataType", "-detailLevel", "mini"};
                    try {
                        StringBuffer result = new StringBuffer(256);
                        StringBuffer error = PlatformDebug.GENERAL.show() ? new StringBuffer() : null;
                        int status = ProcessUtils.exec(cmd, result, error, -1L, false);
                        if (PlatformDebug.GENERAL.show() && status != 0) {
                            LogSupport.message(this, "run", "Error invoking " + cmd[0] + ": " + status + (error != null ? " " + error.toString() : ""));
                        }
                        if (result.length() > 0) {
                            MacOSXPlatform.this.details = result.toString();
                            if (PlatformDebug.GENERAL.show()) {
                                LogSupport.message(this, "run", MacOSXPlatform.this.details);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!PlatformDebug.GENERAL.show()) break block5;
                        LogSupport.message(this, "run", "Exception invoking " + cmd[0] + ": " + Debug.getStackTrace(t));
                    }
                }
            }
        };
        initializer.setDaemon(true);
        initializer.start();
        long freq = -1L;
        StringBuffer cpuInfo = new StringBuffer();
        try {
            String[] cpuCommand = new String[]{"sysctl", "-n", "hw.cpufrequency"};
            int cpuStatus = ProcessUtils.exec(cpuCommand, cpuInfo, null, 2000L, true);
            freq = cpuStatus != 0 ? -1L : Long.parseLong(StringUtils.rtrim(cpuInfo.toString(), " \t\n\r"));
        }
        catch (Throwable t) {
            freq = -1L;
        }
        this.cpuFrequency = freq;
    }

    @Override
    public String getJavaInfo() {
        String mrjVers = System.getProperty("mrj.version");
        if (mrjVers != null) {
            return super.getJavaInfo() + " MRJ " + mrjVers;
        }
        return super.getJavaInfo();
    }

    @Override
    public void applicationInit() {
        block4: {
            if (this.application != null) {
                try {
                    Class<?> appUtils = Class.forName("com.elluminate.platform.macos.MacAppUtils");
                    Method setAbout = appUtils.getDeclaredMethod("setAboutHandler", Object.class, Method.class);
                    Method setPreferences = appUtils.getDeclaredMethod("setPreferencesHandler", Object.class, Method.class);
                    Method setQuit = appUtils.getDeclaredMethod("setQuitHandler", Object.class, Method.class);
                    Method myAbout = this.getClass().getMethod("handleAbout", new Class[0]);
                    Method myPreferences = this.getClass().getMethod("handlePreferences", new Class[0]);
                    Method myQuit = this.getClass().getMethod("handleQuit", new Class[0]);
                    this.mrjHelper = appUtils.newInstance();
                    setAbout.invoke(this.mrjHelper, this, myAbout);
                    setPreferences.invoke(this.mrjHelper, this, myPreferences);
                    setQuit.invoke(this.mrjHelper, this, myQuit);
                    if (PlatformDebug.GENERAL.show()) {
                        LogSupport.message(this, "applicationInit", "Registered About, Preferences and Quit handlers in " + this.mrjHelper);
                    }
                }
                catch (Exception ex) {
                    if (!PlatformDebug.GENERAL.show()) break block4;
                    LogSupport.exception(this, "applicationInit", ex, true);
                }
            }
        }
    }

    @Override
    public String getMimeType(File f) {
        if (f.isDirectory()) {
            throw new RuntimeException("Attempted to use directory " + f + " as a file.");
        }
        if (f.exists()) {
            String fType = this.getFileType(f);
            for (int ix = 0; ix < macTypes.length; ++ix) {
                if (!macTypes[ix].equals(fType)) continue;
                return mimeTypes[ix];
            }
        }
        return super.getMimeType(f);
    }

    @Override
    public String getMimeType(String name) {
        File f = new File(name);
        if (f.exists() && !f.isDirectory()) {
            return this.getMimeType(f);
        }
        return super.getMimeType(name);
    }

    @Override
    public File getTempDir() {
        if (this.tempDirCache != null) {
            return this.tempDirCache;
        }
        File f = null;
        try {
            f = this.findMacFolder(this.tmpFolderType);
            if (f != null) {
                if (f.isDirectory()) {
                    this.tempDirCache = f;
                    return this.tempDirCache;
                }
                if (f.mkdirs()) {
                    this.tempDirCache = f;
                    return this.tempDirCache;
                }
            }
        }
        catch (Throwable t) {
            LogSupport.message(this, "getTempDir", Debug.getStackTrace(t));
        }
        String prop = System.getProperty("java.io.tmpdir");
        if (prop != null) {
            f = new File(prop);
            if (f.isDirectory()) {
                this.tempDirCache = f;
                return this.tempDirCache;
            }
            if (f.mkdirs()) {
                this.tempDirCache = f;
                return this.tempDirCache;
            }
        }
        if ((prop = System.getProperty("user.home")) != null) {
            f = new File(prop, ".tmpdir");
            if (f.isDirectory()) {
                this.tempDirCache = f;
                return this.tempDirCache;
            }
            if (f.mkdirs()) {
                this.tempDirCache = f;
                return this.tempDirCache;
            }
        }
        f = new File("/tmp");
        f.mkdirs();
        this.tempDirCache = f;
        return this.tempDirCache;
    }

    @Override
    public File getPreferencesDir() {
        if (this.prefDirCache != null) {
            return this.prefDirCache;
        }
        File f = null;
        try {
            f = this.findMacFolder(this.prefFolderType);
            if (f != null) {
                if (f.isDirectory()) {
                    this.prefDirCache = f;
                    return this.prefDirCache;
                }
                if (f.mkdirs()) {
                    this.prefDirCache = f;
                    return this.prefDirCache;
                }
            }
        }
        catch (Throwable t) {
            LogSupport.message(this, "getPreferencesDir", Debug.getStackTrace(t));
        }
        String userhome = System.getProperty("user.home");
        if (userhome != null) {
            f = new File(userhome, "Library/Preferences");
            if (!f.exists()) {
                f.mkdirs();
            }
            if (f.exists() && f.isDirectory()) {
                this.prefDirCache = f;
                return this.prefDirCache;
            }
            f = new File(userhome);
            if (f.exists()) {
                this.prefDirCache = f;
                return this.prefDirCache;
            }
        }
        return null;
    }

    @Override
    public String getNativePath(File path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot make native path from null File object.");
        }
        Object result = null;
        try {
            result = this.getNativePathMethod.invoke((Object)this.launchServices, path);
        }
        catch (Exception ex) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(this, "getNativePath", Debug.getStackTrace(ex));
            }
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        if (PlatformDebug.GENERAL.show()) {
            LogSupport.message(this, "getNativePath", this.launchServices.getClass().getName() + "." + this.getNativePathMethod + " returned instance of " + result.getClass().getName() + ": " + result);
        }
        return null;
    }

    @Override
    public String getNativePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot make native path from null String object.");
        }
        return this.getNativePath(new File(path));
    }

    @Override
    public String filterFilename(String filename) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (ILLEGAL_FILENAME_CHARACTERS.indexOf(ch) != -1) continue;
            b.append(ch);
        }
        return b.toString();
    }

    @Override
    public File findAppByMIME(String mimeType) {
        return this.launchServices.findAppByMIME(mimeType);
    }

    @Override
    public File findAppByExtension(String extension) {
        if (this.launchServices == null) {
            return null;
        }
        return this.launchServices.findAppByExtension(extension);
    }

    public String getBundleID(File bundlePath) {
        Object result;
        block5: {
            if (this.getBundleIDMethod == null) {
                return null;
            }
            result = null;
            try {
                result = this.getBundleIDMethod.invoke((Object)this.launchServices, bundlePath);
            }
            catch (Exception ex) {
                result = null;
                if (!PlatformDebug.GENERAL.show()) break block5;
                LogSupport.message(this, "getBundleID", Debug.getStackTrace(ex));
            }
        }
        if (result instanceof String) {
            return (String)result;
        }
        if (PlatformDebug.GENERAL.show() && result != null) {
            LogSupport.message(this, "getBundleID", this.launchServices.getClass().getName() + "." + this.getBundleIDMethod + " returned instance of " + result.getClass().getName() + ": " + result);
        }
        return null;
    }

    public static File findAppByBundle(String bundle) {
        MacOSXPlatform p = (MacOSXPlatform)Platform.getInstance();
        return p.findAppByBundle0(bundle);
    }

    public static File findAppByCreator(String creator) {
        try {
            MacOSXPlatform p = (MacOSXPlatform)Platform.getInstance();
            return p.findAppByCreator0(MacOSXPlatform.convertFileType(creator));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private File findAppByBundle0(String bundle) {
        Object result;
        block5: {
            if (this.findByBundleMethod == null) {
                return null;
            }
            result = null;
            try {
                result = this.findByBundleMethod.invoke((Object)this.launchServices, bundle);
            }
            catch (Exception ex) {
                result = null;
                if (!PlatformDebug.GENERAL.show()) break block5;
                LogSupport.message(this, "findAppByBundle", Debug.getStackTrace(ex));
            }
        }
        if (result instanceof File) {
            return (File)result;
        }
        if (PlatformDebug.GENERAL.show() && result != null) {
            LogSupport.message(this, "findAppByBundle", this.launchServices.getClass().getName() + "." + this.findByCreatorMethod + " returned instance of " + result.getClass().getName() + ": " + result);
        }
        return null;
    }

    private File findAppByCreator0(int creator) {
        Object result;
        block5: {
            if (this.findByCreatorMethod == null) {
                return null;
            }
            result = null;
            try {
                result = this.findByCreatorMethod.invoke((Object)this.launchServices, creator);
            }
            catch (Exception ex) {
                result = null;
                if (!PlatformDebug.GENERAL.show()) break block5;
                LogSupport.message(this, "findAppByCreator", Debug.getStackTrace(ex));
            }
        }
        if (result instanceof File) {
            return (File)result;
        }
        if (PlatformDebug.GENERAL.show() && result != null) {
            LogSupport.message(this, "findAppByCreator", this.launchServices.getClass().getName() + "." + this.findByCreatorMethod + " returned instance of " + result.getClass().getName() + ": " + result);
        }
        return null;
    }

    @Override
    public File findAppByReference(String appRef) {
        File app = new File(appRef);
        if (app.exists()) {
            return app;
        }
        if (!appRef.endsWith(APP_BUNDLE_EXTENSION) && (app = new File(appRef + APP_BUNDLE_EXTENSION)).exists()) {
            return app;
        }
        if (appRef.indexOf(File.separator) == -1) {
            String paths;
            File home;
            File appDir = new File(File.separator + APP_DIRECTORY_NAME);
            app = new File(appDir, appRef);
            if (app.exists()) {
                return app;
            }
            if (!appRef.endsWith(APP_BUNDLE_EXTENSION) && (app = new File(appDir, appRef + APP_BUNDLE_EXTENSION)).exists()) {
                return app;
            }
            File[] subdirs = appDir.listFiles();
            if (subdirs != null) {
                for (int i = 0; i < subdirs.length; ++i) {
                    File subdir = subdirs[i];
                    if (!subdir.isDirectory()) continue;
                    app = new File(subdir, appRef);
                    if (app.exists() && app.isFile()) {
                        return app;
                    }
                    if (appRef.endsWith(APP_BUNDLE_EXTENSION) || !(app = new File(subdir, appRef + APP_BUNDLE_EXTENSION)).exists()) continue;
                    return app;
                }
            }
            if ((appDir = new File(home = new File(System.getProperty("user.home")), APP_DIRECTORY_NAME)).exists()) {
                app = new File(appDir, appRef);
                if (app.exists()) {
                    return app;
                }
                if (!appRef.endsWith(APP_BUNDLE_EXTENSION) && (app = new File(appDir, appRef + APP_BUNDLE_EXTENSION)).exists()) {
                    return app;
                }
            }
            if ((subdirs = appDir.listFiles()) != null) {
                for (int i = 0; i < subdirs.length; ++i) {
                    File subdir = subdirs[i];
                    if (!subdir.isDirectory()) continue;
                    app = new File(subdir, appRef);
                    if (app.exists() && app.isFile()) {
                        return app;
                    }
                    if (appRef.endsWith(APP_BUNDLE_EXTENSION) || !(app = new File(subdir, appRef + APP_BUNDLE_EXTENSION)).exists()) continue;
                    return app;
                }
            }
            if ((paths = this.getEnvironmentVariable("PATH")) != null) {
                StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File dir = new File(st.nextToken());
                    if (!dir.exists() || !dir.isDirectory() || !(app = new File(dir, appRef)).exists() || !app.isFile()) continue;
                    return app;
                }
            }
        }
        return null;
    }

    @Override
    public boolean launchApp(File app) {
        return this.launchApp(app, null);
    }

    @Override
    public boolean launchApp(File app, File document) {
        String[] cmd = new String[3];
        if (document != null) {
            cmd = new String[4];
        }
        cmd[0] = "open";
        cmd[1] = "-a";
        cmd[2] = app.getAbsolutePath();
        if (document != null) {
            cmd[3] = document.getAbsolutePath();
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean openFile(File file) {
        String[] cmd = new String[]{"open", file.getAbsolutePath()};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            ProcessUtils.ignoreProcessOutput(p);
            return ProcessUtils.isProcessRunning(p);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long getCPUFrequency(int index) {
        return this.cpuFrequency;
    }

    public void handleAbout() {
        if (PlatformDebug.GENERAL.show()) {
            LogSupport.message(this, "handleAbout", "processing About request.");
        }
        if (this.application != null) {
            this.application.doAbout();
        }
    }

    public void handlePreferences() {
        if (PlatformDebug.GENERAL.show()) {
            LogSupport.message(this, "handlePreferences", "processing Preferences request.");
        }
        if (this.application != null) {
            this.application.doPreferences();
        }
    }

    public void handleQuit() {
        if (PlatformDebug.GENERAL.show()) {
            LogSupport.message(this, "handleQuit", "processing Quit request.");
        }
        if (this.application != null) {
            this.application.doQuit();
        }
    }

    public static int convertFileType(String typeText) {
        if (typeText == null) {
            return 0;
        }
        if (typeText.length() > 4) {
            throw new IllegalArgumentException("Invalid string for Mac file type: '" + typeText + "'");
        }
        if (typeText.equals("????")) {
            return 0;
        }
        byte[] data = null;
        try {
            data = typeText.getBytes("MacRoman");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (data == null) {
            return 0;
        }
        int result = 0;
        for (int ix = 0; ix < 4; ++ix) {
            byte val = 0;
            if (ix < data.length) {
                val = data[ix];
            }
            result = result << 8 | val & 0xFF;
        }
        return result;
    }

    public static String convertFileType(int typeInt) {
        String result;
        if (typeInt == 0) {
            return "????";
        }
        byte[] data = new byte[4];
        int strLen = 0;
        for (int ix = 3; ix >= 0; --ix) {
            data[ix] = (byte)(typeInt & 0xFF);
            typeInt >>= 8;
            if (strLen == 0 && data[ix] == 0) continue;
            ++strLen;
        }
        try {
            result = new String(data, 0, strLen, "MacRoman");
        }
        catch (Throwable t) {
            result = "????";
        }
        return result;
    }

    private File findMacFolder(Integer folderID) {
        File f = null;
        try {
            f = new File(this.findFolder.invoke(null, folderID).toString());
        }
        catch (Throwable t) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.message(this, "findMacFolder", "Caught exception: " + Debug.getStackTrace(t));
            }
            Throwable src = null;
            src = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
            String fInfo = folderID.getClass().getName() + " ";
            fInfo = fInfo + Integer.toHexString(folderID);
            throw new RuntimeException("Error locating Mac folder (" + fInfo + ")", src);
        }
        return f;
    }

    protected String getFileType(File f) {
        String fType = null;
        try {
            int t = ((Number)this.getFileTypeMethod.invoke(null, f.toString())).intValue();
            fType = MacOSXPlatform.convertFileType(t);
        }
        catch (InvocationTargetException ex) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.exception(this, "getMimeType", ex, true);
                if (ex.getTargetException() instanceof Exception) {
                    LogSupport.exception(this, "getMimeType", (Exception)ex.getTargetException(), true);
                }
            }
            throw new RuntimeException("Error getting file type of " + f + ":\n" + ex.getTargetException());
        }
        catch (Throwable ex) {
            if (PlatformDebug.GENERAL.show()) {
                LogSupport.exception(this, "getMimeType", ex, true);
            }
            throw new RuntimeException("Error getting file type of " + f + ":\n" + ex);
        }
        return fType;
    }

    private String getEnvironmentVariable(String variableName) {
        try {
            return System.getenv(variableName);
        }
        catch (Throwable t) {
            LogSupport.message(this, "getEnvironmentVariable", Debug.getStackTrace(t));
            return null;
        }
    }

    public static CarbonLock getCarbonLock() {
        try {
            MacOSXPlatform macPlat = (MacOSXPlatform)Platform.getInstance();
            if (macPlat != null) {
                return macPlat.getCarbonLockInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarbonLock getCarbonLockInstance() {
        if (theLock != null) {
            return theLock;
        }
        Debug.lockEnter(this, "getCarbonLockInstance", null, this);
        try {
            MacOSXPlatform macOSXPlatform = this;
            synchronized (macOSXPlatform) {
                if (theLock == null) {
                    theLock = new OSXCarbonLock();
                }
            }
        }
        finally {
            Debug.lockLeave(this, "getCarbonLockInstance", null, this);
        }
        return theLock;
    }

    public static abstract class CarbonLock {
        public abstract void runCarbon(Runnable var1);

        public boolean runCarbonBool(RunnableResult operation) {
            this.runCarbon(operation);
            return operation.boolResult();
        }

        public int runCarbonInt(RunnableResult operation) {
            this.runCarbon(operation);
            return operation.intResult();
        }

        public double runCarbonDbl(RunnableResult operation) {
            this.runCarbon(operation);
            return operation.dblResult();
        }

        public String runCarbonStr(RunnableResult operation) {
            this.runCarbon(operation);
            return operation.strResult();
        }

        public Object runCarbonObj(RunnableResult operation) {
            this.runCarbon(operation);
            return operation.objResult();
        }
    }

    public static final class OSXCarbonLock
    extends CarbonLock {
        private static final Object semaphore = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runCarbon(Runnable operation) {
            Object object = semaphore;
            synchronized (object) {
                operation.run();
            }
        }

        public String toString() {
            return "OSXCarbonLock " + this.hashCode() + ",semaphore=" + semaphore;
        }
    }

    public static abstract class RunnableResult
    implements Runnable {
        @Override
        public abstract void run();

        public boolean boolResult() {
            return false;
        }

        public int intResult() {
            return 0;
        }

        public double dblResult() {
            return 0.0;
        }

        public String strResult() {
            return "";
        }

        public Object objResult() {
            return null;
        }
    }
}

