/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.nio;

import com.elluminate.net.AbstractAsyncEndpoint;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequestImpl;
import com.elluminate.net.RequestQueue;
import com.elluminate.net.nio.AsyncIOManager;
import com.elluminate.net.nio.AsyncIOState;
import com.elluminate.net.nio.PooledByteBuffer;
import com.elluminate.util.log.LogSupport;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class SelectorAsyncEndpoint
extends AbstractAsyncEndpoint {
    private SocketChannel chnl;
    private Runnable connectProc;
    private Runnable readProc;
    private Runnable writeProc;
    private Runnable timeoutProc;
    private AsyncIORequestImpl connectReq = null;
    private RequestQueue readQueue = new RequestQueue();
    private RequestQueue writeQueue = new RequestQueue();
    private String connectionID = "[" + System.identityHashCode(this) + "]";
    private AtomicInteger readGuard = new AtomicInteger(0);
    private AtomicInteger writeGuard = new AtomicInteger(0);
    private AsyncIOState ioState;

    public SelectorAsyncEndpoint() throws IOException {
        if (!AsyncIOManager.isAvailable()) {
            throw new IOException("No AsyncIO Manager available.");
        }
        this.connectProc = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncIORequestImpl req;
                1 var2_1 = this;
                synchronized (var2_1) {
                    req = SelectorAsyncEndpoint.this.connectReq;
                    SelectorAsyncEndpoint.this.connectReq = null;
                }
                req.execute();
            }
        };
        this.readProc = new Runnable(){

            @Override
            public void run() {
                SelectorAsyncEndpoint.this.processQueue(SelectorAsyncEndpoint.this.readQueue, 1, SelectorAsyncEndpoint.this.readGuard);
            }
        };
        this.writeProc = new Runnable(){

            @Override
            public void run() {
                SelectorAsyncEndpoint.this.processQueue(SelectorAsyncEndpoint.this.writeQueue, 4, SelectorAsyncEndpoint.this.writeGuard);
            }
        };
        this.timeoutProc = new Runnable(){

            @Override
            public void run() {
                AsyncIORequestImpl req = (AsyncIORequestImpl)SelectorAsyncEndpoint.this.readQueue.getHead();
                req.fail(new SocketTimeoutException("Read timed out"));
                if (SelectorAsyncEndpoint.this.readQueue.remove()) {
                    SelectorAsyncEndpoint.this.ioState.addOp(1);
                }
            }
        };
    }

    protected SelectorAsyncEndpoint(SocketChannel c) throws IOException {
        this();
        this.chnl = c;
        this.chnl.configureBlocking(false);
        this.state.set(3);
        this.ioState = new SelectorIOState(this.chnl);
    }

    private void processQueue(RequestQueue queue, int mask, AtomicInteger guard) {
        if (!guard.compareAndSet(0, 1)) {
            return;
        }
        boolean running = true;
        boolean pending = false;
        long timeout = 0L;
        while (running) {
            AsyncIORequestImpl req = (AsyncIORequestImpl)queue.getHead();
            if (req != null) {
                running = req.execute();
                if (!running) {
                    pending = true;
                    timeout = req.getTimeout();
                    continue;
                }
                running = queue.remove();
                req.dispose();
                timeout = 0L;
                continue;
            }
            LogSupport.error(this, "processQueue", this.getID() + ": Notify " + mask + " ready with no request queued!");
            timeout = 0L;
            running = false;
        }
        if (!guard.compareAndSet(1, 0)) {
            LogSupport.error(this, "processQueue", "reset guard for " + mask + " when not set!");
        }
        this.ioState.setTimeout(timeout);
        if (pending) {
            this.ioState.addOp(mask);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.chnl == null) {
            return null;
        }
        return this.chnl.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        if (this.chnl == null) {
            return 0;
        }
        return this.chnl.socket().getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.chnl == null) {
            return null;
        }
        return this.chnl.socket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        if (this.chnl == null) {
            return 0;
        }
        return this.chnl.socket().getLocalPort();
    }

    @Override
    public int getLinger() throws SocketException {
        if (this.chnl == null) {
            return 0;
        }
        return this.chnl.socket().getSoLinger();
    }

    @Override
    public void setLinger(int linger) throws SocketException {
        if (this.chnl == null) {
            return;
        }
        this.chnl.socket().setSoLinger(linger > 0, linger);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.chnl == null) {
            return false;
        }
        return this.chnl.socket().getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.chnl == null) {
            return;
        }
        this.chnl.socket().setTcpNoDelay(on);
    }

    @Override
    public void beginConnect(InetAddress addr, int port, AsyncIOListener lst) {
        this.setCalled(addr, port);
        InetSocketAddress sa = new InetSocketAddress(addr, port);
        AsyncIORequestImpl req = this.connectReq = AsyncIORequestImpl.getConnectReq((AsyncEndpoint)this, addr, port, this.handler, lst);
        if (!this.state.compareAndSet(0, 1)) {
            this.connectReq.fail(new IOException("beginConnect when AsyncEndpoint is not disconnected."));
            this.connectReq = null;
            req.dispose();
            return;
        }
        try {
            this.chnl = SocketChannel.open();
            this.chnl.configureBlocking(false);
            this.ioState = new SelectorIOState(this.chnl);
        }
        catch (IOException iox) {
            this.state.set(0);
            this.chnl = null;
            this.connectReq.fail(iox);
            this.connectReq = null;
            req.dispose();
            return;
        }
        try {
            if (this.chnl.connect(sa)) {
                this.connectionID = "[" + this.getLocalPort() + "/" + this.getPort() + "]";
                this.state.set(3);
                this.ioState.removeOp(8);
                this.connectReq.dispatch();
                this.connectReq = null;
                req.dispose();
            } else {
                this.ioState.addOp(8);
            }
        }
        catch (IOException iox) {
            this.state.set(0);
            this.ioState.unregister();
            try {
                this.chnl.close();
            }
            catch (IOException dummy) {
                // empty catch block
            }
            this.connectReq.fail(iox);
            this.connectReq = null;
            req.dispose();
        }
    }

    @Override
    public int beginWrite(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        this.rangeCheck(buf.length, off, len);
        if (this.state.get() != 3) {
            throw new IOException("beginWrite when AsyncEndpoint is not connected.");
        }
        AsyncIORequestImpl req = AsyncIORequestImpl.getWriteReq(this, buf, off, len, this.handler, lst);
        if (this.writeQueue.add(req)) {
            try {
                int n = this.actualWrite(req, buf, off, len);
                req.addHistory(4, 0L, off, len, n);
                if (n > 0) {
                    boolean process = this.writeQueue.remove();
                    req.dispose();
                    if (process) {
                        this.ioState.run(this.writeProc);
                    }
                    return n;
                }
            }
            catch (IOException iox) {
                boolean process = this.writeQueue.remove();
                req.dispose();
                if (process) {
                    this.ioState.run(this.writeProc);
                }
                throw iox;
            }
            this.ioState.addOp(4);
        }
        return 0;
    }

    @Override
    protected int beginReadImpl(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        if (this.state.get() != 3) {
            throw new IOException("beginRead when AsyncEndpoint is not connected.");
        }
        AsyncIORequestImpl req = AsyncIORequestImpl.getReadReq(this, buf, off, len, this.getTimeout(), this.handler, lst);
        if (this.readQueue.add(req)) {
            try {
                int n = this.actualRead(req, buf, off, len);
                req.addHistory(3, 0L, off, len, n);
                if (n > 0) {
                    boolean process = this.readQueue.remove();
                    this.ioState.setTimeout(0L);
                    req.dispose();
                    if (process) {
                        this.ioState.run(this.readProc);
                    }
                    return n;
                }
                this.ioState.setTimeout(req.getTimeout());
            }
            catch (IOException iox) {
                boolean process = this.readQueue.remove();
                req.dispose();
                if (process) {
                    this.ioState.run(this.readProc);
                }
                throw iox;
            }
            this.ioState.addOp(1);
        }
        return 0;
    }

    @Override
    protected boolean actualConnect(AsyncIORequestImpl req, InetAddress addr, int port) throws IOException {
        try {
            if (this.state.compareAndSet(1, 2)) {
                this.chnl.finishConnect();
                this.state.set(3);
                this.connectionID = "[" + this.getLocalPort() + "/" + this.getPort() + "]";
                return true;
            }
            return false;
        }
        catch (NoConnectionPendingException npx) {
            this.state.compareAndSet(2, 1);
            return false;
        }
        catch (IOException iox) {
            this.state.set(0);
            throw iox;
        }
    }

    @Override
    protected int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        PooledByteBuffer pooled = PooledByteBuffer.getInstance();
        ByteBuffer bb = pooled.getBuffer();
        int cap = bb.capacity();
        int n = 0;
        len = cap < len ? cap : len;
        bb.limit(len);
        try {
            n = this.chnl.read(bb);
            if (n < 0) {
                throw new EOFException();
            }
            bb.flip();
            bb.get(buf, off, n);
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            pooled.dispose();
            this.ioState.setTimeout(0L);
        }
        return n;
    }

    @Override
    protected int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        PooledByteBuffer pooled = PooledByteBuffer.getInstance();
        ByteBuffer bb = pooled.getBuffer();
        int cap = bb.capacity();
        int n = 0;
        len = cap < len ? cap : len;
        bb.put(buf, off, len);
        bb.flip();
        n = this.chnl.write(bb);
        pooled.dispose();
        if (n > len || n > cap) {
            LogSupport.error(this, "actualWrite", "Wrote " + n + " bytes from a buffer containing " + len + " (capacity " + cap + ")");
        }
        return n;
    }

    @Override
    protected boolean actualClose(AsyncIORequestImpl req) throws IOException {
        this.state.set(0);
        this.chnl.socket().shutdownInput();
        this.chnl.socket().shutdownOutput();
        this.ioState.unregister();
        this.chnl.close();
        return true;
    }

    String getID() {
        return this.connectionID;
    }

    public void run(Runnable r) {
        this.ioState.run(r);
    }

    class SelectorIOState
    extends AsyncIOState {
        public SelectorIOState(SocketChannel chnl) throws IOException {
            super(chnl);
        }

        @Override
        public Runnable getConnectProc() {
            return SelectorAsyncEndpoint.this.connectProc;
        }

        @Override
        public Runnable getReadProc() {
            return SelectorAsyncEndpoint.this.readProc;
        }

        @Override
        public Runnable getWriteProc() {
            return SelectorAsyncEndpoint.this.writeProc;
        }

        @Override
        public Runnable getTimeoutProc() {
            return SelectorAsyncEndpoint.this.timeoutProc;
        }
    }
}

