/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.nio;

import com.elluminate.net.NetTuning;
import com.elluminate.net.nio.AsyncIOState;
import com.elluminate.net.nio.IOCancelAction;
import com.elluminate.net.nio.IOChangeOpAction;
import com.elluminate.net.nio.IORegisterAction;
import com.elluminate.net.nio.IOStateAction;
import com.elluminate.util.CircularWorkQueue;
import com.elluminate.util.WorkerPool;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncIOManager {
    private static Object instanceLock = new Object();
    private static AsyncIOManager instance = null;
    private AtomicReference<IOStateAction> pending = new AtomicReference<Object>(null);
    private Selector selector = null;
    private Thread dispatcher = null;
    private CircularWorkQueue queue = new CircularWorkQueue(NetTuning.AsyncIODispatchQueueSize.getIntValue());
    private WorkerPool pool = new WorkerPool("AsyncIODispatchWorker", this.queue, NetTuning.AsyncIODispatchPoolSize.getIntValue());
    private long checkTime;
    private volatile boolean dump = false;
    private long nAccept = 0L;
    private long nConnect = 0L;
    private long nRead = 0L;
    private long nWrite = 0L;

    private AsyncIOManager() throws IOException {
        this.selector = Selector.open();
        this.dispatcher = new Thread(new Runnable(){

            @Override
            public void run() {
                AsyncIOManager.this.runDispatcher();
            }
        }, "AsyncIO Dispatcher");
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
    }

    private void checkTimeouts(long clk) {
        for (SelectionKey k : this.selector.keys()) {
            AsyncIOState s = (AsyncIOState)k.attachment();
            long t = s.getTimeout();
            int o = 0;
            try {
                o = k.interestOps();
            }
            catch (CancelledKeyException ckx) {
                continue;
            }
            if ((o & 1) == 0 || t <= 0L || t > clk) continue;
            o &= 0xFFFFFFFE;
            try {
                k.interestOps(o);
            }
            catch (CancelledKeyException ckx) {
                // empty catch block
            }
            this.queue.execute(s.getTimeoutProc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runDispatcher() {
        this.checkTime = System.currentTimeMillis() + (long)NetTuning.AsyncIOTimeoutCheckInterval.getIntValue();
        while (true) {
            try {
                while (true) {
                    long now;
                    long delay;
                    if ((delay = this.checkTime - (now = System.currentTimeMillis())) <= 0L) {
                        delay = 1000L;
                    }
                    this.selector.select(delay);
                    if (this.dump) {
                        this.doDump();
                    }
                    Set<SelectionKey> selected = this.selector.selectedKeys();
                    Iterator<SelectionKey> i = selected.iterator();
                    while (i.hasNext()) {
                        SelectionKey key = i.next();
                        AsyncIOState state = (AsyncIOState)key.attachment();
                        i.remove();
                        try {
                            if (!key.isValid()) continue;
                            SelectionKey selectionKey = key;
                            synchronized (selectionKey) {
                                int ready = key.readyOps();
                                int interest = key.interestOps();
                                key.interestOps(interest &= ~ready);
                            }
                            if (key.isAcceptable()) {
                                this.queue.execute(state.getAcceptProc());
                                ++this.nAccept;
                            }
                            if (key.isConnectable()) {
                                this.queue.execute(state.getConnectProc());
                                ++this.nConnect;
                            }
                            if (key.isReadable()) {
                                this.queue.execute(state.getReadProc());
                                ++this.nRead;
                            }
                            if (!key.isWritable()) continue;
                            this.queue.execute(state.getWriteProc());
                            ++this.nWrite;
                        }
                        catch (CancelledKeyException ccx) {}
                    }
                    for (IOStateAction work = (IOStateAction)this.pending.getAndSet(null); work != null; work = work.getNext()) {
                        IOStateAction action = work;
                        action.execute();
                    }
                    if (now < this.checkTime) continue;
                    this.checkTime = now + (long)NetTuning.AsyncIOTimeoutCheckInterval.getIntValue();
                    this.checkTimeouts(now);
                }
            }
            catch (IOException iox) {
                LogSupport.exception(this, "runDispatcher", iox, true);
                continue;
            }
            break;
        }
    }

    void wakeup() {
        this.selector.wakeup();
    }

    private void queue(IOStateAction action) {
        do {
            action.setNext(this.pending.get());
        } while (!this.pending.compareAndSet(action.getNext(), action));
    }

    void register(SelectableChannel chnl, AsyncIOState state) throws ClosedChannelException, IOException {
        IORegisterAction reg = new IORegisterAction(this, chnl, state);
        this.queue(reg);
        reg.register();
    }

    void unregister(AsyncIOState state) {
        SelectionKey key = state.getKey();
        if (key != null) {
            IOCancelAction cancel = new IOCancelAction(key);
            this.queue(cancel);
            cancel.cancel();
        }
    }

    void addOp(AsyncIOState state, int mask) {
        SelectionKey key = state.getKey();
        IOChangeOpAction chg = IOChangeOpAction.addOpInstance(key, mask);
        this.queue(chg);
        chg.change();
    }

    void removeOp(AsyncIOState state, int mask) {
        SelectionKey key = state.getKey();
        IOChangeOpAction chg = IOChangeOpAction.removeOpInstance(key, mask);
        this.queue(chg);
        chg.change();
        chg.dispose();
    }

    Selector getSelector() {
        return this.selector;
    }

    void run(Runnable r) {
        this.queue.execute(r);
    }

    public void dump() {
        this.dump = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIOManager getInstance() throws IOException {
        AsyncIOManager mgr = null;
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new AsyncIOManager();
            }
            mgr = instance;
        }
        return mgr;
    }

    public static boolean isAvailable() {
        try {
            return AsyncIOManager.getInstance() != null;
        }
        catch (IOException iox) {
            return false;
        }
    }

    private void doDump() {
        this.dump = false;
        LogSupport.message(this, "doDump", this.selector.keys().size() + " keys:");
        for (SelectionKey k : this.selector.keys()) {
            AsyncIOState state = (AsyncIOState)k.attachment();
            if (!k.isValid()) {
                LogSupport.message(this, "doDump", "    " + System.identityHashCode(state) + " - " + k.channel().getClass().getName() + ": invalid");
                continue;
            }
            LogSupport.message(this, "doDump", "    " + System.identityHashCode(state) + " - " + k.channel().getClass().getName() + ": interest=" + k.interestOps() + ", ready=" + k.readyOps());
        }
        LogSupport.message(this, "doDump", "Stats: a=" + this.nAccept + ",c=" + this.nConnect + ",r=" + this.nRead + ",w=" + this.nWrite);
    }
}

