/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.https;

import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxyEndpoint;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthenticator;
import com.elluminate.net.https.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;

public class HttpsEndpoint
extends ProxyEndpoint {
    private static int connectSeq = 1;
    private static Object seqLock = new Object();
    private I18n i18n = I18n.create(this);
    private String targetHost = null;
    private int targetPort = 443;
    private String proxyHost = null;
    private InetAddress proxyAddr = null;
    private int proxyPort = 80;
    private ProxyAuthenticator proxy = new ProxyAuthenticator();
    private int seq = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsEndpoint(String targetHost, int targetPort, String proxyHost, int proxyPort, HashMap options) throws UnknownHostException, IOException {
        super(new Socket(proxyHost, proxyPort));
        Object object = seqLock;
        synchronized (object) {
            this.seq = connectSeq++;
        }
        if (NetDebug.HTTP_AUTH.show()) {
            LogSupport.message(this, "<init>", this.seq + ": connecting to " + proxyHost + ":" + proxyPort);
        }
        this.proxyHost = proxyHost;
        this.proxyAddr = InetAddress.getByName(proxyHost);
        this.proxyPort = proxyPort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsEndpoint(InetAddress targetAddr, int targetPort, InetAddress proxyAddr, int proxyPort, HashMap options) throws IOException {
        super(new Socket(proxyAddr, proxyPort));
        Object object = seqLock;
        synchronized (object) {
            this.seq = connectSeq++;
        }
        if (NetDebug.HTTP_AUTH.show()) {
            LogSupport.message(this, "<init>", this.seq + ": connecting to " + this.proxyHost + ":" + proxyPort);
        }
        this.targetHost = targetAddr.getHostAddress();
        this.targetPort = targetPort;
        this.proxyAddr = proxyAddr;
        this.proxyPort = proxyPort;
        this.init();
    }

    private void init() throws IOException {
        boolean reconnect = false;
        boolean established = false;
        Socket s = this.getSocket();
        DataInputStream istr = new DataInputStream(s.getInputStream());
        DataOutputStream ostr = new DataOutputStream(s.getOutputStream());
        byte[] buffer = new byte[512];
        int httpVer = 11;
        if (NetDebug.CONNECTIONS.show()) {
            LogSupport.message(this, "init", "Create HTTPS connection from " + s.getInetAddress() + ":" + s.getPort() + " to port " + s.getLocalPort());
        }
        while (!established) {
            NetHttpRequest req = new NetHttpRequest(this.targetHost, this.targetPort, 3, null, 0, false, httpVer);
            req.setHeader("Host", this.targetHost + ":" + this.targetPort);
            this.proxy.authenticate(req);
            if (NetDebug.HTTP_AUTH.show()) {
                LogSupport.message(this, "init", this.seq + ": sending connect with auth " + req.getHeader("Proxy-Authorization"));
            }
            req.send(ostr);
            NetHttpResponse resp = new NetHttpResponse(istr);
            if (httpVer == 11) {
                if (resp.getCode() == 505) {
                    httpVer = 10;
                    if (NetDebug.HTTP.show()) {
                        LogSupport.message(this, "init", this.seq + ": HTTP/1.1 not supported - falling back to HTTP/1.0");
                    }
                    try {
                        s.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (NetDebug.HTTP.show()) {
                        LogSupport.message(this, "init", this.seq + ": connecting to " + this.proxyAddr + ":" + this.proxyPort);
                    }
                    s = new Socket(this.proxyAddr, this.proxyPort);
                    istr = new DataInputStream(s.getInputStream());
                    ostr = new DataOutputStream(s.getOutputStream());
                    this.setSocket(s);
                    continue;
                }
                if (resp.getHTTPVersion() == 10) {
                    httpVer = 10;
                    if (NetDebug.HTTP.show()) {
                        LogSupport.message(this, "init", this.seq + ": HTTP/1.1 not supported - falling back to HTTP/1.0");
                    }
                }
            }
            int len = resp.getLength();
            if (NetDebug.HTTP_AUTH.show()) {
                LogSupport.message(this, "init", this.seq + ": read " + resp.getCode() + " response with auth " + resp.getHeader("Proxy-Authenticate"));
            }
            if (this.proxy.checkResponse(resp)) {
                if (this.proxy.disconnectRequired()) {
                    if (NetDebug.HTTP_AUTH.show()) {
                        LogSupport.message(this, "init", this.seq + ": disconnecting.");
                    }
                    try {
                        s.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (NetDebug.HTTP_AUTH.show()) {
                        LogSupport.message(this, "init", this.seq + ": connecting to " + this.proxyAddr + ":" + this.proxyPort);
                    }
                    s = new Socket(this.proxyAddr, this.proxyPort);
                    istr = new DataInputStream(s.getInputStream());
                    ostr = new DataOutputStream(s.getOutputStream());
                    this.setSocket(s);
                    len = 0;
                }
            } else if (resp.getCode() == 200) {
                established = true;
            } else {
                throw new IOException(this.i18n.getString(StringsProperties.HTTPSENDPOINT_REFUSED, resp.getMessage()));
            }
            while (len > 0) {
                int nToRead = Math.min(len, buffer.length);
                int nRead = istr.read(buffer, 0, nToRead);
                if (nRead < 0) {
                    throw new EOFException();
                }
                len -= nRead;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (NetDebug.CONNECTIONS.show()) {
            LogSupport.message(this, "close", "Closed HTTPS connection from " + this.getInetAddress() + ":" + this.getPort() + " to port " + this.getLocalPort());
        }
        super.close();
    }
}

