/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.httpCommon.NtlmMsgProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NtlmNativeMsgProvider
implements NtlmMsgProvider {
    private static final String SUPPORT_CLASS = "com.elluminate.platform.windows.WinNetNtlmAuth";
    private static Class winNetNtlmAuth;
    private static Method setCredentials;
    private static Method getType1;
    private static Method getType3;
    private boolean triedSystemCredentials = false;
    private Object nativeHelper = null;
    private ProxyAuthData credentials = null;

    public NtlmNativeMsgProvider() {
        if (winNetNtlmAuth != null) {
            try {
                this.nativeHelper = winNetNtlmAuth.newInstance();
                return;
            }
            catch (IllegalAccessException iax) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Native NTLM support is not available.");
    }

    @Override
    public String getType1() throws IOException {
        try {
            if (this.credentials == null) {
                setCredentials.invoke(this.nativeHelper, null, null, null);
            } else {
                setCredentials.invoke(this.nativeHelper, this.credentials.getUser(), this.credentials.getPass(), this.credentials.getContext().getValue());
            }
            return (String)getType1.invoke(this.nativeHelper, new Object[0]);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof IOException) {
                throw (IOException)itx.getCause();
            }
            throw new RuntimeException(itx.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getType3(String type2) throws IOException {
        if (this.nativeHelper == null) {
            throw new IllegalStateException("Cannot generate NTLM type3 message before type1 message");
        }
        try {
            String result = (String)getType3.invoke(this.nativeHelper, type2);
            this.nativeHelper = null;
            return result;
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof IOException) {
                throw (IOException)itx.getCause();
            }
            throw new RuntimeException(itx.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needCredentials() {
        return this.triedSystemCredentials;
    }

    @Override
    public void reset() {
        this.triedSystemCredentials = true;
        this.nativeHelper = null;
        this.credentials = null;
    }

    @Override
    public void setCredentials(ProxyAuthData credentials) {
        this.credentials = credentials;
    }

    static {
        try {
            winNetNtlmAuth = Class.forName(SUPPORT_CLASS);
            setCredentials = winNetNtlmAuth.getMethod("setCredentials", String.class, String.class, String.class);
            getType1 = winNetNtlmAuth.getMethod("getType1", new Class[0]);
            getType3 = winNetNtlmAuth.getMethod("getType3", String.class);
        }
        catch (ClassNotFoundException cnfx) {
            winNetNtlmAuth = null;
        }
        catch (SecurityException e) {
            winNetNtlmAuth = null;
        }
        catch (NoSuchMethodException e) {
            winNetNtlmAuth = null;
        }
    }
}

