/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.httpCommon.NtlmMsgProvider;
import com.elluminate.net.httpCommon.StringsProperties;
import com.elluminate.util.Base64;
import com.elluminate.util.EncodingException;
import com.elluminate.util.I18n;
import com.elluminate.util.crypto.DES;
import com.elluminate.util.crypto.MD4;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;

public class NtlmGenericMsgProvider
implements NtlmMsgProvider {
    private static final long EPOCH_MSEC = 11644473600000L;
    private static final byte[] NTLMSSP_SIG = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private static final byte[] TYPE1_MSG = new byte[]{1, 0, 0, 0};
    private static final byte[] TYPE2_MSG = new byte[]{2, 0, 0, 0};
    private static final byte[] TYPE3_MSG = new byte[]{3, 0, 0, 0};
    private static final byte[] BLOB_SIG = new byte[]{1, 1, 0, 0, 0, 0, 0, 0};
    private static final int NEGOTIATE_UNICODE = 1;
    private static final int NEGOTIATE_OEM = 2;
    private static final int REQUEST_TARGET = 4;
    private static final int NEGOTIATE_NTLM = 512;
    private static final int NEGOTIATE_DOMAIN_SUPPLIED = 4096;
    private static final int NEGOTIATE_WORKSTATION_SUPPLIED = 8192;
    private static final int TARGET_TYPE_DOMAIN = 65536;
    private static final int TARGET_TYPE_SERVER = 131072;
    private static final int TARGET_TYPE_SHARE = 262144;
    private static final int NEGOTIATE_TARGET_INFO = 0x800000;
    private static final int TYPE1_FLAGS = 517;
    private static I18n i18n = I18n.create(NtlmGenericMsgProvider.class);
    private ProxyAuthData authData = null;
    private String target = null;
    private byte[] challenge = null;
    private byte[] clientChallenge = null;
    private byte[] targetInfo = null;
    private boolean useNTLMv2 = true;
    private SecureRandom rnd = new SecureRandom();
    private MessageDigest md5 = null;

    public NtlmGenericMsgProvider() throws UnsupportedOperationException {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("NTLM authentication unavailable - MD5 not supported.");
        }
        try {
            "test".getBytes("US-ASCII");
            "test".getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("NTLM authentication unavailable - Character codings not supported");
        }
    }

    @Override
    public boolean needCredentials() {
        return true;
    }

    @Override
    public void setCredentials(ProxyAuthData credentials) {
        this.authData = credentials;
    }

    @Override
    public String getType1() throws IOException {
        ByteArrayOutputStream str = new ByteArrayOutputStream(16);
        str.write(NTLMSSP_SIG);
        str.write(TYPE1_MSG);
        str.write(this.encodeInt(517));
        byte[] t1 = str.toByteArray();
        return Base64.encode(t1);
    }

    @Override
    public String getType3(String type2) throws IOException {
        if (this.authData == null) {
            throw new IllegalStateException("No credentials supplied.");
        }
        MsgBlock msg = new MsgBlock(type2);
        this.checkType2(msg);
        return this.buildType3();
    }

    @Override
    public void reset() {
        this.useNTLMv2 = !this.useNTLMv2;
        this.target = null;
        this.targetInfo = null;
        this.challenge = null;
        this.clientChallenge = null;
        this.authData = null;
    }

    private void checkType2(MsgBlock msg) throws IOException {
        int offset = 0;
        this.target = null;
        this.targetInfo = null;
        this.challenge = null;
        if (!msg.checkSig(offset, NTLMSSP_SIG)) {
            throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_MISSINGSIGNATURE));
        }
        if (!msg.checkSig(offset += NTLMSSP_SIG.length, TYPE2_MSG)) {
            throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_INVALIDRESPONSE));
        }
        offset += TYPE2_MSG.length;
        int flags = msg.readInt(20);
        if ((flags & 1) == 0) {
            throw new IOException();
        }
        if ((flags & 0x10000) == 0 && (flags & 0x20000) == 0 && (flags & 0x40000) == 0) {
            throw new IOException();
        }
        this.challenge = new byte[8];
        msg.read(this.challenge, 24, 8);
        SecurityBuffer targetSB = null;
        SecurityBuffer targetInfoSB = null;
        try {
            targetSB = new SecurityBuffer(msg, 12, 32);
        }
        catch (IOException ex) {
            throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_NOTARGET));
        }
        this.target = targetSB.readString();
        if (this.useNTLMv2) {
            if ((flags & 0x800000) == 0) {
                this.useNTLMv2 = false;
            } else if (targetSB.offset == 48) {
                targetInfoSB = new SecurityBuffer(msg, 40, targetSB.offset + targetSB.alloc);
            } else if (targetSB.offset == 40) {
                targetInfoSB = new SecurityBuffer(msg, 32, targetSB.offset + targetSB.alloc);
            } else {
                try {
                    targetInfoSB = new SecurityBuffer(msg, 32, 40);
                }
                catch (IOException ex) {
                    try {
                        targetInfoSB = new SecurityBuffer(msg, 40, 48);
                    }
                    catch (IOException ex2) {
                        this.useNTLMv2 = false;
                    }
                }
            }
        }
        if (this.useNTLMv2 && targetInfoSB != null) {
            this.targetInfo = targetInfoSB.readBytes();
        }
    }

    private String buildType3() throws IOException {
        String workstation = null;
        byte[] blob = null;
        byte[] lmResp = null;
        byte[] ntlmResp = null;
        try {
            InetAddress local = InetAddress.getLocalHost();
            workstation = local.getHostName();
        }
        catch (UnknownHostException ex) {
            workstation = "localhost";
        }
        if (this.useNTLMv2 && (blob = this.makeBlob()) == null) {
            this.useNTLMv2 = false;
        }
        if (this.useNTLMv2) {
            lmResp = this.getLMv2Response(this.authData);
            ntlmResp = this.getNTLMv2Response(this.authData);
        } else {
            lmResp = this.getLMResponse(this.authData);
            ntlmResp = this.getNTLMResponse(this.authData);
        }
        int end = 60;
        MsgBlock msg = new MsgBlock(end + lmResp.length + ntlmResp.length + this.target.length() * 2 + this.authData.getUser().length() * 2 + workstation.length() * 2);
        msg.write(NTLMSSP_SIG, 0, NTLMSSP_SIG.length);
        msg.write(TYPE3_MSG, 8, TYPE3_MSG.length);
        end = msg.writeSecurityBuf(lmResp, 12, end);
        end = msg.writeSecurityBuf(ntlmResp, 20, end);
        end = msg.writeSecurityBuf(this.target, 28, end);
        end = msg.writeSecurityBuf(this.authData.getUser(), 36, end);
        end = msg.writeSecurityBuf(workstation, 44, end);
        end = msg.writeSecurityBuf(new byte[0], 52, end);
        return msg.toString();
    }

    private byte[] getLMResponse(ProxyAuthData authData) throws IOException {
        byte[] lmHash = this.lmHash(authData.getPass());
        return this.lmResponse(lmHash, this.challenge);
    }

    private byte[] getNTLMResponse(ProxyAuthData authData) throws IOException {
        byte[] ntlmHash = this.ntlmHash(authData.getPass());
        return this.lmResponse(ntlmHash, this.challenge);
    }

    private byte[] getLMv2Response(ProxyAuthData authData) throws IOException {
        byte[] ntlmv2Hash = this.ntlmv2Hash(authData);
        return this.lmv2Response(ntlmv2Hash, this.clientChallenge, this.challenge);
    }

    private byte[] getNTLMv2Response(ProxyAuthData authData) throws IOException {
        byte[] ntlmv2Hash = this.ntlmv2Hash(authData);
        byte[] blob = this.makeBlob();
        return this.lmv2Response(ntlmv2Hash, blob, this.challenge);
    }

    private byte[] lmHash(String password) {
        byte[] magic;
        byte[] oemPassword;
        try {
            oemPassword = password.toUpperCase(Locale.ENGLISH).getBytes("US-ASCII");
            magic = "KGS!@#$%".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to get US-ASCII character encoding");
        }
        int len = Math.min(oemPassword.length, 14);
        byte[] keyBytes = new byte[14];
        System.arraycopy(oemPassword, 0, keyBytes, 0, len);
        byte[] lowKey = this.createDESKey(keyBytes, 0);
        byte[] topKey = this.createDESKey(keyBytes, 7);
        DES des = new DES();
        byte[] lmHash = new byte[16];
        des.init(lowKey, true);
        des.processBlock(magic, 0, lmHash, 0);
        des.init(topKey, true);
        des.processBlock(magic, 0, lmHash, 8);
        return lmHash;
    }

    private byte[] ntlmHash(String password) {
        byte[] unicode;
        try {
            unicode = password.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to get UnicodeLittleUnmarked encoding");
        }
        MD4 md4 = new MD4();
        md4.process(unicode);
        return md4.hash();
    }

    private byte[] ntlmv2Hash(ProxyAuthData authData) {
        byte[] id;
        byte[] ntlmHash = this.ntlmHash(authData.getPass());
        String identity = authData.getUser().toUpperCase(Locale.ENGLISH) + authData.getContext().getValue().toUpperCase(Locale.ENGLISH);
        try {
            id = identity.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to get UnicodeLittleUnmarked encoding");
        }
        return this.hmacMD5(id, ntlmHash);
    }

    private byte[] lmResponse(byte[] hash, byte[] challenge) {
        byte[] keyBytes = new byte[21];
        System.arraycopy(hash, 0, keyBytes, 0, 16);
        byte[] lowKey = this.createDESKey(keyBytes, 0);
        byte[] midKey = this.createDESKey(keyBytes, 7);
        byte[] topKey = this.createDESKey(keyBytes, 14);
        DES des = new DES();
        byte[] lmResp = new byte[24];
        des.init(lowKey, true);
        des.processBlock(challenge, 0, lmResp, 0);
        des.init(midKey, true);
        des.processBlock(challenge, 0, lmResp, 8);
        des.init(topKey, true);
        des.processBlock(challenge, 0, lmResp, 16);
        return lmResp;
    }

    private byte[] lmv2Response(byte[] hash, byte[] cData, byte[] challenge) {
        byte[] data = new byte[challenge.length + cData.length];
        System.arraycopy(challenge, 0, data, 0, challenge.length);
        System.arraycopy(cData, 0, data, challenge.length, cData.length);
        byte[] mac = this.hmacMD5(data, hash);
        byte[] lmv2Resp = new byte[mac.length + cData.length];
        System.arraycopy(mac, 0, lmv2Resp, 0, mac.length);
        System.arraycopy(cData, 0, lmv2Resp, mac.length, cData.length);
        return lmv2Resp;
    }

    private byte[] createDESKey(byte[] base, int off) {
        byte[] keyBytes = new byte[7];
        byte[] material = new byte[8];
        System.arraycopy(base, off, keyBytes, 0, 7);
        material[0] = keyBytes[0];
        material[1] = (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1);
        material[2] = (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2);
        material[3] = (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3);
        material[4] = (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4);
        material[5] = (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5);
        material[6] = (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6);
        material[7] = (byte)(keyBytes[6] << 1);
        this.oddParity(material);
        return material;
    }

    private void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean needsParity;
            byte b = bytes[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }

    private byte[] hmacMD5(byte[] data, byte[] key) {
        int i;
        byte[] iPad = new byte[64];
        byte[] oPad = new byte[64];
        for (i = 0; i < 64; ++i) {
            iPad[i] = 54;
            oPad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            iPad[n] = (byte)(iPad[n] ^ key[i]);
            int n2 = i;
            oPad[n2] = (byte)(oPad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(iPad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        data = this.md5.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(oPad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return this.md5.digest(content);
    }

    private byte[] encodeInt(int value) {
        byte[] data = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return data;
    }

    private byte[] makeBlob() {
        if (this.targetInfo == null) {
            return null;
        }
        byte[] blob = new byte[28 + this.targetInfo.length];
        BigInteger CC = new BigInteger(64, this.rnd);
        this.clientChallenge = CC.toByteArray();
        System.arraycopy(BLOB_SIG, 0, blob, 0, BLOB_SIG.length);
        System.arraycopy(this.getTimeStamp(), 0, blob, 8, 8);
        System.arraycopy(this.clientChallenge, 0, blob, 16, this.clientChallenge.length);
        System.arraycopy(this.targetInfo, 0, blob, 28, this.targetInfo.length);
        return blob;
    }

    private byte[] getTimeStamp() {
        long now = System.currentTimeMillis();
        now += 11644473600000L;
        now *= 10000L;
        byte[] stamp = new byte[8];
        for (int i = 0; i < 8; ++i) {
            stamp[i] = (byte)(now >> 8 * i & 0xFFL);
        }
        return stamp;
    }

    private class MsgBlock {
        private byte[] bytes;

        public MsgBlock(String data) throws EncodingException {
            this.bytes = Base64.decode(data);
        }

        public MsgBlock(int len) {
            this.bytes = new byte[len];
        }

        public int length() {
            return this.bytes.length;
        }

        public short readShort(int at) throws IOException {
            if (this.bytes.length < at + 2) {
                throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_SHORTRESPONSE));
            }
            return (short)(this.bytes[at] & 0xFF | (this.bytes[at + 1] & 0xFF) << 8);
        }

        public int readInt(int at) throws IOException {
            if (this.bytes.length < at + 4) {
                throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_SHORTRESPONSE));
            }
            return this.bytes[at] & 0xFF | (this.bytes[at + 1] & 0xFF) << 8 | (this.bytes[at + 2] & 0xFF) << 16 | (this.bytes[at + 3] & 0xFF) << 24;
        }

        public boolean checkSig(int offset, byte[] pattern) {
            if (offset + pattern.length > this.bytes.length) {
                return false;
            }
            for (int i = 0; i < pattern.length; ++i) {
                if (this.bytes[offset + i] == pattern[i]) continue;
                return false;
            }
            return true;
        }

        public void read(byte[] buf, int off, int len) {
            System.arraycopy(this.bytes, off, buf, 0, len);
        }

        public void write(byte[] buf, int off, int len) {
            System.arraycopy(buf, 0, this.bytes, off, len);
        }

        public int writeSecurityBuf(byte[] buf, int off, int end) {
            int len = buf.length;
            byte by = (byte)(len & 0xFF);
            this.bytes[off + 2] = by;
            this.bytes[off] = by;
            byte by2 = (byte)(len >> 8 & 0xFF);
            this.bytes[++off + 2] = by2;
            this.bytes[off] = by2;
            off += 3;
            this.bytes[off++] = (byte)(end & 0xFF);
            this.bytes[off++] = (byte)(end >> 8 & 0xFF);
            this.bytes[off++] = (byte)(end >> 16 & 0xFF);
            this.bytes[off++] = (byte)(end >> 24 & 0xFF);
            System.arraycopy(buf, 0, this.bytes, end, len);
            return end + len;
        }

        public int writeSecurityBuf(String buf, int off, int end) {
            byte[] data = new byte[buf.length() * 2];
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                int o = i * 2;
                data[o] = (byte)(c & 0xFF);
                data[o + 1] = (byte)(c >> 8 & 0xFF);
            }
            return this.writeSecurityBuf(data, off, end);
        }

        public String toString() {
            return Base64.encode(this.bytes);
        }
    }

    private class SecurityBuffer {
        private MsgBlock msg;
        public short length;
        public short alloc;
        public int offset;

        public SecurityBuffer(MsgBlock msg, int at, int min) throws IOException {
            this.msg = msg;
            this.length = msg.readShort(at);
            this.alloc = msg.readShort(at + 2);
            this.offset = msg.readInt(at + 4);
            if (this.offset + this.alloc > msg.length()) {
                throw new IOException();
            }
            if (this.offset < min) {
                throw new IOException();
            }
            if (this.length < 0 || this.alloc < 0) {
                throw new IOException();
            }
        }

        public String readString() throws IOException {
            if (this.length % 2 != 0) {
                throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_INVALIDRESPONSE));
            }
            if (this.offset + this.length > this.msg.length()) {
                throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_SHORTRESPONSE));
            }
            char[] chars = new char[this.length / 2];
            int pos = this.offset;
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (char)this.msg.readShort(pos);
                pos += 2;
            }
            return new String(chars);
        }

        public byte[] readBytes() throws IOException {
            byte[] data = new byte[this.length];
            if (this.offset + this.length > this.msg.length()) {
                throw new IOException(i18n.getString(StringsProperties.NTLMGENERICMSGPROVIDER_SHORTRESPONSE));
            }
            this.msg.read(data, this.offset, this.length);
            return data;
        }
    }
}

