/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.NetDebug;
import com.elluminate.net.httpCommon.AuthenticateHandler;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public class HttpHeaderParser {
    private static final String AUTH_DELIMS = " \t,=\"\\";
    private static final byte ST_SCHEME = 1;
    private static final byte ST_PARAM_NAME = 2;
    private static final byte ST_EQUALS = 3;
    private static final byte ST_PARAM_VALUE = 4;
    private static final byte ST_NEXT_PARAM = 5;
    private static final byte ST_AMBIG_NAME = 6;
    private static final byte ST_AMBIG_SEP = 7;
    private static final byte ST_COMMA = 8;
    private static I18n i18n = I18n.create(HttpHeaderParser.class);

    private HttpHeaderParser() {
    }

    public static void parseAuth(NetHttpResponse resp, AuthenticateHandler handler) throws IOException {
        String auth = resp.getHeader("Proxy-Authenticate");
        if (auth == null) {
            throw new IOException(i18n.getString(StringsProperties.PROXYAUTHENTICATEPARSER_NOAUTHHEADER, resp.toString()));
        }
        if (NetDebug.HTTP_AUTH_PARSE.show()) {
            LogSupport.message(HttpHeaderParser.class, "parseAuth", "parsing '" + auth + "'");
        }
        StringTokenizer parser = new StringTokenizer(auth, AUTH_DELIMS, true);
        int state = 1;
        boolean isDelimiter = false;
        IOException ex = new IOException("Authorization parse error");
        String scheme = null;
        String argName = null;
        String argValue = null;
        String ambiguous = null;
        HashMap<String, String> args = null;
        boolean escaped = false;
        boolean quoted = false;
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            if (NetDebug.HTTP_AUTH_PARSE.show()) {
                LogSupport.message(HttpHeaderParser.class, "parseAuth", "token='" + token + "', state=" + state);
            }
            isDelimiter = AUTH_DELIMS.indexOf(token) >= 0;
            switch (state) {
                case 1: {
                    if (isDelimiter) {
                        if (token.equals(" ") || token.equals("\t")) break;
                        throw ex;
                    }
                    scheme = token.toLowerCase(Locale.ENGLISH);
                    args = new HashMap<String, String>();
                    state = 2;
                    break;
                }
                case 2: {
                    if (!isDelimiter) {
                        argName = token;
                        state = 3;
                        break;
                    }
                    if (token.equals(",")) {
                        if (!handler.scheme(scheme, args)) {
                            return;
                        }
                        state = 1;
                        break;
                    }
                    if (token.equals(" ") || token.equals("\t")) break;
                    throw ex;
                }
                case 3: {
                    if (token.equals("=")) {
                        argValue = "";
                        state = 4;
                        break;
                    }
                    if (token.equals(",")) {
                        args.put("", argName);
                        if (!handler.scheme(scheme, args)) {
                            return;
                        }
                        state = 1;
                        break;
                    }
                    throw ex;
                }
                case 4: {
                    if (escaped) {
                        argValue = argValue + token;
                        escaped = false;
                        break;
                    }
                    if (quoted) {
                        if (token.equals("\"")) {
                            quoted = false;
                            state = 5;
                            break;
                        }
                        if (token.equals("\\")) {
                            escaped = true;
                            break;
                        }
                        argValue = argValue + token;
                        break;
                    }
                    if (token.equals("\"")) {
                        quoted = true;
                        break;
                    }
                    if (token.equals("=")) {
                        if (args.isEmpty()) {
                            args.put("", argName + "==");
                            if (!handler.scheme(scheme, args)) {
                                return;
                            }
                            state = 8;
                            break;
                        }
                        throw ex;
                    }
                    if (token.equals(",")) {
                        if (args.isEmpty()) {
                            args.put("", argName + "=");
                            if (!handler.scheme(scheme, args)) {
                                return;
                            }
                            state = 1;
                            break;
                        }
                        throw ex;
                    }
                    if (isDelimiter) {
                        throw ex;
                    }
                    argValue = token;
                    state = 5;
                    break;
                }
                case 5: {
                    args.put(argName.toLowerCase(Locale.ENGLISH), argValue);
                    argName = null;
                    argValue = null;
                    if (!token.equals(",")) {
                        throw ex;
                    }
                    state = 6;
                    break;
                }
                case 6: {
                    if (!isDelimiter) {
                        ambiguous = token;
                        state = 7;
                        break;
                    }
                    if (token.equals(" ") || token.equals("\t")) break;
                    throw ex;
                }
                case 7: {
                    if (token.equals("=")) {
                        argName = ambiguous;
                        argValue = "";
                        ambiguous = null;
                        state = 4;
                        break;
                    }
                    if (token.equals(" ") || token.equals("\t")) {
                        if (!handler.scheme(scheme, args)) {
                            return;
                        }
                        scheme = ambiguous.toLowerCase(Locale.ENGLISH);
                        ambiguous = null;
                        args = new HashMap();
                        state = 2;
                        break;
                    }
                    if (token.equals(",")) {
                        if (!handler.scheme(scheme, args)) {
                            return;
                        }
                        scheme = ambiguous.toLowerCase(Locale.ENGLISH);
                        ambiguous = null;
                        args = new HashMap();
                        if (!handler.scheme(scheme, args)) {
                            return;
                        }
                        state = 1;
                        break;
                    }
                    throw ex;
                }
                case 8: {
                    if (!token.equals(",")) {
                        throw ex;
                    }
                    state = 1;
                }
            }
        }
        switch (state) {
            case 5: {
                args.put(argName.toLowerCase(Locale.ENGLISH), argValue);
                break;
            }
            case 3: {
                args.put("", argName);
                break;
            }
            case 4: {
                if (args.isEmpty()) {
                    args.put("", argName + "=");
                    break;
                }
                throw ex;
            }
            case 2: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw ex;
            }
        }
        handler.scheme(scheme, args);
    }

    public static HashMap parseArgList(String value) throws IOException {
        StringTokenizer parser = new StringTokenizer(value, AUTH_DELIMS, true);
        HashMap<String, String> args = new HashMap<String, String>();
        int state = 2;
        boolean isDelimiter = false;
        String argName = null;
        String argValue = null;
        boolean escaped = false;
        boolean quoted = false;
        IOException ex = new IOException("Header parse error");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            isDelimiter = AUTH_DELIMS.indexOf(token) >= 0;
            switch (state) {
                case 2: {
                    if (!isDelimiter) {
                        argName = token.toLowerCase(Locale.ENGLISH);
                        state = 3;
                        break;
                    }
                    if (token.equals(" ") || token.equals("\t")) break;
                    throw ex;
                }
                case 3: {
                    if (token.equals("=")) {
                        argValue = "";
                        state = 4;
                        break;
                    }
                    throw ex;
                }
                case 4: {
                    if (escaped) {
                        argValue = argValue + token;
                        escaped = false;
                        break;
                    }
                    if (quoted) {
                        if (token.equals("\"")) {
                            quoted = false;
                            state = 5;
                            break;
                        }
                        if (token.equals("\\")) {
                            escaped = true;
                            break;
                        }
                        argValue = argValue + token;
                        break;
                    }
                    if (token.equals("\"")) {
                        quoted = true;
                        break;
                    }
                    if (isDelimiter) {
                        throw ex;
                    }
                    argValue = token;
                    state = 5;
                    break;
                }
                case 5: {
                    args.put(argName, argValue);
                    argName = null;
                    argValue = null;
                    if (!token.equals(",")) {
                        throw ex;
                    }
                    state = 2;
                }
            }
        }
        if (state != 5) {
            throw ex;
        }
        return args;
    }
}

