/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.ProxyAuthDataStore;
import com.elluminate.net.ProxyAuthRealm;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthScheme;
import com.elluminate.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class BasicProxyAuthScheme
implements ProxyAuthScheme {
    private String realm = null;
    private String auth;
    private ProxyAuthData authData = null;
    private boolean disconnect = true;

    @Override
    public boolean setArgs(HashMap args) {
        this.realm = (String)args.get("realm");
        return this.realm != null;
    }

    @Override
    public int getStrength() {
        return 5;
    }

    @Override
    public boolean checkResponse(NetHttpResponse resp) {
        if (resp.getCode() == 407) {
            if (this.authData != null) {
                ProxyAuthDataStore.voidAuthData(this.authData);
                this.disconnect = true;
                this.authData = null;
            }
            this.auth = null;
            return true;
        }
        this.disconnect = false;
        return false;
    }

    @Override
    public void authenticate(NetHttpRequest req) throws IOException {
        if (this.auth == null) {
            this.authData = ProxyAuthDataStore.getAuthData("basic", new ProxyAuthRealm(this.realm));
            this.auth = BasicProxyAuthScheme.getBasicAuth(this.authData.getUser(), this.authData.getPass());
        }
        req.setHeader("Proxy-Authorization", this.auth);
    }

    @Override
    public boolean disconnectRequired() {
        return this.disconnect;
    }

    public static String getBasicAuth(String user, String pass) {
        byte[] bytes;
        String userPass = user + ":" + pass;
        StringBuffer auth = new StringBuffer("Basic ");
        try {
            bytes = userPass.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ex) {
            bytes = userPass.getBytes();
        }
        Base64.encode(bytes, auth);
        return auth.toString();
    }
}

