/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.AbstractEndpoint;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointOptions;
import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxySocket;
import com.elluminate.net.http.CircularBuffer;
import com.elluminate.net.http.ConnectionInputStream;
import com.elluminate.net.http.ConnectionOutputStream;
import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpDataHandler;
import com.elluminate.net.http.QueuedInputStream;
import com.elluminate.net.http.QueuedOutputStream;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class HttpSession
extends AbstractEndpoint
implements Endpoint,
HttpDataHandler {
    public static final int START_TIMEOUT = 15000;
    public static final int PING_TIMEOUT = 10000;
    public static final int BUFFER_SIZE = 65536;
    private static int nextID = -1;
    private static Map<Integer, HttpSession> sessions = new HashMap<Integer, HttpSession>();
    private byte[] hdBuf = null;
    private HttpConnection cRead = null;
    private HttpConnection cWrite = null;
    private Object rLock = new Object();
    private Object wLock = new Object();
    private EndpointOptions rOpts = new EndpointOptions();
    private EndpointOptions wOpts = new EndpointOptions();
    private OutputStream ostr = null;
    private InputStream istr = null;
    private PushbackInputStream userIstr = null;
    private Object modeLock = new Object();
    private int mode = 0;
    private int id = -1;
    private CircularBuffer inBuf = null;
    private CircularBuffer outBuf = null;
    private Set<Endpoint> pending = new HashSet<Endpoint>();
    private DiffieHellman auth = new DiffieHellman();
    private LightweightTimer setupWatchdog = null;
    private EndpointOptions opts = new EndpointOptions();
    private InetAddress remoteAddr = null;
    private int remotePort = -1;
    private InetAddress localAddr = null;
    private int localPort = -1;

    HttpSession(int id, Endpoint ep, LinkedList<Endpoint> q) {
        this.id = id;
        this.remoteAddr = ep.getInetAddress();
        this.remotePort = ep.getPort();
        this.localAddr = ep.getLocalAddress();
        this.localPort = ep.getLocalPort();
        this.setupWatchdog = new LightweightTimer(1, new Runnable(){

            @Override
            public void run() {
                HttpSession.this.close();
            }
        });
        this.setupWatchdog.scheduleIn(15000L);
    }

    public int getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChallenge() {
        HttpSession httpSession = this;
        synchronized (httpSession) {
            long timeout = System.currentTimeMillis() + 10000L;
            while (this.pending.isEmpty()) {
                long delay = timeout - System.currentTimeMillis();
                if (delay <= 0L) {
                    this.setMode(1);
                    this.setupWatchdog.cancel();
                    this.hdBuf = new byte[4096];
                    this.inBuf = new CircularBuffer(65536);
                    this.inBuf.setExceptionMode(1);
                    this.inBuf.setReadTimeout(this.opts.getSoTimeout());
                    this.outBuf = new CircularBuffer(65536);
                    this.outBuf.setExceptionMode(2);
                    this.pending.clear();
                    return this.auth.getChallenge();
                }
                try {
                    this.wait(delay);
                }
                catch (InterruptedException ex) {}
            }
            return this.auth.getChallenge();
        }
    }

    public int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMode(int newMode) {
        Object object = this.modeLock;
        synchronized (object) {
            this.mode = newMode;
            this.modeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitMode(long timeout) {
        Object object = this.modeLock;
        synchronized (object) {
            while (this.mode == 0) {
                try {
                    this.modeLock.wait(timeout);
                }
                catch (InterruptedException ex) {
                    return -1;
                }
            }
        }
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(String response) {
        DiffieHellman diffieHellman = this.auth;
        synchronized (diffieHellman) {
            this.auth.setResponse(response);
        }
    }

    public int getKeyLength() {
        return DiffieHellman.getKeyLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean join(Endpoint ep) {
        HttpSession httpSession = this;
        synchronized (httpSession) {
            if (this.mode != 0) {
                return false;
            }
            this.pending.add(ep);
            this.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean authenticateData(String path, byte[] key) {
        boolean authenticated = false;
        DiffieHellman diffieHellman = this.auth;
        synchronized (diffieHellman) {
            authenticated = this.auth.checkKey(key, path);
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean authenticateJoin(Endpoint ep, String path, byte[] key) throws IOException {
        if (!this.authenticateData(path, key)) {
            LogSupport.error(this, "authenticateJoin", "Authentication failed - key mismatch.");
            return false;
        }
        HttpSession httpSession = this;
        synchronized (httpSession) {
            if (this.mode != 0) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.message(this, "authenticateJoin", "Authenticate JOIN failed on port " + ep.getLocalPort() + " - mode=" + this.mode);
                }
                return false;
            }
            if (!this.pending.contains(ep)) {
                return false;
            }
            this.setMode(2);
            this.setupWatchdog.cancel();
            this.notifyAll();
            if (NetDebug.HTTP.show()) {
                LogSupport.message(this, "authenticateJoin", "Authenticated JOIN on port " + ep.getLocalPort());
            }
            return true;
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this.remoteAddr;
    }

    @Override
    public int getPort() {
        return this.remotePort;
    }

    @Override
    public InetAddress getProxyAddress() {
        return null;
    }

    @Override
    public int getProxyPort() {
        return 0;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localAddr;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.opts.getSoLinger();
    }

    @Override
    public void setSoLinger(boolean on, int time) throws SocketException {
        this.opts.setSoLinger(on, time);
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.opts.getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) {
        this.opts.setTcpNoDelay(on);
    }

    @Override
    public int getSoTimeout() {
        return this.opts.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.opts.setSoTimeout(timeout);
        if (this.inBuf != null) {
            this.inBuf.setReadTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() {
        HttpSession httpSession = this;
        synchronized (httpSession) {
            if (this.istr == null) {
                switch (this.mode) {
                    case 1: {
                        this.istr = new QueuedInputStream(this.inBuf);
                        break;
                    }
                    case 2: {
                        this.istr = new ConnectionInputStream(this, this);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.userIstr = new PushbackInputStream(this.istr, 64);
            }
        }
        return this.userIstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() {
        HttpSession httpSession = this;
        synchronized (httpSession) {
            if (this.ostr == null) {
                switch (this.mode) {
                    case 1: {
                        this.ostr = new QueuedOutputStream(this.outBuf);
                        break;
                    }
                    case 2: {
                        this.ostr = new ConnectionOutputStream(this);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return this.ostr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpConnection c;
        Object object = this.rLock;
        synchronized (object) {
            if (this.cRead != null) {
                c = this.cRead;
                this.readDetach(c, "Connection closed");
                c.close();
            }
        }
        object = this.wLock;
        synchronized (object) {
            if (this.cWrite != null) {
                c = this.cWrite;
                this.writeDetach(c, "Connection closed");
                c.close();
            }
        }
        object = this;
        synchronized (object) {
            if (this.inBuf != null) {
                this.inBuf.close();
            }
            if (this.outBuf != null) {
                this.outBuf.close();
            }
            HttpSession.removeSession(this.id);
            this.setMode(-2);
        }
    }

    @Override
    public void closeForce() {
        this.close();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mode == -2;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.mode != 0 && this.mode != -1;
    }

    @Override
    public boolean isFullDuplex() {
        return this.mode == 2;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return -1;
    }

    @Override
    public void setRecvBufferSize(int size) throws SocketException {
    }

    @Override
    public int getRecvBufferSize() throws SocketException {
        return -1;
    }

    @Override
    public Socket getSocket() {
        return ProxySocket.getInstance(this);
    }

    @Override
    public Object getReadLock() {
        return this.rLock;
    }

    @Override
    public Object getWriteLock() {
        return this.wLock;
    }

    @Override
    public HttpConnection getReadConnection() {
        return this.cRead;
    }

    @Override
    public HttpConnection getWriteConnection() {
        return this.cWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readAttach(HttpConnection c) {
        Endpoint ep = c.getEndpoint();
        Object object = this.rLock;
        synchronized (object) {
            if (this.cRead != null) {
                throw new IllegalStateException("readAttach when already attached.");
            }
            this.cRead = c;
            if (NetDebug.HTTP.show()) {
                LogSupport.message(this, "readAttach", "attaching " + c);
            }
            switch (this.mode) {
                case 1: {
                    int nRead;
                    try {
                    }
                    catch (IOException ex) {
                        this.inBuf.post(ex);
                        this.readDetach(c, "Exception " + ex + " in call to available.");
                        return;
                    }
                    for (int len = c.available(); len > 0; len -= nRead) {
                        int nBytes = Math.min(len, this.hdBuf.length);
                        try {
                            nRead = c.read(this.hdBuf, 0, nBytes, 0);
                        }
                        catch (IOException ex) {
                            this.postException(c, ex);
                            this.readDetach(c, "Exception " + ex + " in call to read.");
                            return;
                        }
                        if (nRead < 0) {
                            this.postException(c, new EOFException());
                            this.readDetach(c, "EOF return from read call.");
                            return;
                        }
                        try {
                            this.inBuf.write(this.hdBuf, 0, nRead);
                            continue;
                        }
                        catch (IOException ex) {
                            LogSupport.exception(this, "readAttach", ex, true);
                            this.readDetach(c, "Exception " + ex + " in call to write.");
                            return;
                        }
                    }
                    this.readDetach(c, "read complete.");
                    break;
                }
                case 2: {
                    if (!this.saveOptions(ep, this.rOpts, this.opts)) {
                        this.readDetach(c, "Unable to save endpoint options.");
                        return;
                    }
                    this.getInputStream();
                    this.rLock.notifyAll();
                    while (this.cRead != null) {
                        try {
                            this.rLock.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    this.restoreOptions(ep, this.rOpts);
                    break;
                }
                default: {
                    this.readDetach(c, "Invalid state for data transfer.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAttach(HttpConnection c) {
        Endpoint ep = c.getEndpoint();
        Object object = this.wLock;
        synchronized (object) {
            if (this.cWrite != null) {
                throw new IllegalStateException();
            }
            this.cWrite = c;
            if (NetDebug.HTTP.show()) {
                LogSupport.message(this, "writeAttach", "attaching " + c);
            }
            switch (this.mode) {
                case 1: {
                    int nRead;
                    try {
                    }
                    catch (IOException ex) {
                        this.postException(c, ex);
                        this.writeDetach(c, "Exception " + ex + " in call to available.");
                        return;
                    }
                    for (int len = c.available(); len > 0; len -= nRead) {
                        int nBytes = Math.min(len, this.hdBuf.length);
                        try {
                            nRead = this.outBuf.read(this.hdBuf, 0, nBytes);
                        }
                        catch (IOException ex) {
                            this.postException(c, ex);
                            this.writeDetach(c, "Exception " + ex + " in call to read.");
                            return;
                        }
                        if (nRead < 0) {
                            this.postException(c, new EOFException());
                            this.writeDetach(c, "EOF during read.");
                            return;
                        }
                        try {
                            c.write(this.hdBuf, 0, nRead);
                            continue;
                        }
                        catch (IOException ex) {
                            this.outBuf.post(ex);
                            this.writeDetach(c, "Exception " + ex + " in call to write.");
                            return;
                        }
                    }
                    this.writeDetach(c, "write complete");
                    break;
                }
                case 2: {
                    if (!this.saveOptions(ep, this.wOpts, this.opts)) {
                        this.readDetach(c, "Unable to save endpoint options.");
                        return;
                    }
                    this.getOutputStream();
                    this.wLock.notifyAll();
                    while (this.cWrite != null) {
                        try {
                            this.wLock.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    this.restoreOptions(ep, this.wOpts);
                    break;
                }
                default: {
                    this.writeDetach(c, "Invalid state for data transfer.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDetach(HttpConnection c, String why) {
        Object object = this.rLock;
        synchronized (object) {
            if (c == this.cRead) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.message(this, "detach", "Detaching read connection " + c + ": " + why);
                }
                this.cRead = null;
                this.rLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDetach(HttpConnection c, String why) {
        Object object = this.wLock;
        synchronized (object) {
            if (c == this.cWrite) {
                if (NetDebug.HTTP.show()) {
                    LogSupport.message(this, "detach", "Detaching write connection " + c + ": " + why);
                }
                this.cWrite = null;
                this.wLock.notifyAll();
            }
        }
    }

    @Override
    public synchronized int writeAvailable() {
        if (this.outBuf == null) {
            return 0;
        }
        return this.outBuf.nBytesReadable();
    }

    @Override
    public void postException(HttpConnection c, IOException ex) {
        if (c == this.cWrite) {
            if (this.outBuf != null) {
                this.outBuf.post(ex);
            }
        } else if (c == this.cRead && this.inBuf != null) {
            this.inBuf.post(ex);
        }
        this.closeForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HttpSession newSession(Endpoint ep, LinkedList<Endpoint> q) {
        HttpSession session = null;
        Map<Integer, HttpSession> map = sessions;
        synchronized (map) {
            int id = HttpSession.getNextID();
            session = new HttpSession(id, ep, q);
            sessions.put(new Integer(id), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HttpSession findSession(int id) {
        HttpSession session = null;
        Map<Integer, HttpSession> map = sessions;
        synchronized (map) {
            session = sessions.get(new Integer(id));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSession(int id) {
        Map<Integer, HttpSession> map = sessions;
        synchronized (map) {
            sessions.remove(new Integer(id));
        }
    }

    private boolean saveOptions(Endpoint ep, EndpointOptions from, EndpointOptions to) {
        try {
            from.get(ep);
            to.set(ep);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean restoreOptions(Endpoint ep, EndpointOptions saved) {
        try {
            saved.set(ep);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static int getNextID() {
        if (nextID < 0) {
            Random rnd = new Random();
            nextID = rnd.nextInt() & 0x1FFFFFFF;
        }
        int id = nextID++;
        if (nextID <= 0) {
            nextID = 1;
        }
        return id;
    }
}

