/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.Endpoint;
import com.elluminate.net.NetDebug;
import com.elluminate.net.http.HttpDataHandler;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.crypto.Hex;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class HttpConnection
extends WorkerThread {
    public static final int WRITE_BLOCK_SIZE = 65536;
    public static final int FAILED = -1;
    public static final int DETACHED = 0;
    public static final int HALF_DUPLEX = 1;
    public static final int FULL_DUPLEX_READ = 2;
    public static final int FULL_DUPLEX_WRITE = 3;
    public static final long IDLE_WAIT = 100L;
    public static final long RESPONSE_WAIT = 20L;
    private Endpoint endpoint;
    private DataInputStream istr;
    private DataOutputStream ostr;
    protected int nLeft = 0;
    protected int mode = 0;
    protected HttpDataHandler handler = null;
    protected IOException exception = null;
    protected volatile boolean running = true;
    protected int httpVer = 11;

    public HttpConnection(String nm, Endpoint ep, DataInputStream in, DataOutputStream out) {
        super(nm);
        this.endpoint = ep;
        this.istr = in;
        this.ostr = out;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DataInputStream getInputStream() {
        return this.istr;
    }

    public DataOutputStream getOutputStream() {
        return this.ostr;
    }

    @Override
    public void run() {
        Endpoint ep = this.endpoint;
        DataInputStream in = this.istr;
        DataOutputStream out = this.ostr;
        this.init(ep, in, out);
        while (this.running) {
            this.mode = this.idle(ep, in, out);
            switch (this.mode) {
                case 1: {
                    this.handler.readAttach(this);
                    if (this.intermission(out, this.handler.writeAvailable())) {
                        this.handler.writeAttach(this);
                    }
                    this.epilogue(in, out);
                    break;
                }
                case 2: {
                    this.handler.readAttach(this);
                    this.epilogue(in, out);
                    break;
                }
                case 3: {
                    this.handler.writeAttach(this);
                    this.epilogue(in, out);
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    this.running = false;
                    break;
                }
                default: {
                    LogSupport.error(this, "run", "Invalid mode returned from idle - " + this.mode);
                    this.running = false;
                }
            }
            this.mode = 0;
        }
        this.shutdown(in, out);
        if (NetDebug.CONNECTIONS.show()) {
            LogSupport.message(this, "run", "Closed HTTP connection " + this.getName() + " from " + ep.getInetAddress() + ":" + ep.getPort() + " to port " + ep.getLocalPort());
        }
        ep.closeForce();
        ep = null;
        in = null;
        out = null;
    }

    protected abstract void init(Endpoint var1, DataInputStream var2, DataOutputStream var3);

    protected abstract int idle(Endpoint var1, DataInputStream var2, DataOutputStream var3);

    protected abstract boolean intermission(DataOutputStream var1, int var2);

    protected abstract void epilogue(DataInputStream var1, DataOutputStream var2);

    protected abstract void shutdown(DataInputStream var1, DataOutputStream var2);

    public void close() {
        this.running = false;
        this.interrupt();
        this.endpoint = null;
        this.istr = null;
        this.ostr = null;
    }

    public int available() throws IOException {
        this.exceptionCheck();
        switch (this.mode) {
            case 1: {
                return this.nLeft;
            }
            case 3: {
                return this.nLeft;
            }
            case 2: {
                return Math.min(this.nLeft, this.istr.available());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int off, int len, int timeout) throws IOException {
        int saved = 0;
        int nRead = 0;
        this.exceptionCheck();
        try {
            saved = this.endpoint.getSoTimeout();
            this.endpoint.setSoTimeout(timeout);
            nRead = this.istr.read(buffer, off, Math.min(len, this.nLeft));
            if (nRead > 0) {
                this.nLeft -= nRead;
            }
            if (this.nLeft == 0) {
                this.handler.readDetach(this, "Read block exhausted.");
                if (NetDebug.HTTP_DATA.show()) {
                    LogSupport.message(this, "read", Hex.toString(buffer, off, nRead));
                }
            }
        }
        finally {
            if (this.endpoint != null) {
                this.endpoint.setSoTimeout(saved);
            }
        }
        return nRead;
    }

    public int write(byte[] buffer, int off, int len) throws IOException {
        this.exceptionCheck();
        int nWritten = Math.min(len, this.nLeft);
        this.ostr.write(buffer, off, nWritten);
        this.nLeft -= nWritten;
        if (NetDebug.HTTP_DATA.show()) {
            LogSupport.message(this, "write", Hex.toString(buffer, off, nWritten));
        }
        if (this.nLeft == 0) {
            this.handler.writeDetach(this, "Write block complete.");
        }
        return nWritten;
    }

    protected void exceptionCheck() throws IOException {
        if (this.exception != null) {
            IOException io = this.exception;
            this.exception = null;
            throw io;
        }
        if (this.endpoint == null) {
            throw new IOException("Endpoint is closed.");
        }
    }

    public static String getModeName(int mode) {
        switch (mode) {
            case -1: {
                return "FAILED";
            }
            case 0: {
                return "DETACHED";
            }
            case 1: {
                return "HALF-DUPLEX";
            }
            case 2: {
                return "FULL-DUPLEX-READ";
            }
            case 3: {
                return "FULL-DUPLEX-WRITE";
            }
        }
        return "**INVALID**";
    }
}

