/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.Endpoint;
import com.elluminate.net.http.HttpEndpoint;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.ProxyAuthenticator;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.crypto.DiffieHellman;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class HttpAltCaller
extends WorkerThread {
    private static final int SETUP_TIMEOUT = 15000;
    private static final byte[] JOIN_PREFIX = new byte[]{106, 111, 105, 110};
    private InetAddress proxyAddr;
    private int proxyPort;
    private String target;
    private int port;
    private HttpEndpoint primary;
    private Endpoint ep = null;
    private DataInputStream istr = null;
    private DataOutputStream ostr = null;
    private NetHttpRequest req = null;
    private byte[] key = null;
    private boolean aborted = false;
    private ProxyAuthenticator proxy = new ProxyAuthenticator();

    public HttpAltCaller(String target, int port, InetAddress proxyAddr, int proxyPort, DiffieHellman auth, HttpEndpoint primary) {
        this.target = target;
        this.port = port;
        this.proxyAddr = proxyAddr;
        this.proxyPort = proxyPort;
        this.primary = primary;
        this.req = new NetHttpRequest(target, port, 0, 2, primary.getSessionID(), primary.nextSequenceNo(), DiffieHellman.getKeyLength() + 4, false, primary.getHttpVersion());
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(DiffieHellman auth) {
        HttpAltCaller httpAltCaller = this;
        synchronized (httpAltCaller) {
            this.key = auth.getKey(this.req.getPath());
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        HttpAltCaller httpAltCaller = this;
        synchronized (httpAltCaller) {
            this.aborted = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.ep = this.primary.connect(this.target, this.port, this.proxyAddr, this.proxyPort, this.proxy);
            this.ep.setSoTimeout(15000);
            this.istr = new DataInputStream(this.ep.getInputStream());
            this.ostr = new DataOutputStream(this.ep.getOutputStream());
            this.proxy.authenticate(this.req);
            this.req.send(this.ostr);
            this.ostr.write(JOIN_PREFIX);
            HttpAltCaller httpAltCaller = this;
            synchronized (httpAltCaller) {
                while (this.key == null && !this.aborted) {
                    try {
                        this.wait();
                    }
                    catch (Exception ignored) {}
                }
                if (this.aborted) {
                    this.primary.altFailed(this);
                    this.close();
                    return;
                }
                this.ostr.write(this.key);
            }
            NetHttpResponse resp = new NetHttpResponse(this.istr);
            this.proxy.checkResponse(resp);
            if (resp.getCode() != 200) {
                this.primary.altFailed(this);
                this.close();
                return;
            }
            int id = this.istr.readInt();
            if (id != this.primary.getSessionID()) {
                this.primary.altFailed(this);
                this.close();
                return;
            }
            this.ep.setSoTimeout(0);
            this.primary.altConnected(this, this.ep, this.istr, this.ostr, this.proxy);
        }
        catch (IOException ex) {
            this.primary.altFailed(this);
            this.close();
        }
    }

    private void close() {
        Endpoint closeEP = this.ep;
        if (closeEP != null) {
            closeEP.closeForce();
        }
    }
}

