/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.http.HttpConnection;
import com.elluminate.net.http.HttpDataHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;

public class ConnectionOutputStream
extends OutputStream {
    private static final long MAX_ATTACH_WAIT = 30000L;
    private byte[] buf = new byte[1];
    private HttpDataHandler handler = null;

    public ConnectionOutputStream(HttpDataHandler handler) {
        this.handler = handler;
    }

    @Override
    public void write(int b) throws IOException {
        this.buf[0] = (byte)b;
        this.write(this.buf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        int total = len;
        Object lock = this.handler.getWriteLock();
        if (this.handler.isClosed()) {
            throw new SocketException("Connection closed.");
        }
        Object object = lock;
        synchronized (object) {
            while (len > 0) {
                long limit = -1L;
                while (this.handler.getWriteConnection() == null && !this.handler.isClosed()) {
                    long delay;
                    long now = System.currentTimeMillis();
                    if (limit < 0L) {
                        limit = now + 30000L;
                    }
                    if ((delay = limit - now) <= 0L) {
                        throw new InterruptedIOException();
                    }
                    try {
                        lock.wait(delay);
                    }
                    catch (InterruptedException ex) {
                        throw new InterruptedIOException();
                    }
                }
                if (this.handler.isClosed()) {
                    throw new SocketException("Connection closed.");
                }
                HttpConnection connection = this.handler.getWriteConnection();
                int nWritten = connection.write(buffer, off, len);
                if (nWritten <= 0) continue;
                off += nWritten;
                len -= nWritten;
            }
        }
    }
}

