/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.ProxyAuthContext;

public class ProxyAuthData
implements Cloneable {
    private String scheme;
    private ProxyAuthContext context;
    private String user;
    private String pass;

    public ProxyAuthData(String aScheme, ProxyAuthContext aContext) {
        this.scheme = aScheme;
        this.context = aContext;
        this.user = null;
        this.pass = null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ProxyAuthContext getContext() {
        try {
            return (ProxyAuthContext)this.context.clone();
        }
        catch (CloneNotSupportedException cnsx) {
            return null;
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setContextName(String aContext) {
        this.context.setValue(aContext);
    }

    public void setAuthData(String aUser, String aPass) {
        this.user = aUser;
        this.pass = aPass;
    }

    public String getKey() {
        return this.scheme + this.context.getKey();
    }

    public int hashCode() {
        return this.scheme.hashCode() ^ this.context.getValue().hashCode() ^ this.user.hashCode() ^ this.pass.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ProxyAuthData) {
            ProxyAuthData other = (ProxyAuthData)o;
            if (!this.scheme.equals(other.scheme) || !this.context.getValue().equals(other.context.getValue())) {
                return false;
            }
            if (this.user == null) {
                return other.user == null;
            }
            return this.user.equals(other.user) && this.pass.equals(other.pass);
        }
        return false;
    }

    public Object clone() {
        try {
            ProxyAuthData clone = (ProxyAuthData)super.clone();
            clone.context = (ProxyAuthContext)this.context.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

