/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AbstractEndpointSecurity;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointSecurityException;
import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxyEndpoint;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.net.StringsProperties;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class EndpointSecurity
extends AbstractEndpointSecurity {
    protected EndpointSecurity() {
    }

    public static boolean isSecure(Endpoint ep) {
        if (!(ep instanceof ProxyEndpoint)) {
            return false;
        }
        Socket s = ((ProxyEndpoint)ep).getRealSocket();
        try {
            EndpointSecurity.setup();
            return s instanceof SSLSocket;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getCipher(Endpoint ep) {
        Socket socket = null;
        SSLSession session = null;
        if (!(ep instanceof ProxyEndpoint)) {
            return null;
        }
        socket = ((ProxyEndpoint)ep).getRealSocket();
        try {
            SSLSocket sSocket = (SSLSocket)socket;
            EndpointSecurity.setup();
            session = sSocket.getSession();
            return session.getCipherSuite();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isSecureCaller(Endpoint ep) throws IOException {
        if (EndpointSecurity.isSecureCaller(ep, TLSv1_HANDSHAKE)) {
            return true;
        }
        if (EndpointSecurity.isSecureCaller(ep, SSLv3_HANDSHAKE)) {
            return true;
        }
        return EndpointSecurity.isSecureCaller(ep, SSLv2_HANDSHAKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSecureCaller(Endpoint ep, int[] handshake) throws IOException {
        byte[] hdr = new byte[handshake.length];
        int len = 0;
        int timeout = ep.getSoTimeout();
        PushbackInputStream in = (PushbackInputStream)ep.getInputStream();
        try {
            int c;
            ep.setSoTimeout(2000);
            while (len < hdr.length) {
                c = in.read();
                int h = handshake[len];
                if (c < 0) {
                    boolean bl = false;
                    return bl;
                }
                hdr[len++] = (byte)c;
                if (EndpointSecurity.checkSignature(c, h)) continue;
                boolean bl = false;
                return bl;
            }
            c = 1;
            return c != 0;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (len > 0) {
                in.unread(hdr, 0, len);
            }
            ep.setSoTimeout(timeout);
        }
    }

    public static Endpoint secureServer(Endpoint orig, File keystore, char[] keypass, File truststore, char[] trustpass, boolean authClient) throws IOException, FileNotFoundException, EndpointSecurityException {
        return EndpointSecurity.secure(orig, keystore, keypass, truststore, trustpass, null, 0, false, authClient);
    }

    public static Endpoint secureClient(Endpoint orig, String calledName, int calledPort) throws EndpointSecurityException, IOException {
        return EndpointSecurity.secure(orig, calledName, calledPort, true, false);
    }

    public static Endpoint secureClient(Endpoint orig, File keystore, char[] keypass, File truststore, char[] trustpass, String calledName, int calledPort) throws IOException, FileNotFoundException, EndpointSecurityException {
        return EndpointSecurity.secure(orig, keystore, keypass, truststore, trustpass, calledName, calledPort, true, false);
    }

    public static Endpoint secure(Endpoint orig, String calledName, int calledPort, boolean isClient, boolean authClient) throws IOException, EndpointSecurityException {
        EndpointSecurity.setup();
        return EndpointSecurity.doSecure(orig, dftFactory, calledName, calledPort, isClient, authClient);
    }

    public static Endpoint secure(Endpoint orig, File keystore, char[] keypass, File truststore, char[] trustpass, String calledName, int calledPort, boolean isClient, boolean authClient) throws IOException, FileNotFoundException, EndpointSecurityException {
        EndpointSecurity.setup();
        SSLSocketFactory factory = EndpointSecurity.getFactory(keystore, keypass, truststore, trustpass);
        return EndpointSecurity.doSecure(orig, factory, calledName, calledPort, isClient, authClient);
    }

    public static void verifyDestination(Endpoint ep, String host, SSLTargetQuery query) throws EndpointSecurityException {
        if (!(ep instanceof ProxyEndpoint)) {
            return;
        }
        Socket s = ((ProxyEndpoint)ep).getRealSocket();
        if (!(s instanceof SSLSocket)) {
            return;
        }
        X509Certificate[] certChain = null;
        InetAddress sockAddr = null;
        try {
            SSLSocket sSocket = (SSLSocket)s;
            SSLSession session = sSocket.getSession();
            certChain = (X509Certificate[])session.getPeerCertificates();
            sockAddr = s.getInetAddress();
            if (NetDebug.SSL.show()) {
                String cipher = session.getCipherSuite();
                LogSupport.message(EndpointSecurity.class, "verifyDestination", "Session encrypted using " + cipher);
            }
        }
        catch (Exception io) {
            throw new EndpointSecurityException("Unable to verify target of SSL connections.");
        }
        EndpointSecurity.verifyDestination(sockAddr, certChain, host, query);
    }

    private static Endpoint doSecure(Endpoint orig, SSLSocketFactory factory, String calledName, int calledPort, boolean isClient, boolean authClient) throws IOException, EndpointSecurityException {
        Socket sOrig = orig.getSocket();
        SSLSocket sSecure = null;
        ProxyEndpoint secure = null;
        try {
            sSecure = (SSLSocket)factory.createSocket(sOrig, calledName, calledPort, true);
            EndpointSecurity.setCiphers(sSecure);
            sSecure.setUseClientMode(isClient);
            if (!isClient) {
                sSecure.setNeedClientAuth(authClient);
            }
            sSecure.startHandshake();
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            LogSupport.exception(EndpointSecurity.class, "doSecure", t, true);
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_SECUREFAILED, t.toString()));
        }
        secure = new ProxyEndpoint(sSecure);
        secure.setProxy(orig.getProxyAddress(), orig.getProxyPort());
        secure.setFullDuplex(orig.isFullDuplex());
        secure.setCipher(EndpointSecurity.getCipher(sSecure));
        return secure;
    }

    private static void setCiphers(SSLSocket s) throws IOException {
        String suites = System.getProperty("com.elluminate.net.SSLCipherSuites");
        if (suites == null) {
            return;
        }
        StringTokenizer parser = new StringTokenizer(suites, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            list.add(token);
        }
        String[] ciphers = new String[list.size()];
        ciphers = list.toArray(ciphers);
        try {
            s.setEnabledCipherSuites(ciphers);
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(i18n.getString(StringsProperties.ENDPOINTSECURITY_CANTSETUSERCIPHERS, suites));
        }
    }

    public static String getCipher(Socket socket) {
        SSLSession session = null;
        try {
            SSLSocket sSocket = (SSLSocket)socket;
            EndpointSecurity.setup();
            session = sSocket.getSession();
            return session.getCipherSuite();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

