/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOHandler;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.RequestQueue;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.net.InetAddress;

public class AsyncIORequestImpl
extends PooledObject
implements RequestQueue.Queueable,
AsyncIORequest {
    private static final boolean REQUEST_HISTORY = false;
    private static final byte CLASS_MASK = 112;
    private static final byte CONNECTION_CLASS = 16;
    private static final byte IO_CLASS = 32;
    public static final byte CONNECT_REQUEST = 17;
    public static final byte CLOSE_REQUEST = 18;
    public static final byte READ_REQUEST = 33;
    public static final byte WRITE_REQUEST = 34;
    private static final int HIST_INIT = 0;
    private static final int HIST_SET = 1;
    private static final int HIST_ADJUST = 2;
    public static final int HIST_READ = 3;
    public static final int HIST_WRITE = 4;
    private static final int HIST_FINISH = 5;
    static ObjectPool pool = ObjectPool.getInstance(AsyncIORequestImpl.class);
    protected Object lock = new Object();
    protected AsyncEndpoint owner = null;
    protected AsyncIOHandler handler = null;
    protected String host = null;
    protected InetAddress addr = null;
    protected int port = 0;
    protected byte[] buffer = null;
    protected volatile int offset = 0;
    protected volatile int length = 0;
    protected volatile int cursor = 0;
    protected volatile int remaining = 0;
    protected AsyncIOListener listener = null;
    protected byte kind = 0;
    protected IOException iox = null;
    protected int nBytes = 0;
    protected long deadline = -1L;
    protected boolean entireBuffer = false;
    protected HistoryEntry[] historyBuf = new HistoryEntry[16];
    protected int historyLen = 0;
    protected long seq;

    protected void setup(AsyncEndpoint o, AsyncIOHandler h, AsyncIOListener lst) {
        this.owner = o;
        this.handler = h;
        this.listener = lst;
        this.iox = null;
        this.nBytes = 0;
        this.deadline = 0L;
        this.entireBuffer = false;
    }

    protected void initIO(byte[] buf, int off, int len) {
        this.buffer = buf;
        this.offset = off;
        this.length = len;
        this.cursor = this.offset;
        this.remaining = this.length;
    }

    @Override
    public void poCleanup() {
        this.owner = null;
        this.buffer = null;
        this.listener = null;
        this.iox = null;
    }

    @Override
    public AsyncEndpoint getOwner() {
        return this.owner;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public long getTimeout() {
        return this.deadline;
    }

    @Override
    public int getRemaining() {
        return this.remaining;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public boolean isIORequest() {
        return (this.kind & 0x70) == 32;
    }

    @Override
    public boolean isConnectionRequest() {
        return (this.kind & 0x70) == 16;
    }

    @Override
    public boolean isConnectRequest() {
        return this.kind == 17;
    }

    @Override
    public boolean isCloseRequest() {
        return this.kind == 18;
    }

    @Override
    public boolean isReadRequest() {
        return this.kind == 33;
    }

    @Override
    public boolean isWriteRequest() {
        return this.kind == 34;
    }

    @Override
    public int finishRequest() throws IOException {
        return this.finishRequest(0L);
    }

    public int finishRequest(long uid) throws IOException {
        if (this.iox != null) {
            throw this.iox;
        }
        return this.nBytes;
    }

    @Override
    public void setNext(RequestQueue.Queueable q) {
        this.poNext = (AsyncIORequestImpl)q;
    }

    @Override
    public RequestQueue.Queueable getNext() {
        return (AsyncIORequestImpl)this.poNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransferEntireBuffer(boolean all) {
        Object object = this.lock;
        synchronized (object) {
            this.entireBuffer = all;
        }
    }

    @Override
    public boolean getTransferEntireBuffer() {
        return this.entireBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setReady() {
        boolean cont = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.iox != null) {
                cont = false;
            } else {
                this.deadline = 0L;
            }
        }
        return cont;
    }

    public void dispatch() {
        if (this.listener == null) {
            return;
        }
        try {
            switch (this.kind) {
                case 33: {
                    this.listener.readComplete(this);
                    break;
                }
                case 34: {
                    this.listener.writeComplete(this);
                    break;
                }
                case 17: {
                    this.listener.connectComplete(this);
                    break;
                }
                case 18: {
                    this.listener.closeComplete(this);
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception(this, "dispatch", t, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean done = false;
        int n = 0;
        try {
            switch (this.kind) {
                case 33: {
                    n = this.handler.actualRead(this, this.buffer, this.cursor, this.remaining);
                    this.setBytesTransferred(n);
                    done = n > 0;
                    break;
                }
                case 34: {
                    n = this.handler.actualWrite(this, this.buffer, this.cursor, this.remaining);
                    this.setBytesTransferred(n);
                    done = n > 0;
                    break;
                }
                case 17: {
                    done = this.handler.actualConnect(this, this.addr, this.port);
                    break;
                }
                case 18: {
                    done = this.handler.actualClose(this);
                }
            }
        }
        catch (IOException x) {
            Object object = this.lock;
            synchronized (object) {
                this.iox = x;
            }
            done = true;
        }
        if (done) {
            this.dispatch();
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adjustBytesTransferred(int n, long uid) {
        boolean done;
        Object object = this.lock;
        synchronized (object) {
            if (n > this.remaining) {
                throw new RuntimeException("Transfer " + n + " bytes on a request with only " + this.remaining + " left: " + this);
            }
            this.nBytes += n;
            this.cursor += n;
            this.remaining -= n;
            done = this.remaining == 0 || !this.entireBuffer;
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesTransferred(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n > this.remaining) {
                throw new RuntimeException("Transfer " + n + " bytes on a request with only " + this.remaining + " left: " + this);
            }
            this.cursor = this.offset + n;
            this.remaining = this.length - n;
            this.nBytes = n;
        }
    }

    public void complete(int n) {
        this.setBytesTransferred(n);
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(IOException iox) {
        Object object = this.lock;
        synchronized (object) {
            this.iox = iox;
        }
        this.dispatch();
    }

    public long getRequestId() {
        return this.seq;
    }

    public void addHistory(int op, long uid, int off, int len, int n) {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        switch (this.kind) {
            case 17: {
                buf.append("[CONNECT] = ");
                break;
            }
            case 18: {
                buf.append("[CLOSE] = ");
                break;
            }
            case 33: 
            case 34: {
                if (this.kind == 33) {
                    buf.append("[READ:");
                } else {
                    buf.append("[WRITE:");
                }
                buf.append(this.seq);
                buf.append("(byte[");
                buf.append(this.buffer.length);
                buf.append("],");
                buf.append(this.offset);
                buf.append(":");
                buf.append(this.cursor);
                buf.append(",");
                buf.append(this.length);
                buf.append(":");
                buf.append(this.remaining);
                buf.append(") = ");
                break;
            }
            default: {
                buf.append("[*UNKNOWN*]");
            }
        }
        if (this.iox != null) {
            buf.append(this.iox);
        } else {
            buf.append(this.nBytes);
        }
        if (this.historyLen > 0) {
            buf.append("\n  [\n");
            for (int i = 0; i < this.historyLen; ++i) {
                buf.append("    ");
                buf.append(this.historyBuf[i]);
                buf.append("\n");
            }
            buf.append("  ]");
        }
        return buf.toString();
    }

    public static AsyncIORequestImpl getReadReq(AsyncEndpoint owner, byte[] buf, int off, int len, AsyncIOHandler handler, AsyncIOListener lst) {
        return AsyncIORequestImpl.getReadReq(owner, buf, off, len, 0, handler, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIORequestImpl getReadReq(AsyncEndpoint owner, byte[] buf, int off, int len, int timeout, AsyncIOHandler handler, AsyncIOListener lst) {
        AsyncIORequestImpl req = (AsyncIORequestImpl)pool.alloc();
        Object object = req.lock;
        synchronized (object) {
            req.setup(owner, handler, lst);
            req.initIO(buf, off, len);
            req.kind = (byte)33;
            if (timeout > 0) {
                req.deadline = System.currentTimeMillis() + (long)timeout;
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIORequestImpl getWriteReq(AsyncEndpoint owner, byte[] buf, int off, int len, AsyncIOHandler handler, AsyncIOListener lst) {
        AsyncIORequestImpl req = (AsyncIORequestImpl)pool.alloc();
        Object object = req.lock;
        synchronized (object) {
            req.setup(owner, handler, lst);
            req.initIO(buf, off, len);
            req.kind = (byte)34;
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIORequestImpl getConnectReq(AsyncEndpoint owner, InetAddress addr, int port, AsyncIOHandler handler, AsyncIOListener lst) {
        AsyncIORequestImpl req = (AsyncIORequestImpl)pool.alloc();
        Object object = req.lock;
        synchronized (object) {
            req.setup(owner, handler, lst);
            req.addr = addr;
            req.port = port;
            req.kind = (byte)17;
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIORequestImpl getConnectReq(AsyncEndpoint owner, String host, int port, AsyncIOHandler handler, AsyncIOListener lst) {
        AsyncIORequestImpl req = (AsyncIORequestImpl)pool.alloc();
        Object object = req.lock;
        synchronized (object) {
            req.setup(owner, handler, lst);
            req.host = host;
            req.port = port;
            req.kind = (byte)17;
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncIORequestImpl getCloseReq(AsyncEndpoint owner, AsyncIOHandler handler, AsyncIOListener lst) {
        AsyncIORequestImpl req = (AsyncIORequestImpl)pool.alloc();
        Object object = req.lock;
        synchronized (object) {
            req.setup(owner, handler, lst);
            req.kind = (byte)18;
        }
        return req;
    }

    private static class HistoryEntry {
        private String thread;
        private long uid;
        private int op;
        private int delta;
        private int cursorBefore;
        private int cursorAfter;
        private int remainingBefore;
        private int remainingAfter;
        private int nBytesBefore;
        private int nBytesAfter;

        public void init(int cursor, int remaining) {
            this.op = 0;
            this.cursorBefore = cursor;
            this.remainingBefore = remaining;
            this.thread = Thread.currentThread().getName();
        }

        public void before(int op, long id, int n, int cursor, int remaining, int nBytes) {
            this.op = op;
            this.uid = id;
            this.thread = Thread.currentThread().getName();
            this.delta = n;
            this.cursorBefore = cursor;
            this.remainingBefore = remaining;
            this.nBytesBefore = nBytes;
        }

        public void after(int cursor, int remaining, int nBytes) {
            this.cursorAfter = cursor;
            this.remainingAfter = remaining;
            this.nBytesAfter = nBytes;
        }

        public void clear() {
            this.thread = null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getOp());
            buf.append("<");
            buf.append(this.thread);
            buf.append('/');
            buf.append(this.uid);
            buf.append(':');
            if (this.op == 0) {
                buf.append(this.cursorBefore);
                buf.append(':');
                buf.append(this.remainingBefore);
            } else if (this.op == 1 || this.op == 2) {
                buf.append(this.delta);
                buf.append(':');
                buf.append(this.cursorBefore);
                buf.append("->");
                buf.append(this.cursorAfter);
                buf.append(":");
                buf.append(this.remainingBefore);
                buf.append("->");
                buf.append(this.remainingAfter);
                buf.append(":");
                buf.append(this.nBytesBefore);
                buf.append("->");
                buf.append(this.nBytesAfter);
            } else if (this.op == 5) {
                buf.append(this.delta);
            } else {
                buf.append(this.cursorBefore);
                buf.append(",");
                buf.append(this.remainingBefore);
                buf.append("=");
                buf.append(this.delta);
            }
            buf.append(">");
            return buf.toString();
        }

        private String getOp() {
            switch (this.op) {
                case 0: {
                    return "init";
                }
                case 1: {
                    return "set";
                }
                case 2: {
                    return "adjust";
                }
                case 3: {
                    return "read";
                }
                case 4: {
                    return "write";
                }
                case 5: {
                    return "finish";
                }
            }
            return "UNKNOWN=" + this.op;
        }
    }
}

