/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncSecurityListener;
import com.elluminate.net.CertPrincipals;
import com.elluminate.net.EndpointSecurityException;
import com.elluminate.net.NetDebug;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.net.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class AbstractEndpointSecurity {
    protected static I18n i18n = I18n.create(AbstractEndpointSecurity.class);
    static final int HS_IGNORE = -1;
    static final int HS_V2_MAJOR = -2;
    static final int HS_V2_MINOR = -3;
    static final int HS_TLS_MINOR = -4;
    static final int[] SSLv2_HANDSHAKE = new int[]{128, -1, 1, -2, -3};
    static final int[] SSLv3_HANDSHAKE = new int[]{22, 3, 0, -1, -1, 1, -1, -1, -1, 3, 0};
    static final int[] TLSv1_HANDSHAKE = new int[]{22, 3, -4, -1, -1, 1, -1, -1, -1, 3, -4};
    protected static boolean setupComplete = false;
    protected static boolean setupFailed = false;
    protected static String dftProvider = null;
    protected static SSLContext dftContext;
    protected static SSLSocketFactory dftFactory;
    protected static Method createEngine;
    protected static Class<?> sslEngineCls;
    protected static Class<?> asyncSSLEndpointCls;
    protected static Constructor<?> clientAsyncSSLEndpoint;
    protected static Constructor<?> serverAsyncSSLEndpoint;
    protected static Method getAsyncCertChain;
    protected static Object lock;
    protected static Class<?>[] emptySig;
    protected static Object[] emptyArgs;
    protected static String[] noCiphers;
    protected static boolean alwaysValidate;

    protected AbstractEndpointSecurity() {
    }

    public static void setAlwaysAcceptValidation(boolean validate) {
        alwaysValidate = validate;
    }

    public static boolean isAvailable() {
        try {
            AbstractEndpointSecurity.setup();
        }
        catch (EndpointSecurityException ex) {
            return false;
        }
        return setupComplete && !setupFailed;
    }

    public static String[] getCiphers() {
        try {
            AbstractEndpointSecurity.setup();
            return dftFactory.getSupportedCipherSuites();
        }
        catch (Throwable t) {
            return noCiphers;
        }
    }

    protected static void verifyDestination(InetAddress sockAddr, X509Certificate[] certChain, String host, SSLTargetQuery query) throws EndpointSecurityException {
        try {
            String DN = certChain[0].getSubjectDN().getName();
            int idx = host.indexOf(46);
            String domain = idx > 0 ? host.substring(idx) : "";
            String CN = "";
            HashSet<String> names = new HashSet<String>();
            idx = DN.indexOf("CN=");
            if (idx >= 0 && (idx = (CN = DN.substring(idx + 3)).indexOf(44)) >= 0) {
                CN = CN.substring(0, idx);
                names.add(CN);
            }
            if (AbstractEndpointSecurity.nameMatches(CN, host, domain)) {
                return;
            }
            Collection<List<?>> alt = certChain[0].getSubjectAlternativeNames();
            if (alt != null) {
                for (List<?> name : alt) {
                    Integer type = (Integer)name.get(0);
                    switch (type) {
                        case 2: {
                            String nm = (String)name.get(1);
                            if (AbstractEndpointSecurity.nameMatches(nm, host, domain)) {
                                return;
                            }
                            names.add(nm);
                            break;
                        }
                    }
                }
            }
            CertPrincipals[] pChain = new CertPrincipals[certChain.length];
            for (int i = 0; i < certChain.length; ++i) {
                X509Certificate cert = certChain[i];
                Principal subject = cert.getSubjectDN();
                Principal issuer = cert.getIssuerDN();
                pChain[i] = new CertPrincipals(subject, issuer);
            }
            if (alwaysValidate) {
                return;
            }
            if (query != null) {
                TreeSet ordered = new TreeSet(names);
                StringBuilder builder = new StringBuilder();
                int n = 0;
                for (String nm : ordered) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(nm);
                    ++n;
                    if (builder.length() <= 1024) continue;
                    break;
                }
                if (n < ordered.size()) {
                    builder.append(", and ");
                    builder.append(ordered.size() - n);
                    builder.append(" more...");
                }
                if (query.allowConnection(host, sockAddr, builder.toString(), pChain)) {
                    return;
                }
            }
        }
        catch (Exception io) {
            // empty catch block
        }
        throw new EndpointSecurityException("Unable to verify target of SSL connections.");
    }

    private static boolean nameMatches(String name, String host, String domain) {
        if (name.startsWith("*.")) {
            return domain.equalsIgnoreCase(name.substring(1));
        }
        return host.equalsIgnoreCase(name);
    }

    protected static boolean checkSignature(int chr, int hdr) {
        if (chr < 0) {
            return false;
        }
        switch (hdr) {
            case -1: {
                return true;
            }
            case -2: {
                return chr == 2 || chr == 3;
            }
            case -3: {
                return chr >= 0 && chr <= 1;
            }
            case -4: {
                return chr >= 1 && chr <= 3;
            }
        }
        return chr == hdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setup() throws EndpointSecurityException {
        if (setupComplete) {
            return;
        }
        if (setupFailed) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        Object object = lock;
        synchronized (object) {
            if (!setupComplete && !setupFailed) {
                try {
                    dftProvider = System.getProperty("com.elluminate.net.sslProvider");
                    if (dftProvider != null) {
                        if (dftProvider.indexOf(46) > 0) {
                            Class<?> providerCls = Class.forName(dftProvider);
                            Provider provider = (Provider)providerCls.newInstance();
                            Security.addProvider(provider);
                            dftProvider = provider.getName();
                        }
                        dftContext = SSLContext.getInstance("SSL", dftProvider);
                    } else {
                        dftContext = SSLContext.getInstance("SSL");
                    }
                    dftContext.init(null, null, null);
                    dftFactory = dftContext.getSocketFactory();
                    try {
                        createEngine = SSLContext.class.getMethod("createSSLEngine", emptySig);
                        sslEngineCls = Class.forName("javax.net.ssl.SSLEngine");
                        asyncSSLEndpointCls = Class.forName("com.elluminate.net.nio.ssl.AsyncSSLEndpoint");
                        Class[] clientSig = new Class[]{AsyncEndpoint.class, sslEngineCls, AsyncSecurityListener.class};
                        Class[] serverSig = new Class[]{AsyncEndpoint.class, sslEngineCls, Boolean.TYPE, AsyncSecurityListener.class};
                        clientAsyncSSLEndpoint = asyncSSLEndpointCls.getConstructor(clientSig);
                        serverAsyncSSLEndpoint = asyncSSLEndpointCls.getConstructor(serverSig);
                        getAsyncCertChain = asyncSSLEndpointCls.getMethod("getPeerCertificates", emptySig);
                    }
                    catch (Throwable t) {
                        sslEngineCls = null;
                        asyncSSLEndpointCls = null;
                        createEngine = null;
                        clientAsyncSSLEndpoint = null;
                        serverAsyncSSLEndpoint = null;
                        getAsyncCertChain = null;
                    }
                    setupComplete = true;
                    if (NetDebug.SSL.show()) {
                        String[] ciphers = AbstractEndpointSecurity.getCiphers();
                        StringBuffer buf = new StringBuffer();
                        buf.append("Supported SSL Ciphers:");
                        for (int i = 0; i < ciphers.length; ++i) {
                            buf.append("\n    ");
                            buf.append(ciphers[i]);
                        }
                        LogSupport.message(AbstractEndpointSecurity.class, "setup", buf.toString());
                    }
                }
                catch (Throwable t) {
                    if (NetDebug.SSL.show()) {
                        LogSupport.exception(AbstractEndpointSecurity.class, "setup", t, true);
                    }
                    setupFailed = true;
                }
            }
        }
        if (setupFailed) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
    }

    protected static SSLSocketFactory getFactory(File ks, char[] kp, File ts, char[] tp) throws FileNotFoundException, EndpointSecurityException {
        AbstractEndpointSecurity.setup();
        SSLContext context = AbstractEndpointSecurity.getContext(ks, kp, ts, tp);
        SSLSocketFactory factory = null;
        try {
            factory = context.getSocketFactory();
        }
        catch (Exception ex) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return factory;
    }

    protected static SSLSocketFactory getDefaultFactory() throws EndpointSecurityException {
        AbstractEndpointSecurity.setup();
        SSLContext context = AbstractEndpointSecurity.getDefaultContext();
        SSLSocketFactory factory = null;
        try {
            factory = context.getSocketFactory();
        }
        catch (Exception ex) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return factory;
    }

    protected static SSLContext getDefaultContext() throws EndpointSecurityException {
        SSLContext context = null;
        AbstractEndpointSecurity.setup();
        try {
            context = dftProvider == null ? SSLContext.getInstance("SSL") : SSLContext.getInstance("SSL", dftProvider);
            context.init(null, null, null);
        }
        catch (Exception ex) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return context;
    }

    protected static SSLContext getContext(File ks, char[] kp, File ts, char[] tp) throws FileNotFoundException, EndpointSecurityException {
        AbstractEndpointSecurity.setup();
        KeyManager[] keyManagers = AbstractEndpointSecurity.getKeyManagers(ks, kp);
        TrustManager[] trustManagers = AbstractEndpointSecurity.getTrustManagers(ts, tp);
        SSLContext context = null;
        try {
            context = dftProvider == null ? SSLContext.getInstance("SSL") : SSLContext.getInstance("SSL", dftProvider);
            context.init(keyManagers, trustManagers, null);
        }
        catch (Exception ex) {
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return context;
    }

    private static KeyManager[] getKeyManagers(File f, char[] pw) throws FileNotFoundException, EndpointSecurityException {
        if (f == null) {
            return null;
        }
        AbstractEndpointSecurity.setup();
        KeyManager[] keyManagers = null;
        KeyStore keystore = AbstractEndpointSecurity.getKeyStore(f, pw);
        try {
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
            factory.init(keystore, pw);
            keyManagers = factory.getKeyManagers();
        }
        catch (Exception ex) {
            if (ex instanceof FileNotFoundException) {
                throw (FileNotFoundException)ex;
            }
            if (ex instanceof EndpointSecurityException) {
                throw (EndpointSecurityException)ex;
            }
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return keyManagers;
    }

    private static TrustManager[] getTrustManagers(File f, char[] pw) throws FileNotFoundException, EndpointSecurityException {
        if (f == null) {
            return null;
        }
        AbstractEndpointSecurity.setup();
        TrustManager[] trustManagers = null;
        KeyStore keystore = AbstractEndpointSecurity.getKeyStore(f, pw);
        try {
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init(keystore);
            trustManagers = factory.getTrustManagers();
        }
        catch (Exception ex) {
            if (ex instanceof FileNotFoundException) {
                throw (FileNotFoundException)ex;
            }
            if (ex instanceof EndpointSecurityException) {
                throw (EndpointSecurityException)ex;
            }
            throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_UNAVAILABLE));
        }
        return trustManagers;
    }

    public static boolean checkKeyStore(File f, char[] pw) {
        try {
            AbstractEndpointSecurity.getKeyStore(f, pw);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(File f, char[] pw) throws EndpointSecurityException, FileNotFoundException {
        String[] types = new String[]{"JKS", "PKCS12"};
        AbstractEndpointSecurity.setup();
        for (int i = 0; i < types.length; ++i) {
            FileInputStream str = new FileInputStream(f);
            try {
                KeyStore ks = KeyStore.getInstance(types[i]);
                ks.load(str, pw);
                KeyStore keyStore = ks;
                return keyStore;
            }
            catch (Exception ex) {
                continue;
            }
            finally {
                try {
                    str.close();
                }
                catch (IOException io) {}
            }
        }
        throw new EndpointSecurityException(i18n.getString(StringsProperties.ENDPOINTSECURITY_CANTLOADKEYSTORE, f.getPath()));
    }

    static {
        createEngine = null;
        sslEngineCls = null;
        asyncSSLEndpointCls = null;
        clientAsyncSSLEndpoint = null;
        serverAsyncSSLEndpoint = null;
        getAsyncCertChain = null;
        lock = new Object();
        emptySig = new Class[0];
        emptyArgs = new Object[0];
        noCiphers = new String[0];
        alwaysValidate = false;
    }
}

