/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIOHandler;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.AsyncIORequestImpl;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractAsyncEndpoint
implements AsyncEndpoint {
    protected static final int ST_DISCONNECTED = 0;
    protected static final int ST_CONNECTING = 1;
    protected static final int ST_FINISHING_CONNECTION = 2;
    protected static final int ST_CONNECTED = 3;
    protected static final int ST_DISCONNECTING = 4;
    protected AtomicInteger state = new AtomicInteger(0);
    private int timeout = 0;
    private String epid = null;
    private String calledName = null;
    private int calledPort = -1;
    protected AsyncIOHandler handler = null;
    private CompleteIO complete;
    private Object pushbackLock = new Object();
    private volatile Pushback pushback = null;

    protected AbstractAsyncEndpoint() {
        this.handler = new AsyncIOHandler(){

            @Override
            public boolean actualConnect(AsyncIORequestImpl req, InetAddress addr, int port) throws IOException {
                return AbstractAsyncEndpoint.this.actualConnect(req, addr, port);
            }

            @Override
            public boolean actualClose(AsyncIORequestImpl req) throws IOException {
                return AbstractAsyncEndpoint.this.actualClose(req);
            }

            @Override
            public int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
                return AbstractAsyncEndpoint.this.actualRead(req, buf, off, len);
            }

            @Override
            public int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
                return AbstractAsyncEndpoint.this.actualWrite(req, buf, off, len);
            }
        };
        this.complete = new CompleteIO();
    }

    @Override
    public abstract InetAddress getInetAddress();

    @Override
    public abstract int getPort();

    @Override
    public abstract InetAddress getLocalAddress();

    @Override
    public abstract int getLocalPort();

    @Override
    public boolean isConnected() {
        return this.state.get() == 3;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isFullDuplex() {
        return true;
    }

    @Override
    public String getTunnelingMethod() {
        return "direct";
    }

    @Override
    public String getCipher() {
        return null;
    }

    @Override
    public void beginConnect(String host, int port, AsyncIOListener lst) throws UnknownHostException {
        this.setCalled(host, port);
        this.beginConnect(InetAddress.getByName(host), port, lst);
    }

    @Override
    public abstract void beginConnect(InetAddress var1, int var2, AsyncIOListener var3);

    @Override
    public abstract int beginWrite(byte[] var1, int var2, int var3, AsyncIOListener var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int beginRead(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
        this.rangeCheck(buffer.length, off, len);
        Object object = this.pushbackLock;
        synchronized (object) {
            int nBytes;
            if (this.pushback != null && (nBytes = this.reread(buffer, off, len)) > 0) {
                return nBytes;
            }
        }
        return this.beginReadImpl(buffer, off, len, lst);
    }

    @Override
    public boolean beginReadFully(byte[] buffer, AsyncIOListener lst) throws IOException {
        return this.complete.read(buffer, 0, buffer.length, lst);
    }

    @Override
    public boolean beginReadFully(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
        this.rangeCheck(buffer.length, off, len);
        return this.complete.read(buffer, off, len, lst);
    }

    @Override
    public boolean beginWriteFully(byte[] buffer, AsyncIOListener lst) throws IOException {
        return this.complete.write(buffer, 0, buffer.length, lst);
    }

    @Override
    public boolean beginWriteFully(byte[] buffer, int off, int len, AsyncIOListener lst) throws IOException {
        this.rangeCheck(buffer.length, off, len);
        return this.complete.write(buffer, off, len, lst);
    }

    protected abstract int beginReadImpl(byte[] var1, int var2, int var3, AsyncIOListener var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unread(byte[] buffer, int off, int len) {
        this.rangeCheck(buffer.length, off, len);
        Object object = this.pushbackLock;
        synchronized (object) {
            Pushback push = new Pushback(buffer, off, len);
            push.next = this.pushback;
            this.pushback = push;
        }
    }

    @Override
    public void beginClose(AsyncIOListener lst) {
        AsyncCloser closer = new AsyncCloser(AsyncIORequestImpl.getCloseReq(this, this.handler, lst));
        closer.start();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.setTimeoutHook();
    }

    protected void setTimeoutHook() {
    }

    @Override
    public abstract int getLinger() throws SocketException;

    @Override
    public abstract void setLinger(int var1) throws SocketException;

    protected abstract int actualRead(AsyncIORequestImpl var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract int actualWrite(AsyncIORequestImpl var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract boolean actualConnect(AsyncIORequestImpl var1, InetAddress var2, int var3) throws IOException;

    protected void setCalled(String name, int port) {
        this.calledName = name;
        this.calledPort = port;
    }

    protected void setCalled(InetAddress addr, int port) {
        if (this.calledName != null) {
            return;
        }
        String str = addr.toString();
        int slash = str.indexOf(47);
        if (slash < 0) {
            this.calledName = str;
        } else {
            String host = str.substring(0, slash);
            String ip = str.substring(slash + 1);
            this.calledName = host.length() > 0 ? host : ip;
        }
        this.calledPort = port;
    }

    @Override
    public String getCalledName() {
        return this.calledName;
    }

    @Override
    public int getCalledPort() {
        return this.calledPort;
    }

    protected abstract boolean actualClose(AsyncIORequestImpl var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reread(byte[] buf, int off, int len) {
        int nRead = 0;
        Object object = this.pushbackLock;
        synchronized (object) {
            while (len > 0 && this.pushback != null) {
                int n = this.pushback.read(buf, off, len);
                nRead += n;
                off += n;
                len -= n;
                if (!this.pushback.isEmpty()) continue;
                this.pushback = this.pushback.next;
            }
        }
        return nRead;
    }

    public String toString() {
        if (this.epid != null) {
            return this.epid;
        }
        if (!this.isConnected()) {
            return "AsyncEndpoint(" + System.identityHashCode(this) + ")";
        }
        this.epid = "AsyncEndpoint(" + this.getLocalAddress() + ":" + this.getLocalPort() + "/" + this.getInetAddress() + ":" + this.getPort() + ")";
        return this.epid;
    }

    protected void rangeCheck(int size, int off, int len) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset " + off + ", length " + len + ", size " + size);
        }
    }

    private class AsyncCloser
    extends Thread {
        AsyncIORequestImpl req;

        public AsyncCloser(AsyncIORequestImpl req) {
            super("AsyncCloser-" + AbstractAsyncEndpoint.this.epid);
            this.req = req;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.req.execute();
        }
    }

    private class CompleteIO
    extends AsyncIOAdapter {
        private AsyncIORequestImpl rReq;
        private AsyncIORequestImpl wReq;
        private Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean read(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
            AsyncIORequestImpl r;
            if (len == 0) {
                return true;
            }
            int n = 0;
            Object object = this.lock;
            synchronized (object) {
                if (this.rReq != null) {
                    throw new IllegalStateException("Begin complete read while one is already in progress!");
                }
                this.rReq = AsyncIORequestImpl.getReadReq(AbstractAsyncEndpoint.this, buf, off, len, null, lst);
                this.rReq.setTransferEntireBuffer(true);
                r = this.rReq;
            }
            boolean done = false;
            try {
                do {
                    int subOff = r.getCursor();
                    int subLen = r.getRemaining();
                    n = AbstractAsyncEndpoint.this.beginRead(r.getBuffer(), subOff, subLen, this);
                    r.addHistory(3, 0L, subOff, subLen, n);
                    if (n <= 0) continue;
                    done = r.adjustBytesTransferred(n, 0L);
                } while (!done && n > 0);
            }
            catch (IOException iox) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.rReq = null;
                }
                r.dispose();
                throw iox;
            }
            if (done) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.rReq = null;
                }
                r.dispose();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean write(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
            AsyncIORequestImpl w;
            if (len == 0) {
                return true;
            }
            int n = 0;
            Object object = this.lock;
            synchronized (object) {
                if (this.wReq != null) {
                    throw new IllegalStateException("Begin complete write while one is already in progress!");
                }
                this.wReq = AsyncIORequestImpl.getWriteReq(AbstractAsyncEndpoint.this, buf, off, len, null, lst);
                this.wReq.setTransferEntireBuffer(true);
                w = this.wReq;
            }
            boolean done = false;
            try {
                do {
                    int subOff = w.getCursor();
                    int subLen = w.getRemaining();
                    n = AbstractAsyncEndpoint.this.beginWrite(w.getBuffer(), subOff, subLen, this);
                    w.addHistory(4, 0L, subOff, subLen, n);
                    if (n <= 0) continue;
                    done = w.adjustBytesTransferred(n, 0L);
                } while (!done && n > 0);
            }
            catch (IOException iox) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.wReq = null;
                }
                w.dispose();
                throw iox;
            }
            if (done) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.wReq = null;
                }
                w.dispose();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readComplete(AsyncIORequest req) {
            AsyncIORequestImpl r;
            boolean done = false;
            long id = ((AsyncIORequestImpl)req).getRequestId();
            Object object = this.lock;
            synchronized (object) {
                r = this.rReq;
            }
            if (r.getBuffer() != req.getBuffer() || r.getCursor() != req.getOffset() || r.getRemaining() != req.getLength()) {
                LogSupport.error(this, "readComplete", "Completed read state does not match issuing request: \n  Received " + req + "\n  against " + r);
            }
            try {
                int n = ((AsyncIORequestImpl)req).finishRequest(id);
                do {
                    try {
                        done = r.adjustBytesTransferred(n, id);
                    }
                    catch (RuntimeException rtx) {
                        LogSupport.error(this, "readComplete", "Exception while processing request: " + req + "\n  " + rtx.getMessage());
                        throw rtx;
                    }
                    if (done) continue;
                    int subOff = r.getCursor();
                    int subLen = r.getRemaining();
                    n = AbstractAsyncEndpoint.this.beginRead(r.getBuffer(), subOff, subLen, this);
                    id = 0L;
                    r.addHistory(3, id, subOff, subLen, n);
                } while (!done && n > 0);
            }
            catch (IOException iox) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.rReq = null;
                }
                r.fail(iox);
                r.dispose();
                return;
            }
            if (done) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.rReq = null;
                }
                r.dispatch();
                r.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeComplete(AsyncIORequest req) {
            AsyncIORequestImpl w;
            boolean done = false;
            long id = ((AsyncIORequestImpl)req).getRequestId();
            Object object = this.lock;
            synchronized (object) {
                w = this.wReq;
            }
            if (w.getBuffer() != req.getBuffer() || w.getCursor() != req.getOffset() || w.getRemaining() != req.getLength()) {
                LogSupport.error(this, "writeComplete", "Completed write state does not match issuing request: \n  Received " + req + "\n  against " + w);
            }
            try {
                int n = ((AsyncIORequestImpl)req).finishRequest(id);
                do {
                    try {
                        done = w.adjustBytesTransferred(n, id);
                    }
                    catch (RuntimeException rtx) {
                        LogSupport.error(this, "writeComplete", "Exception while processing request: " + req + "\n  " + rtx.getMessage());
                        throw rtx;
                    }
                    if (done) continue;
                    int subOff = w.getCursor();
                    int subLen = w.getRemaining();
                    n = AbstractAsyncEndpoint.this.beginWrite(w.getBuffer(), subOff, subLen, this);
                    id = 0L;
                    w.addHistory(4, id, subOff, subLen, n);
                } while (!done && n > 0);
            }
            catch (IOException iox) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.wReq = null;
                }
                w.fail(iox);
                w.dispose();
                return;
            }
            if (done) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.wReq = null;
                }
                w.dispatch();
                w.dispose();
            }
        }
    }

    private static class Pushback {
        Pushback next;
        byte[] buffer;
        int offset;
        int length;

        public Pushback(byte[] buf, int off, int len) {
            this.buffer = new byte[len];
            this.offset = 0;
            this.length = len;
            System.arraycopy(buf, off, this.buffer, this.offset, len);
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public int read(byte[] buf, int off, int len) {
            int n = Math.min(len, this.length);
            System.arraycopy(this.buffer, this.offset, buf, off, n);
            this.offset += n;
            this.length -= n;
            return n;
        }
    }
}

